/*
 * Decompiled with CFR 0.152.
 */
package application.shared.ui.system;

import androidx.compose.runtime.internal.StabilityInferred;
import application.core.system.linux.FreedesktopKt;
import application.presentation.system.DefaultBrowserHandler;
import application.shared.desktop.platform.LinuxInstallationKt;
import application.shared.ui.system.LinuxDefaultBrowserHandlerKt;
import java.io.File;
import java.util.Iterator;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import shared.system.install.JvmInstallationKt;
import shared.system.process.DesktopSystemKt;

@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nLinuxDefaultBrowserHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinuxDefaultBrowserHandler.kt\napplication/shared/ui/system/LinuxDefaultBrowserHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,41:1\n385#2,11:42\n*S KotlinDebug\n*F\n+ 1 LinuxDefaultBrowserHandler.kt\napplication/shared/ui/system/LinuxDefaultBrowserHandler\n*L\n21#1:42,11\n*E\n"})
public final class LinuxDefaultBrowserHandler
implements DefaultBrowserHandler {
    public final Object queryCanBeSetAsDefaultBrowser(Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((JvmInstallationKt.isRunningFromDistributable() && LinuxInstallationKt.linuxFindOwnFreedesktopDesktopFile() != null ? 1 : 0) != 0);
    }

    public final Object queryIsDefaultBrowser(Continuation<? super Boolean> $completion) {
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        stringArray[0] = "xdg-settings";
        stringArray2[1] = "get";
        stringArray2[2] = "default-web-browser";
        return DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, LinuxDefaultBrowserHandler::queryIsDefaultBrowser$lambda$4);
    }

    /*
     * WARNING - void declaration
     */
    public final Object requestSetAsDefaultBrowser(Function0<Unit> onDone, Continuation<? super Unit> $completion) {
        void var1_1;
        void var2_2;
        File desktopFile = LinuxInstallationKt.linuxFindOwnFreedesktopDesktopFile();
        if (desktopFile == null) {
            LinuxDefaultBrowserHandlerKt.access$getLogger$p().warn(LinuxDefaultBrowserHandler::requestSetAsDefaultBrowser$lambda$5);
            return Unit.INSTANCE;
        }
        String[] stringArray = new String[4];
        String[] stringArray2 = stringArray;
        stringArray[0] = "xdg-settings";
        stringArray2[1] = "set";
        stringArray2[2] = "default-web-browser";
        stringArray2[3] = var2_2.getName();
        DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, LinuxDefaultBrowserHandler::requestSetAsDefaultBrowser$lambda$6);
        var1_1.invoke();
        return Unit.INSTANCE;
    }

    private static final Object queryIsDefaultBrowser$lambda$4$lambda$3$lambda$2$lambda$1(File $desktopFile) {
        return "Not the default browser, currently '" + $desktopFile + "'";
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean queryIsDefaultBrowser$lambda$4(String desktopFileName) {
        boolean bl;
        Object object;
        block4: {
            void var2_3;
            Iterator iterator;
            Intrinsics.checkNotNullParameter((Object)desktopFileName, (String)"desktopFileName");
            Sequence $this$singleOrNull$iv = FreedesktopKt.findFreedesktopDesktopFiles();
            Object single$iv = null;
            boolean found$iv = false;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                File file = (File)element$iv;
                if (!Intrinsics.areEqual((Object)file.getName(), (Object)desktopFileName)) continue;
                if (found$iv) {
                    object = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !bl ? null : var2_3;
        }
        desktopFileName = (File)object;
        if (desktopFileName != null) {
            Object desktopFile = desktopFileName;
            boolean bl2 = bl = LinuxInstallationKt.linuxIsOwnFreedesktopDesktopFile((File)desktopFile);
            if (!bl) {
                Object object2;
                LinuxDefaultBrowserHandlerKt.access$getLogger$p().info(() -> LinuxDefaultBrowserHandler.queryIsDefaultBrowser$lambda$4$lambda$3$lambda$2$lambda$1((File)object2));
            }
            return bl;
        }
        return false;
    }

    private static final Object requestSetAsDefaultBrowser$lambda$5() {
        return "Freedesktop Desktop File not found while setting default browser, aborting!";
    }

    private static final Unit requestSetAsDefaultBrowser$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

