/*
 * Decompiled with CFR 0.152.
 */
package application.shared.ui.notifications;

import androidx.compose.ui.window.Tray_desktopKt;
import application.core.notifications.NotificationAction;
import application.core.notifications.Notifications;
import application.core.notifications.SystemNotification;
import application.core.notifications.Toast;
import application.shared.ui.notifications.AwtToasterFactory;
import application.shared.ui.notifications.SystemNotificationHandler;
import com.sshtools.twoslices.ToastBuilder;
import com.sshtools.twoslices.ToastType;
import com.sshtools.twoslices.ToasterFactory;
import com.sshtools.twoslices.ToasterSettings;
import com.sshtools.twoslices.impl.AWTToaster;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.net.URL;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import shared.system.files.ApplicationDirectories;
import shared.system.files.FilesKt;
import shared.system.os.DesktopOS;
import shared.system.os.DesktopOSKt;
import shared.system.process.DesktopSystemKt;

public final class SystemNotificationHandler_desktopKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(SystemNotificationHandler_desktopKt::logger$lambda$0);
    private static final Lazy isLinuxNotifySendAvailable$delegate = LazyKt.lazy(SystemNotificationHandler_desktopKt::isLinuxNotifySendAvailable_delegate$lambda$15);
    private static final Lazy isToasterInitialized$delegate = LazyKt.lazy(SystemNotificationHandler_desktopKt::isToasterInitialized_delegate$lambda$21);

    /*
     * WARNING - void declaration
     */
    public static final Object dispatchSystemNotification(ApplicationDirectories applicationDirectories, Notifications notifications, SystemNotification notification, Continuation<? super Unit> $completion) {
        Lazy lazy;
        if (DesktopOSKt.getCurrentDesktopOS() == DesktopOS.Linux && ((Boolean)(lazy = isLinuxNotifySendAvailable$delegate).getValue()).booleanValue()) {
            logger.info(() -> SystemNotificationHandler_desktopKt.dispatchSystemNotification$lambda$1((SystemNotification)notification));
            ApplicationDirectories applicationDirectories2 = applicationDirectories;
            applicationDirectories = notification;
            lazy = applicationDirectories2;
            Object object = applicationDirectories.getAction();
            if (object == null) {
                List list = CollectionsKt.createListBuilder();
                notifications = list;
                list.add("notify-send");
                notifications.add("--app-name");
                notifications.add("Flechette");
                String string = SystemNotificationHandler_desktopKt.getNotificationIconFilePath((ApplicationDirectories)lazy);
                if (string != null) {
                    object = string;
                    notifications.add("--icon");
                    notifications.add(object);
                }
                notifications.add(applicationDirectories.getMessage());
                DesktopSystemKt.systemCommandLineOutputOf((List)CollectionsKt.build((List)list), SystemNotificationHandler_desktopKt::dispatchNotifySendNotification$lambda$7);
            } else {
                String string = "action-id";
                notifications = CollectionsKt.createListBuilder();
                List list = notifications;
                notifications.add("notify-send");
                list.add("--app-name");
                list.add("Flechette");
                String string2 = SystemNotificationHandler_desktopKt.getNotificationIconFilePath((ApplicationDirectories)lazy);
                if (string2 != null) {
                    notification = string2;
                    list.add("--icon");
                    list.add(notification);
                }
                list.add("--action");
                list.add(string + "=" + object.getName());
                list.add(applicationDirectories.getMessage());
                DesktopSystemKt.systemCommandLineOutputOf((List)CollectionsKt.build((List)notifications), arg_0 -> SystemNotificationHandler_desktopKt.dispatchNotifySendNotification$lambda$10(string, (NotificationAction)object, arg_0));
            }
        } else {
            ApplicationDirectories applicationDirectories3;
            if (!Tray_desktopKt.isTraySupported()) {
                logger.info(() -> SystemNotificationHandler_desktopKt.dispatchSystemNotification$lambda$2((SystemNotification)notification));
                Object object = SystemNotificationHandler_desktopKt.dispatchToastNotification((Notifications)notifications, notification, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
            logger.info(() -> SystemNotificationHandler_desktopKt.dispatchSystemNotification$lambda$3((SystemNotification)notification));
            ApplicationDirectories applicationDirectories4 = applicationDirectories3;
            applicationDirectories3 = notification;
            lazy = applicationDirectories4;
            Lazy lazy2 = isToasterInitialized$delegate;
            if (!((Boolean)lazy2.getValue()).booleanValue()) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            lazy2 = new ToastBuilder();
            ToastBuilder toastBuilder = lazy2;
            lazy2.type(ToastType.INFO);
            toastBuilder.title("Flechette");
            String string = SystemNotificationHandler_desktopKt.getNotificationIconFilePath((ApplicationDirectories)lazy);
            if (string != null) {
                String string3 = string;
                toastBuilder.icon(string3);
            }
            toastBuilder.content(applicationDirectories3.getMessage());
            lazy2.toast();
            if (notification.getAction() != null) {
                void var3_3;
                void var2_2;
                void var1_1;
                logger.info(() -> SystemNotificationHandler_desktopKt.dispatchSystemNotification$lambda$4((SystemNotification)notification));
                Object object = SystemNotificationHandler_desktopKt.dispatchToastNotification((Notifications)var1_1, (SystemNotification)var2_2, (Continuation<? super Unit>)var3_3);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object dispatchToastNotification(Notifications notifications, SystemNotification notification, Continuation<? super Unit> $completion) {
        void var2_2;
        Notifications notifications2;
        Notifications notifications3;
        Object object;
        Notifications notifications4 = notifications;
        String string = notification.getMessage();
        NotificationAction notificationAction = object.getAction();
        if (notificationAction != null) {
            Notifications it;
            notifications = notificationAction;
            String string2 = string;
            object = notifications4;
            notifications3 = new NotificationAction(it.getName(), (Function1)new Function1<Continuation<? super Unit>, Object>((NotificationAction)notifications3, null){
                int label;
                final /* synthetic */ NotificationAction $it;
                {
                    void var2_2;
                    void var1_1;
                    this.$it = var1_1;
                    super(1, (Continuation)var2_2);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$it, null){
                                int label;
                                final /* synthetic */ NotificationAction $it;
                                {
                                    void var2_2;
                                    void var1_1;
                                    this.$it = var1_1;
                                    super(2, (Continuation)var2_2);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            if (this.$it.getOnPerformed().invoke((Object)((Object)this)) != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)object);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    void var2_2;
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }
                            }), (int)3, null);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                /*
                 * WARNING - void declaration
                 */
                public final Continuation<Unit> create(Continuation<?> $completion) {
                    void var1_1;
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }
            });
            notifications4 = object;
            string = string2;
            notifications2 = notifications3;
        } else {
            notifications2 = null;
        }
        notifications3 = notifications2;
        object = string;
        Object object2 = notifications4.toast(new Toast((String)object, null, false, (NotificationAction)notifications3, 6, null), (Continuation)var2_2);
        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object2;
        }
        return Unit.INSTANCE;
    }

    private static final String getNotificationIconFilePath(ApplicationDirectories $this$notificationIconFilePath) {
        File file = SystemNotificationHandler_desktopKt.getNotificationIconFile($this$notificationIconFilePath);
        if (file != null) {
            return file.getAbsolutePath();
        }
        return null;
    }

    private static final File getNotificationIconFile(ApplicationDirectories $this$notificationIconFile) {
        File iconFile = kotlin.io.FilesKt.resolve((File)$this$notificationIconFile.getCacheDirectory().toFile(), (String)"system-notifications/icon.png");
        if (iconFile.isFile()) {
            return iconFile;
        }
        Object object = SystemNotificationHandler.class.getClassLoader();
        if (object != null && (object = ((ClassLoader)object).getResource("icon_256.png")) != null) {
            File file;
            iconFile.getParentFile().mkdirs();
            File file2 = iconFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            FilesKt.withOwnerOnlyPermissions((File)file2);
            kotlin.io.FilesKt.writeBytes((File)iconFile, (byte[])TextStreamsKt.readBytes((URL)object));
            FilesKt.withOwnerOnlyPermissions((File)iconFile);
            return file;
        }
        return null;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object dispatchSystemNotification$lambda$1(SystemNotification $notification) {
        return "Dispatching system notification via notify-send: " + $notification;
    }

    private static final Object dispatchSystemNotification$lambda$2(SystemNotification $notification) {
        return "Dispatching system notification via toast: " + $notification;
    }

    private static final Object dispatchSystemNotification$lambda$3(SystemNotification $notification) {
        return "Dispatching system notification via AWT: " + $notification;
    }

    private static final Object dispatchSystemNotification$lambda$4(SystemNotification $notification) {
        return "Dispatching a toast for the system notification action: " + $notification;
    }

    private static final Unit dispatchNotifySendNotification$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit dispatchNotifySendNotification$lambda$10(String $actionId, NotificationAction $action, String output) {
        String string;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)((CharSequence)var2_2))).toString(), (Object)string)) {
            void var1_1;
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((NotificationAction)var1_1, null){
                int label;
                final /* synthetic */ NotificationAction $action;
                {
                    void var2_2;
                    void var1_1;
                    this.$action = var1_1;
                    super(2, (Continuation)var2_2);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            if (this.$action.getOnPerformed().invoke((Object)((Object)this)) != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)object);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                /*
                 * WARNING - void declaration
                 */
                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    void var2_2;
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }
            }), (int)3, null);
        }
        return Unit.INSTANCE;
    }

    private static final Object isLinuxNotifySendAvailable_delegate$lambda$15$lambda$13$lambda$12() {
        return "notify-send is available";
    }

    private static final boolean isLinuxNotifySendAvailable_delegate$lambda$15$lambda$13(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.info(SystemNotificationHandler_desktopKt::isLinuxNotifySendAvailable_delegate$lambda$15$lambda$13$lambda$12);
        return true;
    }

    private static final Object isLinuxNotifySendAvailable_delegate$lambda$15$lambda$14() {
        return "notify-send is NOT available";
    }

    private static final boolean isLinuxNotifySendAvailable_delegate$lambda$15() {
        boolean bl;
        try {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = "notify-send";
            stringArray2[1] = "--version";
            bl = (Boolean)DesktopSystemKt.systemCommandLineOutputOf((String[])stringArray2, SystemNotificationHandler_desktopKt::isLinuxNotifySendAvailable_delegate$lambda$15$lambda$13);
        }
        catch (Exception exception) {
            logger.warn(SystemNotificationHandler_desktopKt::isLinuxNotifySendAvailable_delegate$lambda$15$lambda$14);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isToasterInitialized_delegate$lambda$21() {
        void var1_1;
        ToasterSettings toasterSettings;
        ToasterSettings $this$isToasterInitialized_delegate_u24lambda_u2421_u24lambda_u2420 = toasterSettings = new ToasterSettings();
        toasterSettings.setAppName("Flechette");
        var1_1.setPreferredToasterClassName(AWTToaster.class.getName());
        ToasterFactory.setSettings((ToasterSettings)toasterSettings);
        ToasterSettings toasterSettings2 = ToasterFactory.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)toasterSettings2, (String)"getSettings(...)");
        ToasterFactory.setFactory((ToasterFactory)new AwtToasterFactory(toasterSettings2));
        return true;
    }
}

