/*
 * Decompiled with CFR 0.152.
 */
package application.shared.desktop.platform;

import application.shared.desktop.platform.ConveyorProperties;
import application.shared.desktop.platform.ConveyorPropertiesKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import shared.system.install.JvmInstallationKt;

public final class DesktopDebugKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(DesktopDebugKt::logger$lambda$0);
    private static final Lazy isDesktopDebug$delegate = LazyKt.lazy(DesktopDebugKt::isDesktopDebug_delegate$lambda$4);

    public static final boolean isDesktopDebug() {
        Lazy lazy = isDesktopDebug$delegate;
        return (Boolean)lazy.getValue();
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object isDesktopDebug_delegate$lambda$4$lambda$1() {
        return "Running in RELEASE mode (from distributable)";
    }

    private static final Object isDesktopDebug_delegate$lambda$4$lambda$2() {
        return "Running in DEBUG mode (from distributable)";
    }

    private static final Object isDesktopDebug_delegate$lambda$4$lambda$3() {
        return "Running in DEBUG mode (NOT from distributable)";
    }

    private static final boolean isDesktopDebug_delegate$lambda$4() {
        if (JvmInstallationKt.isRunningFromDistributable()) {
            ConveyorProperties conveyorProperties = ConveyorPropertiesKt.getConveyorProperties();
            if (conveyorProperties == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            if (FilesKt.resolve((File)conveyorProperties.getAppDir(), (String)"RELEASE").isFile()) {
                logger.trace(DesktopDebugKt::isDesktopDebug_delegate$lambda$4$lambda$1);
                return false;
            }
            logger.warn(DesktopDebugKt::isDesktopDebug_delegate$lambda$4$lambda$2);
            return true;
        }
        logger.warn(DesktopDebugKt::isDesktopDebug_delegate$lambda$4$lambda$3);
        return true;
    }
}

