/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.CoreResultSet;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;
import org.sqlite.date.FastDateFormat;

public abstract class JDBC3ResultSet
extends CoreResultSet {
    protected static final Pattern COLUMN_TYPENAME = Pattern.compile("([^\\(]*)");
    protected static final Pattern COLUMN_TYPECAST = Pattern.compile("cast\\(.*?\\s+as\\s+(.*?)\\s*\\)");
    protected static final Pattern COLUMN_PRECISION = Pattern.compile(".*?\\((.*?)\\)");

    /*
     * WARNING - void declaration
     */
    protected JDBC3ResultSet(CoreStatement stmt) {
        super((CoreStatement)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public int findColumn(String col) throws SQLException {
        void var1_1;
        this.checkOpen();
        Integer index = this.findColumnIndexInCache(col);
        if (index != null) {
            return index;
        }
        for (int i = 0; i < this.cols.length; ++i) {
            if (!col.equalsIgnoreCase(this.cols[i])) continue;
            return this.addColumnIndexInCache(col, i + 1);
        }
        throw new SQLException("no such column: '" + (String)var1_1 + "'");
    }

    /*
     * WARNING - void declaration
     */
    public boolean next() throws SQLException {
        void var1_1;
        if (!this.open || this.emptyResultSet || this.pastLastRow) {
            return false;
        }
        this.lastCol = -1;
        if (this.row == 0) {
            ++this.row;
            return true;
        }
        if (this.maxRows != 0L && (long)this.row == this.maxRows) {
            return false;
        }
        int statusCode = this.stmt.pointer.safeRunInt(DB::step);
        switch (statusCode) {
            case 101: {
                this.pastLastRow = true;
                return false;
            }
            case 100: {
                ++this.row;
                return true;
            }
        }
        this.getDatabase().throwex((int)var1_1);
        return false;
    }

    public int getType() {
        return 1003;
    }

    public int getFetchSize() {
        return this.limitRows;
    }

    /*
     * WARNING - void declaration
     */
    public void setFetchSize(int rows) throws SQLException {
        void var1_1;
        if (rows < 0 || this.maxRows != 0L && (long)rows > this.maxRows) {
            throw new SQLException("fetch size " + rows + " out of bounds " + this.maxRows);
        }
        this.limitRows = var1_1;
    }

    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return 1000;
    }

    /*
     * WARNING - void declaration
     */
    public void setFetchDirection(int d) throws SQLException {
        void var1_1;
        this.checkOpen();
        if (var1_1 != 1000) {
            throw new SQLException("only FETCH_FORWARD direction supported");
        }
    }

    public boolean isAfterLast() {
        return this.pastLastRow && !this.emptyResultSet;
    }

    public boolean isBeforeFirst() {
        return !this.emptyResultSet && this.open && this.row == 0;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("not supported by sqlite");
    }

    public int getRow() {
        return this.row;
    }

    public boolean wasNull() throws SQLException {
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(this.lastCol)) == 5;
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getBigDecimal(int col) throws SQLException {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol(col))) {
            case 5: {
                return null;
            }
            case 1: {
                return BigDecimal.valueOf(this.safeGetLongCol(col));
            }
        }
        String stringValue = this.safeGetColumnText(col);
        try {
            return new BigDecimal(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            void var1_2;
            throw new SQLException("Bad value for type BigDecimal : " + (String)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public BigDecimal getBigDecimal(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBigDecimal(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(int col) throws SQLException {
        void var1_1;
        return this.getInt((int)var1_1) != 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBoolean(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBinaryStream(int col) throws SQLException {
        byte[] bytes = this.getBytes(col);
        if (bytes != null) {
            void var1_2;
            return new ByteArrayInputStream((byte[])var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBinaryStream(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBinaryStream(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(int col) throws SQLException {
        void var1_1;
        return (byte)this.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getByte(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRun((arg_0, arg_1) -> this.lambda$getBytes$0((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getBytes(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Reader getCharacterStream(int col) throws SQLException {
        void var1_2;
        String string = this.getString(col);
        if (string == null) {
            return null;
        }
        return new StringReader((String)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public Reader getCharacterStream(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getCharacterStream(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Date getDate(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    return new Date(this.getConnectionConfig().getDateFormat().parse(dateText).getTime());
                }
                catch (Exception e) {
                    void var1_3;
                    throw new SQLException("Error parsing date", (Throwable)var1_3);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Date(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1)).getTimeInMillis());
            }
        }
        return new Date(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
    }

    /*
     * WARNING - void declaration
     */
    public Date getDate(int col, Calendar cal) throws SQLException {
        void var2_3;
        void var1_1;
        this.requireCalendarNotNull(cal);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    void var1_2;
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), cal.getTimeZone());
                    return new Date(dateFormat.parse((String)var1_2).getTime());
                }
                catch (Exception e) {
                    void var2_4;
                    throw new SQLException("Error parsing time stamp", (Throwable)var2_4);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Date(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1), (Calendar)var2_3).getTimeInMillis());
            }
        }
        var2_3.setTimeInMillis(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
        return new Date(var2_3.getTime().getTime());
    }

    /*
     * WARNING - void declaration
     */
    public Date getDate(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDate(jDBC3ResultSet.findColumn((String)var1_1), Calendar.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public Date getDate(String col, Calendar cal) throws SQLException {
        void var2_2;
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDate(jDBC3ResultSet.findColumn((String)var1_1), (Calendar)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        if (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col)) == 5) {
            return 0.0;
        }
        return this.safeGetDoubleCol((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getDouble(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        if (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col)) == 5) {
            return 0.0f;
        }
        return (float)this.safeGetDoubleCol((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getFloat(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRunInt((arg_0, arg_1) -> this.lambda$getInt$1((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getInt(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int col) throws SQLException {
        void var1_1;
        return this.safeGetLongCol((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getLong(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(int col) throws SQLException {
        void var1_1;
        return (short)this.getInt((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public short getShort(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getShort(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getString(int col) throws SQLException {
        void var1_1;
        return this.safeGetColumnText((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getString(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Time getTime(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    return new Time(this.getConnectionConfig().getDateFormat().parse(dateText).getTime());
                }
                catch (Exception e) {
                    void var1_3;
                    throw new SQLException("Error parsing time", (Throwable)var1_3);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Time(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1)).getTimeInMillis());
            }
        }
        return new Time(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
    }

    /*
     * WARNING - void declaration
     */
    public Time getTime(int col, Calendar cal) throws SQLException {
        void var2_3;
        void var1_1;
        this.requireCalendarNotNull(cal);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    void var1_2;
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), cal.getTimeZone());
                    return new Time(dateFormat.parse((String)var1_2).getTime());
                }
                catch (Exception e) {
                    void var2_4;
                    throw new SQLException("Error parsing time", (Throwable)var2_4);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Time(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1), (Calendar)var2_3).getTimeInMillis());
            }
        }
        var2_3.setTimeInMillis(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
        return new Time(var2_3.getTime().getTime());
    }

    /*
     * WARNING - void declaration
     */
    public Time getTime(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTime(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Time getTime(String col, Calendar cal) throws SQLException {
        void var2_2;
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTime(jDBC3ResultSet.findColumn((String)var1_1), (Calendar)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp getTimestamp(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    return new Timestamp(this.getConnectionConfig().getDateFormat().parse(dateText).getTime());
                }
                catch (Exception e) {
                    void var1_3;
                    throw new SQLException("Error parsing time stamp", (Throwable)var1_3);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Timestamp(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1)).getTimeInMillis());
            }
        }
        return new Timestamp(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp getTimestamp(int col, Calendar cal) throws SQLException {
        void var2_3;
        void var1_1;
        this.requireCalendarNotNull(cal);
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 5: {
                return null;
            }
            case 3: {
                String dateText = this.safeGetColumnText(col);
                if ("".equals(dateText)) {
                    return null;
                }
                try {
                    void var1_2;
                    FastDateFormat dateFormat = FastDateFormat.getInstance(this.getConnectionConfig().getDateStringFormat(), cal.getTimeZone());
                    return new Timestamp(dateFormat.parse((String)var1_2).getTime());
                }
                catch (Exception e) {
                    void var2_4;
                    throw new SQLException("Error parsing time stamp", (Throwable)var2_4);
                }
            }
            case 2: {
                JDBC3ResultSet jDBC3ResultSet2 = this;
                return new Timestamp(jDBC3ResultSet2.julianDateToCalendar(jDBC3ResultSet2.safeGetDoubleCol((int)var1_1)).getTimeInMillis());
            }
        }
        var2_3.setTimeInMillis(this.safeGetLongCol((int)var1_1) * this.getConnectionConfig().getDateMultiplier());
        return new Timestamp(var2_3.getTime().getTime());
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp getTimestamp(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTimestamp(jDBC3ResultSet.findColumn((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Timestamp getTimestamp(String c, Calendar ca) throws SQLException {
        void var2_2;
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getTimestamp(jDBC3ResultSet.findColumn((String)var1_1), (Calendar)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public Object getObject(int col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 1: {
                void var2_2;
                long val = this.getLong(col);
                if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                    return new Long(val);
                }
                return new Integer((int)var2_2);
            }
            case 2: {
                return new Double(this.getDouble(col));
            }
            case 4: {
                return this.getBytes(col);
            }
            case 5: {
                return null;
            }
        }
        return this.getString((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object getObject(String col) throws SQLException {
        void var1_1;
        JDBC3ResultSet jDBC3ResultSet = this;
        return jDBC3ResultSet.getObject(jDBC3ResultSet.findColumn((String)var1_1));
    }

    public Statement getStatement() {
        return (Statement)((Object)this.stmt);
    }

    public String getCursorName() {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public ResultSetMetaData getMetaData() {
        return (ResultSetMetaData)((Object)this);
    }

    /*
     * WARNING - void declaration
     */
    public String getCatalogName(int col) throws SQLException {
        void var1_1;
        return this.safeGetColumnTableName((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getColumnClassName(int col) throws SQLException {
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.markCol(col))) {
            case 1: {
                void var2_2;
                void var1_1;
                long val = this.getLong((int)var1_1);
                if (val > Integer.MAX_VALUE || var2_2 < Integer.MIN_VALUE) {
                    return "java.lang.Long";
                }
                return "java.lang.Integer";
            }
            case 2: {
                return "java.lang.Double";
            }
            case 4: 
            case 5: {
                return "java.lang.Object";
            }
        }
        return "java.lang.String";
    }

    public int getColumnCount() throws SQLException {
        this.checkCol(1);
        return this.colsMeta.length;
    }

    public int getColumnDisplaySize(int col) {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public String getColumnLabel(int col) throws SQLException {
        void var1_1;
        return this.getColumnName((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getColumnName(int col) throws SQLException {
        void var1_1;
        return this.safeGetColumnName((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getColumnType(int col) throws SQLException {
        String typeName = this.getColumnTypeName(col);
        JDBC3ResultSet jDBC3ResultSet = this;
        int valueType = jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol(col));
        if (valueType == 1 || valueType == 5) {
            if ("BOOLEAN".equals(typeName)) {
                return 16;
            }
            if ("TINYINT".equals(typeName)) {
                return -6;
            }
            if ("SMALLINT".equals(typeName) || "INT2".equals(typeName)) {
                return 5;
            }
            if ("BIGINT".equals(typeName) || "INT8".equals(typeName) || "UNSIGNED BIG INT".equals(typeName)) {
                return -5;
            }
            if ("DATE".equals(typeName) || "DATETIME".equals(typeName)) {
                return 91;
            }
            if ("TIMESTAMP".equals(typeName)) {
                return 93;
            }
            if (valueType == 1 || "INT".equals(typeName) || "INTEGER".equals(typeName) || "MEDIUMINT".equals(typeName)) {
                void var1_1;
                long val = this.getLong((int)var1_1);
                if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
                    return -5;
                }
                return 4;
            }
        }
        if (valueType == 2 || valueType == 5) {
            if ("DECIMAL".equals(typeName)) {
                return 3;
            }
            if ("DOUBLE".equals(typeName) || "DOUBLE PRECISION".equals(typeName)) {
                return 8;
            }
            if ("NUMERIC".equals(typeName)) {
                return 2;
            }
            if ("REAL".equals(typeName)) {
                return 7;
            }
            if (valueType == 2 || "FLOAT".equals(typeName)) {
                return 6;
            }
        }
        if (valueType == 3 || valueType == 5) {
            if ("CHARACTER".equals(typeName) || "NCHAR".equals(typeName) || "NATIVE CHARACTER".equals(typeName) || "CHAR".equals(typeName)) {
                return 1;
            }
            if ("CLOB".equals(typeName)) {
                return 2005;
            }
            if ("DATE".equals(typeName) || "DATETIME".equals(typeName)) {
                return 91;
            }
            if ("TIMESTAMP".equals(typeName)) {
                return 93;
            }
            if (valueType == 3 || "VARCHAR".equals(typeName) || "VARYING CHARACTER".equals(typeName) || "NVARCHAR".equals(typeName) || "TEXT".equals(typeName)) {
                return 12;
            }
        }
        if (valueType == 4 || valueType == 5) {
            void var2_2;
            void var3_3;
            if ("BINARY".equals(typeName)) {
                return -2;
            }
            if (var3_3 == 4 || "BLOB".equals(var2_2)) {
                return 2004;
            }
        }
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    public String getColumnTypeName(int col) throws SQLException {
        void var1_1;
        String declType = this.getColumnDeclType(col);
        if (declType != null) {
            void var1_2;
            void var2_3;
            Matcher matcher = COLUMN_TYPENAME.matcher((CharSequence)var2_3);
            matcher.find();
            return var1_2.group(1).toUpperCase(Locale.ENGLISH);
        }
        JDBC3ResultSet jDBC3ResultSet = this;
        switch (jDBC3ResultSet.safeGetColumnType(jDBC3ResultSet.checkCol((int)var1_1))) {
            case 1: {
                return "INTEGER";
            }
            case 2: {
                return "FLOAT";
            }
            case 4: {
                return "BLOB";
            }
            case 3: {
                return "TEXT";
            }
        }
        return "NUMERIC";
    }

    /*
     * WARNING - void declaration
     */
    public int getPrecision(int col) throws SQLException {
        String declType = this.getColumnDeclType(col);
        if (declType != null) {
            Matcher matcher = COLUMN_PRECISION.matcher(declType);
            if (matcher.find()) {
                void var1_2;
                return Integer.parseInt(var1_2.group(1).split(",")[0].trim());
            }
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private String getColumnDeclType(int col) throws SQLException {
        void var2_3;
        String declType = this.stmt.pointer.safeRun((db, ptr) -> {
            void var1_1;
            void var3_3;
            return db.column_decltype((long)var3_3, this.checkCol((int)var1_1));
        });
        if (declType == null) {
            void var1_2;
            Matcher matcher = COLUMN_TYPECAST.matcher(this.safeGetColumnName(col));
            declType = matcher.find() ? var1_2.group(1) : null;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public int getScale(int col) throws SQLException {
        String[] array;
        Matcher matcher;
        String declType = this.getColumnDeclType(col);
        if (declType != null && (matcher = COLUMN_PRECISION.matcher(declType)).find() && (array = matcher.group(1).split(",")).length == 2) {
            void var1_2;
            return Integer.parseInt(var1_2[1].trim());
        }
        return 0;
    }

    public String getSchemaName(int col) {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String getTableName(int col) throws SQLException {
        void var1_2;
        String tableName = this.safeGetColumnTableName(col);
        if (tableName == null) {
            return "";
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public int isNullable(int col) throws SQLException {
        void var1_1;
        this.checkMeta();
        if (this.meta[this.checkCol((int)var1_1)][0]) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAutoIncrement(int col) throws SQLException {
        void var1_1;
        this.checkMeta();
        return this.meta[this.checkCol((int)var1_1)][2];
    }

    public boolean isCaseSensitive(int col) {
        return true;
    }

    public boolean isCurrency(int col) {
        return false;
    }

    public boolean isDefinitelyWritable(int col) {
        return true;
    }

    public boolean isReadOnly(int col) {
        return false;
    }

    public boolean isSearchable(int col) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSigned(int col) throws SQLException {
        void var1_2;
        String typeName = this.getColumnTypeName(col);
        return "NUMERIC".equals(typeName) || "INTEGER".equals(typeName) || "REAL".equals(var1_2);
    }

    public boolean isWritable(int col) {
        return true;
    }

    public int getConcurrency() {
        return 1007;
    }

    public boolean rowDeleted() {
        return false;
    }

    public boolean rowInserted() {
        return false;
    }

    public boolean rowUpdated() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Calendar julianDateToCalendar(Double jd) {
        void var1_1;
        return this.julianDateToCalendar((Double)var1_1, Calendar.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    private Calendar julianDateToCalendar(Double jd, Calendar cal) {
        void var2_3;
        void var3_6;
        void A;
        if (jd == null) {
            return null;
        }
        double w = jd + 0.5;
        int Z = (int)w;
        double F = w - (double)Z;
        if (Z >= 2299161) {
            int alpha = (int)(((double)A - 1867216.25) / 36524.25);
            A = A + true + alpha - (int)((double)alpha / 4.0);
        }
        void B = A + 1524;
        int C = (int)(((double)B - 122.1) / 365.25);
        int D = (int)(365.25 * (double)C);
        int E = (int)((double)(B - D) / 30.6001);
        int mm = E - ((double)E < 13.5 ? 1 : 13);
        int yyyy = C - ((double)mm > 2.5 ? 4716 : 4715);
        double jjd = (double)(B - D - (int)(30.6001 * (double)E)) + F;
        int dd = (int)jjd;
        double hhd = jjd - (double)dd;
        int hh = (int)(24.0 * hhd);
        double mnd = 24.0 * hhd - (double)hh;
        int mn = (int)(60.0 * mnd);
        double ssd = 60.0 * mnd - (double)mn;
        int ss = (int)(60.0 * ssd);
        double msd = 60.0 * ssd - (double)ss;
        int ms = (int)(1000.0 * msd);
        cal.set(yyyy, mm - 1, (int)var3_6, hh, mn, ss);
        cal.set(14, ms);
        if (yyyy <= 0) {
            void var1_2;
            cal.set(0, 0);
            cal.set(1, (int)(-(var1_2 - true)));
        }
        return var2_3;
    }

    private void requireCalendarNotNull(Calendar cal) throws SQLException {
        if (cal == null) {
            throw new SQLException("Expected a calendar instance.", new IllegalArgumentException());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected int safeGetColumnType(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRunInt((arg_0, arg_1) -> JDBC3ResultSet.lambda$safeGetColumnType$3((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private long safeGetLongCol(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRunLong((arg_0, arg_1) -> this.lambda$safeGetLongCol$4((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private double safeGetDoubleCol(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRunDouble((arg_0, arg_1) -> this.lambda$safeGetDoubleCol$5((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private String safeGetColumnText(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRun((arg_0, arg_1) -> this.lambda$safeGetColumnText$6((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private String safeGetColumnTableName(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRun((arg_0, arg_1) -> this.lambda$safeGetColumnTableName$7((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private String safeGetColumnName(int col) throws SQLException {
        void var1_1;
        return this.stmt.pointer.safeRun((arg_0, arg_1) -> this.lambda$safeGetColumnName$8((int)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String lambda$safeGetColumnName$8(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_name((long)var3_3, this.checkCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String lambda$safeGetColumnTableName$7(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_table_name((long)var3_3, this.checkCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ String lambda$safeGetColumnText$6(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_text((long)var3_3, this.markCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ double lambda$safeGetDoubleCol$5(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_double((long)var3_3, this.markCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ long lambda$safeGetLongCol$4(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_long((long)var3_3, this.markCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$safeGetColumnType$3(int col, DB db, long ptr) throws SQLException {
        int n;
        void var2_2;
        return db.column_type((long)var2_2, n);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int lambda$getInt$1(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_int((long)var3_3, this.markCol((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ byte[] lambda$getBytes$0(int col, DB db, long ptr) throws SQLException {
        void var1_1;
        void var3_3;
        return db.column_blob((long)var3_3, this.markCol((int)var1_1));
    }
}

