/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CorePreparedStatement;
import org.sqlite.core.DB;
import org.sqlite.jdbc3.JDBC3Connection;

public abstract class JDBC3PreparedStatement
extends CorePreparedStatement {
    /*
     * WARNING - void declaration
     */
    protected JDBC3PreparedStatement(SQLiteConnection conn, String sql) throws SQLException {
        super((SQLiteConnection)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
    }

    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.pointer.safeRunConsume(DB::clear_bindings);
        if (this.batch != null) {
            for (int i = this.batchPos; i < this.batchPos + this.paramCount; ++i) {
                this.batch[i] = null;
            }
        }
    }

    public boolean execute() throws SQLException {
        this.checkOpen();
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        this.exhaustedResults = false;
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            boolean success = false;
            try {
                Object object = this.conn;
                synchronized (object) {
                    JDBC3PreparedStatement jDBC3PreparedStatement = this;
                    this.resultsWaiting = this.conn.getDatabase().execute(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
                    this.updateGeneratedKeys();
                    success = true;
                    this.updateCount = this.getDatabase().changes();
                }
                object = this.columnCount != 0;
                return object;
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 == false && !this.pointer.isClosed()) {
                    this.pointer.safeRunConsume(DB::reset);
                }
                throw throwable;
            }
        });
    }

    public ResultSet executeQuery() throws SQLException {
        this.checkOpen();
        if (this.columnCount == 0) {
            throw new SQLException("Query does not return results");
        }
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        this.exhaustedResults = false;
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            try {
                JDBC3PreparedStatement jDBC3PreparedStatement = this;
                this.resultsWaiting = this.conn.getDatabase().execute(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
            }
            catch (Throwable throwable) {
                if (!this.pointer.isClosed()) {
                    this.pointer.safeRunInt(DB::reset);
                }
                throw throwable;
            }
            return this.getResultSet();
        });
    }

    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    public long executeLargeUpdate() throws SQLException {
        this.checkOpen();
        if (this.columnCount != 0) {
            throw new SQLException("Query returns results");
        }
        this.rs.close();
        this.pointer.safeRunConsume(DB::reset);
        this.exhaustedResults = false;
        if (this.conn instanceof JDBC3Connection) {
            ((JDBC3Connection)this.conn).tryEnforceTransactionMode();
        }
        JDBC3PreparedStatement jDBC3PreparedStatement = this;
        return jDBC3PreparedStatement.withConnectionTimeout(() -> {
            SQLiteConnection sQLiteConnection = this.conn;
            synchronized (sQLiteConnection) {
                void var2_2;
                JDBC3PreparedStatement jDBC3PreparedStatement = this;
                long rc = this.conn.getDatabase().executeUpdate(jDBC3PreparedStatement, jDBC3PreparedStatement.batch);
                this.updateGeneratedKeys();
                return (long)var2_2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void addBatch() throws SQLException {
        this.checkOpen();
        this.batchPos += this.paramCount;
        ++this.batchQueryCount;
        if (this.batch == null) {
            this.batch = new Object[this.paramCount];
        }
        if (this.batchPos + this.paramCount > this.batch.length) {
            void var1_1;
            Object[] nb = new Object[this.batch.length * 2];
            System.arraycopy(this.batch, 0, nb, 0, this.batch.length);
            this.batch = var1_1;
        }
        System.arraycopy(this.batch, this.batchPos - this.paramCount, this.batch, this.batchPos, this.paramCount);
    }

    public ParameterMetaData getParameterMetaData() {
        return (ParameterMetaData)((Object)this);
    }

    public int getParameterCount() throws SQLException {
        this.checkOpen();
        return this.paramCount;
    }

    public String getParameterClassName(int param) throws SQLException {
        this.checkOpen();
        return "java.lang.String";
    }

    /*
     * WARNING - void declaration
     */
    public String getParameterTypeName(int pos) throws SQLException {
        void var1_1;
        this.checkIndex(pos);
        return JDBCType.valueOf(this.getParameterType((int)var1_1)).getName();
    }

    /*
     * WARNING - void declaration
     */
    public int getParameterType(int pos) throws SQLException {
        void var1_2;
        this.checkIndex(pos);
        Object paramValue = this.batch[pos - 1];
        if (paramValue == null) {
            return 0;
        }
        if (paramValue instanceof Integer || paramValue instanceof Short || paramValue instanceof Boolean) {
            return 4;
        }
        if (paramValue instanceof Long) {
            return -5;
        }
        if (paramValue instanceof Double || var1_2 instanceof Float) {
            return 7;
        }
        return 12;
    }

    public int getParameterMode(int pos) {
        return 1;
    }

    public int getPrecision(int pos) {
        return 0;
    }

    public int getScale(int pos) {
        return 0;
    }

    public int isNullable(int pos) {
        return 1;
    }

    public boolean isSigned(int pos) {
        return true;
    }

    public Statement getStatement() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void setBigDecimal(int pos, BigDecimal value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, value == null ? null : var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readBytes(InputStream istream, int length) throws SQLException {
        if (length < 0) {
            throw new SQLException("Error reading stream. Length should be non-negative");
        }
        byte[] bytes = new byte[length];
        try {
            void var3_3;
            int bytesRead;
            for (int totalBytesRead = 0; totalBytesRead < length; totalBytesRead += bytesRead) {
                bytesRead = istream.read(bytes, totalBytesRead, length - totalBytesRead);
                if (bytesRead != -1) continue;
                throw new IOException("End of stream has been reached");
            }
            return var3_3;
        }
        catch (IOException cause) {
            SQLException exception = new SQLException("Error reading stream");
            exception.initCause(cause);
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryStream(int pos, InputStream istream, int length) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (istream == null && length == 0) {
            this.setBytes(pos, null);
        }
        this.setBytes((int)var1_1, this.readBytes((InputStream)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void setAsciiStream(int pos, InputStream istream, int length) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setUnicodeStream((int)var1_1, (InputStream)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setUnicodeStream(int pos, InputStream istream, int length) throws SQLException {
        if (istream == null && length == 0) {
            this.setString(pos, null);
        }
        try {
            void var3_4;
            this.setString(pos, new String(this.readBytes(istream, (int)var3_4), "UTF-8"));
            return;
        }
        catch (UnsupportedEncodingException e) {
            void var2_3;
            void var1_2;
            SQLException exception = new SQLException("UTF-8 is not supported");
            exception.initCause((Throwable)var1_2);
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setBoolean(int pos, boolean value) throws SQLException {
        void var2_2;
        void var1_1;
        this.setInt((int)var1_1, var2_2 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public void setByte(int pos, byte value) throws SQLException {
        void var2_2;
        void var1_1;
        this.setInt((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setBytes(int pos, byte[] value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setDouble(int pos, double value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, (double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setFloat(int pos, float value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, Float.valueOf((float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setInt(int pos, int value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setLong(int pos, long value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, new Long((long)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setNull(int pos, int u1) throws SQLException {
        void var2_2;
        void var1_1;
        this.setNull((int)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setNull(int pos, int u1, String u2) throws SQLException {
        void var1_1;
        this.batch((int)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setObject(int pos, Object value) throws SQLException {
        void var2_2;
        void var1_1;
        if (value == null) {
            this.batch(pos, null);
            return;
        }
        if (value instanceof java.util.Date) {
            this.setDateByMilliseconds(pos, ((java.util.Date)value).getTime(), Calendar.getInstance());
            return;
        }
        if (value instanceof Long) {
            this.batch(pos, value);
            return;
        }
        if (value instanceof Integer) {
            this.batch(pos, value);
            return;
        }
        if (value instanceof Short) {
            this.batch(pos, new Integer(((Short)value).intValue()));
            return;
        }
        if (value instanceof Float) {
            this.batch(pos, value);
            return;
        }
        if (value instanceof Double) {
            this.batch(pos, value);
            return;
        }
        if (value instanceof Boolean) {
            this.setBoolean(pos, (Boolean)value);
            return;
        }
        if (value instanceof byte[]) {
            this.batch(pos, value);
            return;
        }
        if (value instanceof BigDecimal) {
            this.setBigDecimal(pos, (BigDecimal)value);
            return;
        }
        this.batch((int)var1_1, var2_2.toString());
    }

    /*
     * WARNING - void declaration
     */
    public void setObject(int p, Object v, int t) throws SQLException {
        void var2_2;
        void var1_1;
        this.setObject((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setObject(int p, Object v, int t, int s) throws SQLException {
        void var2_2;
        void var1_1;
        this.setObject((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setShort(int pos, short value) throws SQLException {
        void var2_2;
        void var1_1;
        this.setInt((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setString(int pos, String value) throws SQLException {
        void var2_2;
        void var1_1;
        this.batch((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void setCharacterStream(int pos, Reader reader, int length) throws SQLException {
        try {
            void var1_1;
            int cnt;
            StringBuffer sb = new StringBuffer();
            char[] cbuf = new char[8192];
            while ((cnt = reader.read(cbuf)) > 0) {
                sb.append(cbuf, 0, cnt);
            }
            this.setString((int)var1_1, sb.toString());
            return;
        }
        catch (IOException e) {
            void var3_5;
            throw new SQLException("Cannot read from character stream, exception message: " + var3_5.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(int pos, Date x) throws SQLException {
        void var2_2;
        void var1_1;
        this.setDate((int)var1_1, (Date)var2_2, Calendar.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public void setDate(int pos, Date x, Calendar cal) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (x == null) {
            this.setObject(pos, null);
            return;
        }
        this.setDateByMilliseconds((int)var1_1, var2_2.getTime(), (Calendar)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setTime(int pos, Time x) throws SQLException {
        void var2_2;
        void var1_1;
        this.setTime((int)var1_1, (Time)var2_2, Calendar.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public void setTime(int pos, Time x, Calendar cal) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (x == null) {
            this.setObject(pos, null);
            return;
        }
        this.setDateByMilliseconds((int)var1_1, var2_2.getTime(), (Calendar)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setTimestamp(int pos, Timestamp x) throws SQLException {
        void var2_2;
        void var1_1;
        this.setTimestamp((int)var1_1, (Timestamp)var2_2, Calendar.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public void setTimestamp(int pos, Timestamp x, Calendar cal) throws SQLException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (x == null) {
            this.setObject(pos, null);
            return;
        }
        this.setDateByMilliseconds((int)var1_1, var2_2.getTime(), (Calendar)var3_3);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return (ResultSetMetaData)((Object)this.rs);
    }

    @Override
    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    protected SQLException invalid() {
        return new SQLException("method cannot be called on a PreparedStatement");
    }

    public void setArray(int i, Array x) throws SQLException {
        throw this.unsupported();
    }

    public void setBlob(int i, Blob x) throws SQLException {
        throw this.unsupported();
    }

    public void setClob(int i, Clob x) throws SQLException {
        throw this.unsupported();
    }

    public void setRef(int i, Ref x) throws SQLException {
        throw this.unsupported();
    }

    public void setURL(int pos, URL x) throws SQLException {
        throw this.unsupported();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw this.invalid();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.invalid();
    }

    @Override
    public boolean execute(String sql, int[] colinds) throws SQLException {
        throw this.invalid();
    }

    @Override
    public boolean execute(String sql, String[] colnames) throws SQLException {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.invalid();
    }

    @Override
    public int executeUpdate(String sql, String[] cols) throws SQLException {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] colinds) throws SQLException {
        throw this.invalid();
    }

    @Override
    public long executeLargeUpdate(String sql, String[] cols) throws SQLException {
        throw this.invalid();
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw this.invalid();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.invalid();
    }
}

