/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.date;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.date.DateParser;

public class FastDateParser
implements Serializable,
DateParser {
    private static final long serialVersionUID = 2L;
    static final Locale JAPANESE_IMPERIAL = new Locale("ja", "JP", "JP");
    private final String pattern;
    private final TimeZone timeZone;
    private final Locale locale;
    private final int century;
    private final int startYear;
    private transient Pattern parsePattern;
    private transient Strategy[] strategies;
    private transient String currentFormatField;
    private transient Strategy nextStrategy;
    private static final Pattern formatPattern = Pattern.compile("D+|E+|F+|G+|H+|K+|M+|S+|W+|X+|Z+|a+|d+|h+|k+|m+|s+|w+|y+|z+|''|'[^']++(''[^']*+)*+'|[^'A-Za-z]++");
    private static final ConcurrentMap<Locale, Strategy>[] caches = new ConcurrentMap[17];
    private static final Strategy ABBREVIATED_YEAR_STRATEGY = new NumberStrategy(1){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var3_4;
            void var2_2;
            int iValue = Integer.parseInt(value);
            if (iValue < 100) {
                void var1_1;
                iValue = FastDateParser.access$300((FastDateParser)var1_1, iValue);
            }
            var2_2.set(1, (int)var3_4);
        }
    };
    private static final Strategy NUMBER_MONTH_STRATEGY = new NumberStrategy(2){
        {
            void var1_1;
        }

        @Override
        int modify(int iValue) {
            return iValue - 1;
        }
    };
    private static final Strategy LITERAL_YEAR_STRATEGY = new NumberStrategy(1);
    private static final Strategy WEEK_OF_YEAR_STRATEGY = new NumberStrategy(3);
    private static final Strategy WEEK_OF_MONTH_STRATEGY = new NumberStrategy(4);
    private static final Strategy DAY_OF_YEAR_STRATEGY = new NumberStrategy(6);
    private static final Strategy DAY_OF_MONTH_STRATEGY = new NumberStrategy(5);
    private static final Strategy DAY_OF_WEEK_IN_MONTH_STRATEGY = new NumberStrategy(8);
    private static final Strategy HOUR_OF_DAY_STRATEGY = new NumberStrategy(11);
    private static final Strategy HOUR24_OF_DAY_STRATEGY = new NumberStrategy(11){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int modify(int iValue) {
            void var1_1;
            if (iValue == 24) {
                return 0;
            }
            return (int)var1_1;
        }
    };
    private static final Strategy HOUR12_STRATEGY = new NumberStrategy(10){
        {
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int modify(int iValue) {
            void var1_1;
            if (iValue == 12) {
                return 0;
            }
            return (int)var1_1;
        }
    };
    private static final Strategy HOUR_STRATEGY = new NumberStrategy(10);
    private static final Strategy MINUTE_STRATEGY = new NumberStrategy(12);
    private static final Strategy SECOND_STRATEGY = new NumberStrategy(13);
    private static final Strategy MILLISECOND_STRATEGY = new NumberStrategy(14);
    private static final Strategy ISO_8601_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::?\\d{2})?))");

    /*
     * WARNING - void declaration
     */
    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale) {
        this((String)var1_1, (TimeZone)var2_2, (Locale)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected FastDateParser(String pattern, TimeZone timeZone, Locale locale, Date centuryStart) {
        void var1_1;
        void var2_3;
        void var3_4;
        int centuryStartYear;
        this.pattern = pattern;
        this.timeZone = timeZone;
        this.locale = locale;
        Calendar definingCalendar = Calendar.getInstance(timeZone, locale);
        if (centuryStart != null) {
            definingCalendar.setTime(centuryStart);
            centuryStartYear = definingCalendar.get(1);
        } else if (var3_4.equals(JAPANESE_IMPERIAL)) {
            centuryStartYear = 0;
        } else {
            definingCalendar.setTime(new Date());
            centuryStartYear = definingCalendar.get(1) - 80;
        }
        this.century = centuryStartYear / 100 * 100;
        this.startYear = var2_3 - this.century;
        this.init((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void init(Calendar definingCalendar) {
        void var2_2;
        void var3_3;
        StringBuilder regex = new StringBuilder();
        ArrayList<Strategy> collector = new ArrayList<Strategy>();
        Matcher patternMatcher = formatPattern.matcher(this.pattern);
        if (!patternMatcher.lookingAt()) {
            throw new IllegalArgumentException("Illegal pattern character '" + this.pattern.charAt(patternMatcher.regionStart()) + "'");
        }
        this.currentFormatField = patternMatcher.group();
        FastDateParser fastDateParser = this;
        Strategy currentStrategy = fastDateParser.getStrategy(fastDateParser.currentFormatField, definingCalendar);
        while (true) {
            Matcher matcher = patternMatcher;
            matcher.region(matcher.end(), patternMatcher.regionEnd());
            if (!patternMatcher.lookingAt()) break;
            String nextFormatField = patternMatcher.group();
            this.nextStrategy = this.getStrategy(nextFormatField, definingCalendar);
            if (currentStrategy.addRegex(this, regex)) {
                collector.add(currentStrategy);
            }
            this.currentFormatField = nextFormatField;
            currentStrategy = this.nextStrategy;
        }
        this.nextStrategy = null;
        if (patternMatcher.regionStart() != patternMatcher.regionEnd()) {
            throw new IllegalArgumentException("Failed to parse \"" + this.pattern + "\" ; gave up at index " + patternMatcher.regionStart());
        }
        if (currentStrategy.addRegex(this, regex)) {
            collector.add(currentStrategy);
        }
        this.currentFormatField = null;
        void v2 = var3_3;
        this.strategies = v2.toArray(new Strategy[v2.size()]);
        this.parsePattern = Pattern.compile(var2_2.toString());
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    Pattern getParsePattern() {
        return this.parsePattern;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (!(obj instanceof FastDateParser)) {
            return false;
        }
        FastDateParser other = (FastDateParser)obj;
        return this.pattern.equals(other.pattern) && this.timeZone.equals(other.timeZone) && this.locale.equals(var1_1.locale);
    }

    public int hashCode() {
        return this.pattern.hashCode() + 13 * (this.timeZone.hashCode() + 13 * this.locale.hashCode());
    }

    public String toString() {
        return "FastDateParser[" + this.pattern + "," + this.locale + "," + this.timeZone.getID() + "]";
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        in.defaultReadObject();
        Calendar definingCalendar = Calendar.getInstance(this.timeZone, this.locale);
        this.init((Calendar)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object parseObject(String source) throws ParseException {
        void var1_1;
        return this.parse((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date parse(String source) throws ParseException {
        void var2_2;
        Object normalizedSource;
        normalizedSource = source.length() == 19 ? source + ".000" : normalizedSource;
        Date date = this.parse((String)normalizedSource, new ParsePosition(0));
        if (date == null) {
            void var1_1;
            if (this.locale.equals(JAPANESE_IMPERIAL)) {
                throw new ParseException("(The " + this.locale + " locale does not support dates before 1868 AD)\nUnparseable date: \"" + (String)normalizedSource + "\" does not match " + this.parsePattern.pattern(), 0);
            }
            throw new ParseException("Unparseable date: \"" + (String)var1_1 + "\" does not match " + this.parsePattern.pattern(), 0);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object parseObject(String source, ParsePosition pos) {
        void var2_2;
        void var1_1;
        return this.parse((String)var1_1, (ParsePosition)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Date parse(String source, ParsePosition pos) {
        void var1_1;
        void var3_3;
        void var2_2;
        int offset = pos.getIndex();
        Matcher matcher = this.parsePattern.matcher(source.substring(offset));
        if (!matcher.lookingAt()) {
            return null;
        }
        Calendar cal = Calendar.getInstance(this.timeZone, this.locale);
        cal.clear();
        int i = 0;
        while (i < this.strategies.length) {
            Strategy strategy = this.strategies[i++];
            strategy.setCalendar(this, cal, matcher.group(i));
        }
        var2_2.setIndex((int)(var3_3 + var1_1.end()));
        return cal.getTime();
    }

    private static StringBuilder escapeRegex(StringBuilder regex, String value, boolean unquote) {
        StringBuilder stringBuilder;
        regex.append("\\Q");
        for (int i = 0; i < value.length(); ++i) {
            int c = value.charAt(i);
            switch (c) {
                case 39: {
                    if (!unquote) break;
                    if (++i == value.length()) {
                        return regex;
                    }
                    c = value.charAt(i);
                    break;
                }
                case 92: {
                    if (++i == value.length()) break;
                    regex.append((char)c);
                    c = value.charAt(i);
                    if (c != 69) break;
                    regex.append("E\\\\E\\");
                    c = 81;
                }
            }
            regex.append((char)c);
        }
        regex.append("\\E");
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Integer> getDisplayNames(int field, Calendar definingCalendar, Locale locale) {
        void var2_2;
        int n;
        return definingCalendar.getDisplayNames(n, 0, (Locale)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int adjustYear(int twoDigitYear) {
        void var2_2;
        void var1_1;
        int trial = this.century + twoDigitYear;
        if (var1_1 >= this.startYear) {
            return trial;
        }
        return (int)(var2_2 + 100);
    }

    boolean isNextNumber() {
        return this.nextStrategy != null && this.nextStrategy.isNumber();
    }

    int getFieldWidth() {
        return this.currentFormatField.length();
    }

    /*
     * WARNING - void declaration
     */
    private Strategy getStrategy(String formatField, Calendar definingCalendar) {
        void var2_2;
        switch (formatField.charAt(0)) {
            case '\'': {
                if (formatField.length() > 2) {
                    return new CopyQuotedStrategy(formatField.substring(1, formatField.length() - 1));
                }
            }
            default: {
                return new CopyQuotedStrategy(formatField);
            }
            case 'D': {
                return DAY_OF_YEAR_STRATEGY;
            }
            case 'E': {
                return this.getLocaleSpecificStrategy(7, definingCalendar);
            }
            case 'F': {
                return DAY_OF_WEEK_IN_MONTH_STRATEGY;
            }
            case 'G': {
                return this.getLocaleSpecificStrategy(0, definingCalendar);
            }
            case 'H': {
                return HOUR_OF_DAY_STRATEGY;
            }
            case 'K': {
                return HOUR_STRATEGY;
            }
            case 'M': {
                if (formatField.length() >= 3) {
                    return this.getLocaleSpecificStrategy(2, definingCalendar);
                }
                return NUMBER_MONTH_STRATEGY;
            }
            case 'S': {
                return MILLISECOND_STRATEGY;
            }
            case 'W': {
                return WEEK_OF_MONTH_STRATEGY;
            }
            case 'a': {
                return this.getLocaleSpecificStrategy(9, definingCalendar);
            }
            case 'd': {
                return DAY_OF_MONTH_STRATEGY;
            }
            case 'h': {
                return HOUR12_STRATEGY;
            }
            case 'k': {
                return HOUR24_OF_DAY_STRATEGY;
            }
            case 'm': {
                return MINUTE_STRATEGY;
            }
            case 's': {
                return SECOND_STRATEGY;
            }
            case 'w': {
                return WEEK_OF_YEAR_STRATEGY;
            }
            case 'y': {
                if (formatField.length() > 2) {
                    return LITERAL_YEAR_STRATEGY;
                }
                return ABBREVIATED_YEAR_STRATEGY;
            }
            case 'X': {
                return ISO8601TimeZoneStrategy.getStrategy(formatField.length());
            }
            case 'Z': {
                void var1_1;
                if (!var1_1.equals("ZZ")) break;
                return ISO_8601_STRATEGY;
            }
            case 'z': 
        }
        return this.getLocaleSpecificStrategy(15, (Calendar)var2_2);
    }

    private static ConcurrentMap<Locale, Strategy> getCache(int field) {
        ConcurrentMap<Locale, Strategy>[] concurrentMapArray = caches;
        synchronized (caches) {
            int n;
            if (caches[field] == null) {
                FastDateParser.caches[field] = new ConcurrentHashMap<Locale, Strategy>(3);
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return caches[n];
        }
    }

    /*
     * WARNING - void declaration
     */
    private Strategy getLocaleSpecificStrategy(int field, Calendar definingCalendar) {
        void var2_3;
        void var3_4;
        Strategy inCache;
        ConcurrentMap<Locale, Strategy> cache = FastDateParser.getCache(field);
        Strategy strategy = (Strategy)cache.get(this.locale);
        if (strategy == null && (inCache = var3_4.putIfAbsent(this.locale, strategy = field == 15 ? new TimeZoneStrategy(this.locale) : new CaseInsensitiveTextStrategy(field, (Calendar)var2_3, this.locale))) != null) {
            void var1_2;
            return var1_2;
        }
        return strategy;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ StringBuilder access$100(StringBuilder x0, String x1, boolean x2) {
        void var2_2;
        void var1_1;
        return FastDateParser.escapeRegex(x0, (String)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$200(int x0, Calendar x1, Locale x2) {
        void var2_2;
        void var1_1;
        return FastDateParser.getDisplayNames(x0, (Calendar)var1_1, (Locale)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(FastDateParser x0, int x1) {
        void var1_1;
        return x0.adjustYear((int)var1_1);
    }

    private static class ISO8601TimeZoneStrategy
    extends Strategy {
        private final String pattern;
        private static final Strategy ISO_8601_1_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}))");
        private static final Strategy ISO_8601_2_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}\\d{2}))");
        private static final Strategy ISO_8601_3_STRATEGY = new ISO8601TimeZoneStrategy("(Z|(?:[+-]\\d{2}(?::)\\d{2}))");

        /*
         * WARNING - void declaration
         */
        ISO8601TimeZoneStrategy(String pattern) {
            void var1_1;
            this.pattern = var1_1;
        }

        @Override
        boolean addRegex(FastDateParser parser, StringBuilder regex) {
            regex.append(this.pattern);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var3_3;
            void var2_2;
            if (value.equals("Z")) {
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                return;
            }
            var2_2.setTimeZone(TimeZone.getTimeZone("GMT" + (String)var3_3));
        }

        static Strategy getStrategy(int tokenLen) {
            switch (tokenLen) {
                case 1: {
                    return ISO_8601_1_STRATEGY;
                }
                case 2: {
                    return ISO_8601_2_STRATEGY;
                }
                case 3: {
                    return ISO_8601_3_STRATEGY;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }
    }

    private static class TimeZoneStrategy
    extends Strategy {
        private final String validTimeZoneChars;
        private final SortedMap<String, TimeZone> tzNames = new TreeMap<String, TimeZone>(String.CASE_INSENSITIVE_ORDER);
        private static final int ID = 0;
        private static final int LONG_STD = 1;
        private static final int SHORT_STD = 2;
        private static final int LONG_DST = 3;
        private static final int SHORT_DST = 4;

        /*
         * WARNING - void declaration
         */
        TimeZoneStrategy(Locale locale) {
            void var1_1;
            String[][] stringArray = DateFormatSymbols.getInstance((Locale)locale).getZoneStrings();
            locale = stringArray;
            locale = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] zone = locale[i];
                if (zone[0].startsWith("GMT")) continue;
                TimeZone tz = TimeZone.getTimeZone(zone[0]);
                if (!this.tzNames.containsKey(zone[1])) {
                    this.tzNames.put(zone[1], tz);
                }
                if (!this.tzNames.containsKey(zone[2])) {
                    this.tzNames.put(zone[2], tz);
                }
                if (!tz.useDaylightTime()) continue;
                if (!this.tzNames.containsKey(zone[3])) {
                    this.tzNames.put(zone[3], tz);
                }
                if (this.tzNames.containsKey(zone[4])) continue;
                this.tzNames.put(zone[4], tz);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(GMT[+-]\\d{1,2}:\\d{2}|");
            sb.append("[+-]\\d{4}|");
            for (String id : this.tzNames.keySet()) {
                void var3_5;
                FastDateParser.access$100(sb, (String)var3_5, false).append('|');
            }
            StringBuilder stringBuilder = sb;
            stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
            this.validTimeZoneChars = var1_1.toString();
        }

        @Override
        boolean addRegex(FastDateParser parser, StringBuilder regex) {
            regex.append(this.validTimeZoneChars);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var1_1;
            void var2_2;
            TimeZone tz;
            if (value.charAt(0) == '+' || value.charAt(0) == '-') {
                tz = TimeZone.getTimeZone("GMT" + value);
            } else if (value.startsWith("GMT")) {
                tz = TimeZone.getTimeZone(value);
            } else {
                tz = (TimeZone)this.tzNames.get(value);
                if (tz == null) {
                    void var3_3;
                    throw new IllegalArgumentException((String)var3_3 + " is not a supported timezone name");
                }
            }
            var2_2.setTimeZone((TimeZone)var1_1);
        }
    }

    private static class NumberStrategy
    extends Strategy {
        private final int field;

        /*
         * WARNING - void declaration
         */
        NumberStrategy(int field) {
            void var1_1;
            this.field = var1_1;
        }

        @Override
        boolean isNumber() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean addRegex(FastDateParser parser, StringBuilder regex) {
            if (parser.isNextNumber()) {
                void var1_1;
                regex.append("(\\p{Nd}{").append(var1_1.getFieldWidth()).append("}+)");
            } else {
                void var2_2;
                var2_2.append("(\\p{Nd}++)");
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var3_3;
            cal.set(this.field, this.modify(Integer.parseInt((String)var3_3)));
        }

        int modify(int iValue) {
            return iValue;
        }
    }

    private static class CaseInsensitiveTextStrategy
    extends Strategy {
        private final int field;
        private final Locale locale;
        private final Map<String, Integer> lKeyValues;

        /*
         * WARNING - void declaration
         */
        CaseInsensitiveTextStrategy(int field, Calendar definingCalendar, Locale locale) {
            Iterator iterator;
            this.field = field;
            this.locale = locale;
            Map keyValues = FastDateParser.access$200(field, definingCalendar, locale);
            this.lKeyValues = new HashMap<String, Integer>();
            for (Map.Entry entry : iterator.entrySet()) {
                void var2_3;
                this.lKeyValues.put(((String)entry.getKey()).toLowerCase(locale), (Integer)var2_3.getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean addRegex(FastDateParser parser, StringBuilder regex) {
            void var2_2;
            regex.append("((?iu)");
            for (String textKeyValue : this.lKeyValues.keySet()) {
                void var3_3;
                FastDateParser.access$100(regex, (String)var3_3, false).append('|');
            }
            void v0 = var2_2;
            v0.setCharAt(v0.length() - 1, ')');
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        void setCalendar(FastDateParser parser, Calendar cal, String value) {
            void var2_2;
            void var1_1;
            Integer iVal = this.lKeyValues.get(value.toLowerCase(this.locale));
            if (iVal == null) {
                StringBuilder sb = new StringBuilder(value);
                sb.append(" not in (");
                for (String textKeyValue : this.lKeyValues.keySet()) {
                    void var3_3;
                    sb.append((String)var3_3).append(' ');
                }
                StringBuilder stringBuilder = sb;
                stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
                throw new IllegalArgumentException(var1_1.toString());
            }
            var2_2.set(this.field, var1_1.intValue());
        }
    }

    private static class CopyQuotedStrategy
    extends Strategy {
        private final String formatField;

        /*
         * WARNING - void declaration
         */
        CopyQuotedStrategy(String formatField) {
            void var1_1;
            this.formatField = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        boolean isNumber() {
            void var1_1;
            char c = this.formatField.charAt(0);
            if (c == '\'') {
                c = this.formatField.charAt(1);
            }
            return Character.isDigit((char)var1_1);
        }

        @Override
        boolean addRegex(FastDateParser parser, StringBuilder regex) {
            FastDateParser.access$100(regex, this.formatField, true);
            return false;
        }
    }

    private static abstract class Strategy {
        private Strategy() {
        }

        boolean isNumber() {
            return false;
        }

        void setCalendar(FastDateParser parser, Calendar cal, String value) {
        }

        abstract boolean addRegex(FastDateParser var1, StringBuilder var2);
    }
}

