/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import org.sqlite.SQLiteConfig;
import org.sqlite.date.FastDateFormat;

public class SQLiteConnectionConfig
implements Cloneable {
    private SQLiteConfig.DateClass dateClass = SQLiteConfig.DateClass.INTEGER;
    private SQLiteConfig.DatePrecision datePrecision = SQLiteConfig.DatePrecision.MILLISECONDS;
    private String dateStringFormat = "yyyy-MM-dd HH:mm:ss.SSS";
    private FastDateFormat dateFormat = FastDateFormat.getInstance(this.dateStringFormat);
    private int transactionIsolation = 8;
    private SQLiteConfig.TransactionMode transactionMode = SQLiteConfig.TransactionMode.DEFERRED;
    private boolean autoCommit = true;
    private static final Map<SQLiteConfig.TransactionMode, String> beginCommandMap = new EnumMap<SQLiteConfig.TransactionMode, String>(SQLiteConfig.TransactionMode.class);

    public static SQLiteConnectionConfig fromPragmaTable(Properties pragmaTable) {
        Properties properties;
        return new SQLiteConnectionConfig(SQLiteConfig.DateClass.getDateClass(pragmaTable.getProperty(SQLiteConfig.Pragma.DATE_CLASS.pragmaName, SQLiteConfig.DateClass.INTEGER.name())), SQLiteConfig.DatePrecision.getPrecision(pragmaTable.getProperty(SQLiteConfig.Pragma.DATE_PRECISION.pragmaName, SQLiteConfig.DatePrecision.MILLISECONDS.name())), pragmaTable.getProperty(SQLiteConfig.Pragma.DATE_STRING_FORMAT.pragmaName, "yyyy-MM-dd HH:mm:ss.SSS"), 8, SQLiteConfig.TransactionMode.getMode(properties.getProperty(SQLiteConfig.Pragma.TRANSACTION_MODE.pragmaName, SQLiteConfig.TransactionMode.DEFERRED.name())), true);
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnectionConfig(SQLiteConfig.DateClass dateClass, SQLiteConfig.DatePrecision datePrecision, String dateStringFormat, int transactionIsolation, SQLiteConfig.TransactionMode transactionMode, boolean autoCommit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setDateClass((SQLiteConfig.DateClass)var1_1);
        this.setDatePrecision((SQLiteConfig.DatePrecision)var2_2);
        this.setDateStringFormat((String)var3_3);
        this.setTransactionIsolation(transactionIsolation);
        this.setTransactionMode(transactionMode);
        this.setAutoCommit(autoCommit);
    }

    public SQLiteConnectionConfig copyConfig() {
        return new SQLiteConnectionConfig(this.dateClass, this.datePrecision, this.dateStringFormat, this.transactionIsolation, this.transactionMode, this.autoCommit);
    }

    public long getDateMultiplier() {
        if (this.datePrecision == SQLiteConfig.DatePrecision.MILLISECONDS) {
            return 1L;
        }
        return 1000L;
    }

    public SQLiteConfig.DateClass getDateClass() {
        return this.dateClass;
    }

    /*
     * WARNING - void declaration
     */
    public void setDateClass(SQLiteConfig.DateClass dateClass) {
        void var1_1;
        this.dateClass = var1_1;
    }

    public SQLiteConfig.DatePrecision getDatePrecision() {
        return this.datePrecision;
    }

    /*
     * WARNING - void declaration
     */
    public void setDatePrecision(SQLiteConfig.DatePrecision datePrecision) {
        void var1_1;
        this.datePrecision = var1_1;
    }

    public String getDateStringFormat() {
        return this.dateStringFormat;
    }

    /*
     * WARNING - void declaration
     */
    public void setDateStringFormat(String dateStringFormat) {
        void var1_1;
        this.dateStringFormat = dateStringFormat;
        this.dateFormat = FastDateFormat.getInstance((String)var1_1);
    }

    public FastDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoCommit(boolean autoCommit) {
        void var1_1;
        this.autoCommit = var1_1;
    }

    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransactionIsolation(int transactionIsolation) {
        void var1_1;
        this.transactionIsolation = var1_1;
    }

    public SQLiteConfig.TransactionMode getTransactionMode() {
        return this.transactionMode;
    }

    /*
     * WARNING - void declaration
     */
    public void setTransactionMode(SQLiteConfig.TransactionMode transactionMode) {
        void var1_1;
        this.transactionMode = var1_1;
    }

    String transactionPrefix() {
        return beginCommandMap.get(this.transactionMode);
    }

    static {
        beginCommandMap.put(SQLiteConfig.TransactionMode.DEFERRED, "begin;");
        beginCommandMap.put(SQLiteConfig.TransactionMode.IMMEDIATE, "begin immediate;");
        beginCommandMap.put(SQLiteConfig.TransactionMode.EXCLUSIVE, "begin exclusive;");
    }
}

