/*
 * Decompiled with CFR 0.152.
 */
package application.core.url;

import application.core.url.UrlValidator;
import com.eygraber.uri.Uri;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lapplication/core/url/UrlNormalizer;", "", "<init>", "()V", "", "urlString", "normalize", "(Ljava/lang/String;)Ljava/lang/String;", "Lapplication/core/url/UrlValidator;", "validator", "Lapplication/core/url/UrlValidator;", "Companion"})
@SourceDebugExtension(value={"SMAP\nUrlNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlNormalizer.kt\napplication/core/url/UrlNormalizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,145:1\n1179#2,2:146\n*S KotlinDebug\n*F\n+ 1 UrlNormalizer.kt\napplication/core/url/UrlNormalizer\n*L\n127#1:146,2\n*E\n"})
public final class UrlNormalizer {
    private static final Companion Companion = new Companion(null);
    private final UrlValidator validator = new UrlValidator();
    public static final Map<Character, String> QUERY_STRING_INVISIBLE_CHARS_MAPPING;

    /*
     * WARNING - void declaration
     */
    public final String normalize(String urlString) {
        Object object;
        block20: {
            void var1_1;
            block19: {
                Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
                if (!UrlValidator.isValid(urlString)) {
                    return urlString;
                }
                Object object2 = urlString;
                CharSequence charSequence = new StringBuilder();
                Object object3 = charSequence;
                for (int i = 0; i <= StringsKt.getLastIndex((CharSequence)((CharSequence)object2)); ++i) {
                    char c = ((String)object2).charAt(i);
                    if (i + 2 <= StringsKt.getLastIndex((CharSequence)((CharSequence)object2))) {
                        char c2 = ((String)object2).charAt(i + 1);
                        char c3 = ((String)object2).charAt(i + 2);
                        if (c == '%' && StringsKt.contains$default((CharSequence)"0123456789abcdefABCDEF", (char)c2, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)"0123456789abcdefABCDEF", (char)c3, (boolean)false, (int)2, null)) {
                            ((StringBuilder)object3).append(c);
                            ((StringBuilder)object3).append(Character.toUpperCase(c2));
                            ((StringBuilder)object3).append(Character.toUpperCase(c3));
                            int n = ++i;
                            ++i;
                            Integer.valueOf(n);
                            continue;
                        }
                        ((StringBuilder)object3).append(c);
                        continue;
                    }
                    ((StringBuilder)object3).append(c);
                }
                object = Uri.Companion.parseOrNull(((StringBuilder)charSequence).toString());
                if (object == null) break block19;
                charSequence = object;
                object2 = this;
                charSequence = charSequence.normalizeScheme();
                Object object4 = object2;
                object2 = charSequence;
                object3 = charSequence.buildUpon();
                Object object5 = object2.getEncodedAuthority();
                if (object5 != null) {
                    Object object6;
                    String string = ":80";
                    if (Intrinsics.areEqual((Object)object2.getScheme(), (Object)"http") && StringsKt.endsWith$default((String)object5, (String)string, (boolean)false, (int)2, null)) {
                        object5 = StringsKt.dropLast((String)object5, (int)string.length());
                    }
                    String string2 = ":443";
                    if (Intrinsics.areEqual((Object)object2.getScheme(), (Object)"https") && StringsKt.endsWith$default((String)object5, (String)string2, (boolean)false, (int)2, null)) {
                        object5 = StringsKt.dropLast((String)object5, (int)string2.length());
                    }
                    if (StringsKt.contains$default((CharSequence)object5, (char)'@', (boolean)false, (int)2, null)) {
                        String string3 = StringsKt.substringBefore$default((String)object5, (char)'@', null, (int)2, null);
                        String string4 = StringsKt.substringAfter$default((String)object5, (char)'@', null, (int)2, null).toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                        object6 = string3 + "@" + string4;
                    } else {
                        String string5 = ((String)object5).toLowerCase(Locale.ROOT);
                        object6 = string5;
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
                    }
                    object5 = object6;
                    object3.encodedAuthority((String)object5);
                }
                if ((object5 = (CharSequence)(object2 = charSequence).getPath()) == null || object5.length() == 0) {
                    object3.path("/");
                }
                if (!((Collection)(object2 = charSequence).getPathSegments()).isEmpty()) {
                    object5 = new ArrayList();
                    for (int i = 0; i <= CollectionsKt.getLastIndex((List)object2.getPathSegments()); ++i) {
                        String string = (String)object2.getPathSegments().get(i);
                        if (Intrinsics.areEqual((Object)string, (Object)"..")) {
                            CollectionsKt.removeLastOrNull((List)object5);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)string, (Object)".")) continue;
                        object5.add(string);
                    }
                    object3.path(CollectionsKt.joinToString$default((Iterable)((Iterable)object5), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
                }
                StringBuilder stringBuilder = charSequence;
                object2 = object3;
                object3 = object4;
                object5 = stringBuilder.getEncodedQuery();
                boolean bl = object5 != null ? ((CharSequence)object5).length() > 0 : false;
                if (bl) {
                    String string = StringsKt.replace$default((String)object5, (String)"%20", (String)"+", (boolean)false, (int)4, null);
                    charSequence = string;
                    object3 = new StringBuilder();
                    stringBuilder = object3;
                    charSequence = charSequence;
                    for (int i = 0; i < charSequence.length(); ++i) {
                        char c = charSequence.charAt(i);
                        Object object7 = QUERY_STRING_INVISIBLE_CHARS_MAPPING.get(Character.valueOf(c));
                        if (object7 == null) {
                            object7 = Character.valueOf(c);
                        }
                        stringBuilder.append(object7);
                    }
                    object2.encodedQuery(((StringBuilder)object3).toString());
                }
                if ((object = object2.build().toString()) != null) break block20;
            }
            object = var1_1;
        }
        return object;
    }

    static {
        Pair[] pairArray = new Pair[4];
        Pair[] pairArray2 = pairArray;
        pairArray[0] = TuplesKt.to((Object)Character.valueOf(' '), (Object)"+");
        pairArray2[1] = TuplesKt.to((Object)Character.valueOf('\t'), (Object)"%09");
        pairArray2[2] = TuplesKt.to((Object)Character.valueOf('\u00a0'), (Object)"%C2%A0");
        pairArray2[3] = TuplesKt.to((Object)Character.valueOf('\u00ad'), (Object)"%C2%AD");
        QUERY_STRING_INVISIBLE_CHARS_MAPPING = MapsKt.mapOf((Pair[])pairArray2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\b"}, d2={"Lapplication/core/url/UrlNormalizer$Companion;", "", "<init>", "()V", "", "", "", "QUERY_STRING_INVISIBLE_CHARS_MAPPING", "Ljava/util/Map;"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

