/*
 * Decompiled with CFR 0.152.
 */
package application.core.targets.discovery;

import application.core.targets.WindowsIconExtractor;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\"\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\"\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Ljava/io/File;", "executable", "", "extractIconFrom", "(Ljava/io/File;)[B", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "ICON_SIZE", "I"})
public final class WindowsTargetDiscoveryKt {
    private static final KLogger logger = KotlinLogging.INSTANCE.logger(WindowsTargetDiscoveryKt::logger$lambda$0);
    private static final int ICON_SIZE = 128;

    /*
     * WARNING - void declaration
     */
    private static final byte[] extractIconFrom(File executable) {
        try {
            void var1_1;
            String string = executable.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            BufferedImage bufferedImage = WindowsIconExtractor.INSTANCE.getIconForFile(128, 128, string);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            boolean bl = ImageIO.write((RenderedImage)var1_1, "png", output);
            if (bl) {
                return output.toByteArray();
            }
            return null;
        }
        catch (Exception ex) {
            File file;
            void var2_4;
            logger.warn((Throwable)var2_4, () -> WindowsTargetDiscoveryKt.extractIconFrom$lambda$1(file));
            return null;
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object extractIconFrom$lambda$1(File $executable) {
        return "Unable to extract icon from executable '" + $executable + "'";
    }

    public static final /* synthetic */ KLogger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ byte[] access$extractIconFrom(File executable) {
        return WindowsTargetDiscoveryKt.extractIconFrom(executable);
    }
}

