/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010!\n\u0002\b\b\b\u0001\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BI\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00128\u0010\n\u001a4\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001f\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eRF\u0010\n\u001a4\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0015\u0012\u0013\u0018\u00018\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010 R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "R", "", "Lorg/jetbrains/skiko/GraphicsApi;", "defaultRenderApi", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "renderApi", "oldRedrawer", "redrawerFactory", "<init>", "(Lorg/jetbrains/skiko/GraphicsApi;Lkotlin/jvm/functions/Function2;)V", "", "dispose", "()V", "", "recreation", "findNextWorkingRenderApi", "(Z)V", "forceRenderApi", "(Lorg/jetbrains/skiko/GraphicsApi;)V", "_redrawer", "Ljava/lang/Object;", "_renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "", "fallbackRenderApiQueue", "Ljava/util/List;", "getRedrawer", "()Ljava/lang/Object;", "redrawer", "Lkotlin/jvm/functions/Function2;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;"})
@SourceDebugExtension(value={"SMAP\nRedrawerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,51:1\n159#2,4:52\n*S KotlinDebug\n*F\n+ 1 RedrawerManager.kt\norg/jetbrains/skiko/redrawer/RedrawerManager\n*L\n34#1:52,4\n*E\n"})
public final class RedrawerManager<R> {
    private final Function2<GraphicsApi, R, R> redrawerFactory;
    private R _redrawer;
    private final List<GraphicsApi> fallbackRenderApiQueue;
    private GraphicsApi _renderApi;

    /*
     * WARNING - void declaration
     */
    public RedrawerManager(GraphicsApi defaultRenderApi, Function2<? super GraphicsApi, ? super R, ? extends R> redrawerFactory) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)defaultRenderApi), (String)"defaultRenderApi");
        Intrinsics.checkNotNullParameter(redrawerFactory, (String)"redrawerFactory");
        this.redrawerFactory = var2_2;
        this.fallbackRenderApiQueue = CollectionsKt.toMutableList((Collection)SkikoProperties.INSTANCE.fallbackRenderApiQueue$skiko((GraphicsApi)var1_1));
        this._renderApi = this.fallbackRenderApiQueue.get(0);
    }

    public final R getRedrawer() {
        return this._redrawer;
    }

    public final GraphicsApi getRenderApi() {
        return this._renderApi;
    }

    /*
     * WARNING - void declaration
     */
    public final void findNextWorkingRenderApi(boolean recreation) {
        boolean bl;
        if (recreation) {
            this.fallbackRenderApiQueue.add(0, this.getRenderApi());
        }
        do {
            boolean thrown = false;
            try {
                this._renderApi = this.fallbackRenderApiQueue.remove(0);
                this._redrawer = this.redrawerFactory.invoke((Object)this._renderApi, this.getRedrawer());
            }
            catch (RenderException e) {
                this._redrawer = null;
                Logger this_$iv = Logger.INSTANCE;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    void var1_2;
                    Throwable throwable = (Throwable)var1_2;
                    SkikoLoggerInterface skikoLoggerInterface = ((Logger)((Object)throwable)).getLoggerImpl();
                    String string = "Fallback to next API";
                    skikoLoggerInterface.warn(throwable, string);
                }
                bl = true;
            }
        } while (bl && !((Collection)this.fallbackRenderApiQueue).isEmpty());
        if (bl) {
            throw new RenderException("Cannot fallback to any render API", null, 2, null);
        }
    }

    public static /* synthetic */ void findNextWorkingRenderApi$default(RedrawerManager redrawerManager2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        redrawerManager2.findNextWorkingRenderApi(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void forceRenderApi(GraphicsApi renderApi) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
        this._renderApi = var1_1;
    }

    public final void dispose() {
        this._redrawer = null;
    }
}

