/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import java.lang.ref.Reference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.NativeKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.JvmContextHandler;
import org.jetbrains.skiko.redrawer.AbstractDirectSoftwareRedrawer;
import org.jetbrains.skiko.redrawer.Redrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R\"\u0010\u0015\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/skiko/context/DirectSoftwareContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "Lorg/jetbrains/skiko/SkiaLayer;", "layer", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;)V", "", "flush", "()V", "initCanvas", "", "initContext", "()Z", "", "width", "height", "isSizeChanged", "(II)Z", "currentHeight", "I", "currentWidth", "isInited", "Z", "setInited", "(Z)V", "Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "getSoftwareRedrawer", "()Lorg/jetbrains/skiko/redrawer/AbstractDirectSoftwareRedrawer;", "softwareRedrawer"})
@SourceDebugExtension(value={"SMAP\nDirectSoftwareContextHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectSoftwareContextHandler.kt\norg/jetbrains/skiko/context/DirectSoftwareContextHandler\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,63:1\n124#2,4:64\n*S KotlinDebug\n*F\n+ 1 DirectSoftwareContextHandler.kt\norg/jetbrains/skiko/context/DirectSoftwareContextHandler\n*L\n29#1:64,4\n*E\n"})
public final class DirectSoftwareContextHandler
extends JvmContextHandler {
    private boolean isInited;
    private int currentWidth;
    private int currentHeight;

    /*
     * WARNING - void declaration
     */
    public DirectSoftwareContextHandler(SkiaLayer layer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        super((SkiaLayer)var1_1);
    }

    public final boolean isInited() {
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    public final void setInited(boolean bl) {
        void var1_1;
        this.isInited = var1_1;
    }

    private final AbstractDirectSoftwareRedrawer getSoftwareRedrawer() {
        Redrawer redrawer = this.getLayer().getRedrawer$skiko();
        Intrinsics.checkNotNull((Object)redrawer);
        return (AbstractDirectSoftwareRedrawer)redrawer;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSizeChanged(int width2, int height2) {
        if (width2 != this.currentWidth || height2 != this.currentHeight) {
            void var2_2;
            void var1_1;
            this.currentWidth = var1_1;
            this.currentHeight = var2_2;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean initContext() {
        if (!this.isInited) {
            Logger this_$iv;
            if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && (this_$iv = Logger.INSTANCE).getLoggerImpl().isInfoEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface;
                skikoLoggerInterface = ((Logger)((Object)skikoLoggerInterface)).getLoggerImpl();
                skikoLoggerInterface.info("Renderer info:\n " + this.rendererInfo());
            }
            this.isInited = true;
        }
        return this.isInited;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void initCanvas() {
        int h;
        float scale = this.getLayer().getContentScale();
        int w = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getWidth() * scale)), (int)0);
        if (this.isSizeChanged(w, h = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getHeight() * scale)), (int)0)) || this.getSurface() == null) {
            this.disposeCanvas();
            if (w > 0 && h > 0) {
                void var1_2;
                void var2_3;
                this.getSoftwareRedrawer().resize((int)var2_3, (int)var1_2);
                DirectSoftwareContextHandler directSoftwareContextHandler = this;
                directSoftwareContextHandler.setSurface(directSoftwareContextHandler.getSoftwareRedrawer().acquireSurface());
                DirectSoftwareContextHandler directSoftwareContextHandler2 = this;
                Surface surface = directSoftwareContextHandler2.getSurface();
                Intrinsics.checkNotNull((Object)surface);
                directSoftwareContextHandler2.setCanvas(surface.getCanvas());
                return;
            }
            this.setSurface(null);
            this.setCanvas(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void flush() {
        Surface surface = this.getSurface();
        if (surface != null) {
            try {
                this.getSoftwareRedrawer().finishFrame(NativeKt.getPtr(surface));
            }
            catch (Throwable throwable) {
                void var1_1;
                Reference.reachabilityFence(var1_1);
                throw throwable;
            }
            Reference.reachabilityFence(surface);
            return;
        }
    }
}

