/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.skiko.LibraryLoadException;
import org.jetbrains.skiko.OS;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.Setup;
import org.jetbrains.skiko.SkikoProperties;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\r\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/skiko/Library;", "", "<init>", "()V", "", "findAndLoad", "load", "Ljava/io/File;", "library", "loadLibraryOrCopy", "(Ljava/io/File;)V", "dest", "", "resourceName", "", "deleteOnExit", "unpackIfNeeded", "(Ljava/io/File;Ljava/lang/String;Z)Ljava/io/File;", "copyDir", "Ljava/io/File;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "loaded", "Ljava/util/concurrent/atomic/AtomicBoolean;"})
@SourceDebugExtension(value={"SMAP\nLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Library.kt\norg/jetbrains/skiko/Library\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class Library {
    public static final Library INSTANCE = new Library();
    private static File copyDir;
    private static AtomicBoolean loaded;

    private Library() {
    }

    /*
     * WARNING - void declaration
     */
    private final void loadLibraryOrCopy(File library) {
        try {
            System.load(library.getAbsolutePath());
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            void var2_2;
            UnsatisfiedLinkError e = unsatisfiedLinkError;
            String string = unsatisfiedLinkError.getMessage();
            boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"already loaded in another classloader", (boolean)false, (int)2, null) : false;
            if (bl) {
                CopyOption[] copyOptionArray;
                copyDir = Files.createTempDirectory("skiko", new FileAttribute[0]).toFile();
                Intrinsics.checkNotNull((Object)copyDir);
                String string2 = library.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                File tempFile = FilesKt.resolve((File)copyDir, (String)string2);
                Path path = copyOptionArray.toPath();
                CopyOption[] copyOptionArray2 = new CopyOption[1];
                copyOptionArray = copyOptionArray2;
                copyOptionArray2[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy(path, tempFile.toPath(), copyOptionArray);
                tempFile.deleteOnExit();
                System.load(var2_2.getAbsolutePath());
                return;
            }
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File unpackIfNeeded(File dest, String resourceName, boolean deleteOnExit) {
        File file;
        block5: {
            void var1_1;
            CopyOption[] copyOptionArray;
            void var3_3;
            file = new File(dest, resourceName);
            if (file.exists()) break block5;
            File tempFile = File.createTempFile("skiko", "", dest);
            if (var3_3 != false) {
                file.deleteOnExit();
            }
            copyOptionArray = (CopyOption[])Library.class.getResourceAsStream("/" + (String)copyOptionArray);
            Throwable throwable = null;
            try {
                CopyOption[] copyOptionArray2 = copyOptionArray;
                CopyOption[] copyOptionArray3 = copyOptionArray2;
                CopyOption[] copyOptionArray4 = new CopyOption[1];
                copyOptionArray3 = copyOptionArray4;
                copyOptionArray4[0] = StandardCopyOption.REPLACE_EXISTING;
                Files.copy((InputStream)copyOptionArray2, tempFile.toPath(), copyOptionArray3);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)copyOptionArray, null);
            CopyOption[] copyOptionArray5 = new CopyOption[1];
            copyOptionArray = copyOptionArray5;
            copyOptionArray5[0] = StandardCopyOption.ATOMIC_MOVE;
            Files.move(var1_1.toPath(), file.toPath(), copyOptionArray);
        }
        return file;
    }

    public final synchronized void load() {
        if (!loaded.compareAndSet(false, true)) {
            return;
        }
        this.findAndLoad();
        Setup.init$default(Setup.INSTANCE, false, false, false, false, false, 31, null);
        try {
            org.jetbrains.skia.impl.Library.Companion._nAfterLoad();
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findAndLoad() {
        Object it2;
        String icu;
        String string = "skiko-" + OsArch_jvmKt.getHostId();
        String platformName = System.mapLibraryName(string);
        String string2 = icu = OsArch_jvmKt.getHostOs().isWindows() ? "icudtl.dat" : null;
        if (OsArch_jvmKt.getHostOs() == OS.Android) {
            System.loadLibrary("skiko-" + OsArch_jvmKt.getHostId());
            return;
        }
        String skikoLibraryPath = SkikoProperties.INSTANCE.getLibraryPath();
        if (skikoLibraryPath != null) {
            File library = new File(new File(skikoLibraryPath), platformName);
            this.loadLibraryOrCopy(library);
            if (icu != null && copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
            }
            return;
        }
        Object jvmFiles = new File(System.getProperty("java.home"), OsArch_jvmKt.getHostOs().isWindows() ? "bin" : "lib");
        Intrinsics.checkNotNull((Object)platformName);
        Serializable pathInJvm = FilesKt.resolve((File)jvmFiles, (String)platformName);
        if (pathInJvm.exists()) {
            String string3 = icu;
            if (!(string3 != null ? !FilesKt.resolve((File)jvmFiles, (String)(it2 = string3)).exists() : false)) {
                this.loadLibraryOrCopy((File)pathInJvm);
                return;
            }
        }
        if ((it2 = Library.class.getResourceAsStream("/" + platformName + ".sha256")) == null) {
            throw new LibraryLoadException("Cannot find " + platformName + ".sha256, proper native dependency missing.");
        }
        jvmFiles = it2;
        jvmFiles = (Closeable)jvmFiles;
        pathInJvm = null;
        try {
            it2 = (InputStream)jvmFiles;
            Charset charset = Charsets.UTF_8;
            it2 = new InputStreamReader((InputStream)it2, charset);
            it2 = new BufferedReader((Reader)it2, 8192).readLine();
        }
        catch (Throwable throwable) {
            try {
                it2 = throwable;
                pathInJvm = throwable;
                throw it2;
            }
            catch (Throwable it2) {
                CloseableKt.closeFinally((Closeable)jvmFiles, (Throwable)pathInJvm);
                throw it2;
            }
        }
        CloseableKt.closeFinally((Closeable)jvmFiles, null);
        Object hash = it2;
        File dataDir = new File(new File(SkikoProperties.INSTANCE.getDataPath()), (String)hash);
        dataDir.mkdirs();
        File library = this.unpackIfNeeded(dataDir, string, false);
        this.loadLibraryOrCopy(library);
        if (icu != null) {
            void var2_2;
            void var3_3;
            if (copyDir != null) {
                File file = copyDir;
                Intrinsics.checkNotNull((Object)file);
                this.unpackIfNeeded(file, icu, true);
                return;
            }
            this.unpackIfNeeded((File)var3_3, (String)var2_2, false);
        }
    }

    static {
        loaded = new AtomicBoolean(false);
    }
}

