/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.DirectDataBuffer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0011\u0010\u0004\u001a\u00020\u0000*\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0011\u0010\u0007\u001a\u00020\u0006*\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/skia/Bitmap;", "toBitmap", "(Ljava/awt/image/BufferedImage;)Lorg/jetbrains/skia/Bitmap;", "toBufferedImage", "(Lorg/jetbrains/skia/Bitmap;)Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/skia/Image;", "toImage", "(Ljava/awt/image/BufferedImage;)Lorg/jetbrains/skia/Image;"})
public final class Convertors_jvmKt {
    /*
     * WARNING - void declaration
     */
    public static final BufferedImage toBufferedImage(Bitmap $this$toBufferedImage) {
        WritableRaster writableRaster;
        void var1_2;
        int[] nArray;
        int[] nArray2;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedImage, (String)"<this>");
        Pixmap pixmap = $this$toBufferedImage.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long pixelsNativePointer = pixmap.getAddr();
        ByteBuffer pixelsBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(pixelsNativePointer, $this$toBufferedImage.getRowBytes() * $this$toBufferedImage.getHeight());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBufferedImage.getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray3 = new int[4];
                nArray2 = nArray3;
                nArray3[0] = 0;
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray4 = new int[4];
                nArray2 = nArray4;
                nArray4[0] = 2;
                nArray2[1] = 1;
                nArray2[2] = 0;
                nArray2[3] = 3;
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)$this$toBufferedImage.getColorInfo().getColorType()));
            }
        }
        int[] order = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(new DirectDataBuffer(pixelsBuffer), $this$toBufferedImage.getWidth(), $this$toBufferedImage.getHeight(), $this$toBufferedImage.getWidth() * 4, 4, nArray2, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel2 = (ColorModel)var1_2;
        WritableRaster writableRaster2 = writableRaster;
        Intrinsics.checkNotNull((Object)writableRaster2);
        return new BufferedImage(colorModel2, writableRaster2, false, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final Bitmap toBitmap(BufferedImage $this$toBitmap) {
        void var3_4;
        void var1_1;
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        byte[] pixels = new byte[$this$toBitmap.getWidth() * $this$toBitmap.getHeight() * 4];
        int k = 0;
        int n = $this$toBitmap.getHeight();
        for (int y2 = 0; y2 < n; ++y2) {
            int n2 = $this$toBitmap.getWidth();
            for (int x2 = 0; x2 < n2; ++x2) {
                int argb = $this$toBitmap.getRGB(x2, y2);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                pixels[k++] = (byte)b;
                pixels[k++] = (byte)g;
                pixels[k++] = (byte)r;
                pixels[k++] = (byte)a;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toBitmap.getWidth(), bufferedImage.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels((byte[])var1_1);
        return var3_4;
    }

    public static final Image toImage(BufferedImage $this$toImage) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap(bufferedImage));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.RGB_888X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ColorType.BGRA_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

