/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.DurationUnitKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0017\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\n\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001d\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001d\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u001a\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0003J\u001f\u0010 \u001a\u00020\u00002\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b \u0010\u0012J\u000f\u0010!\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b!\u0010\u0014J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0001H\u0016\u00a2\u0006\u0004\b#\u0010$R\u0018\u0010%\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010\u0013\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0013\u0010'R\u0016\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010(R\u0016\u0010!\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010'\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lokio/Timeout;", "", "<init>", "()V", "Ljava/util/concurrent/locks/Condition;", "condition", "", "awaitSignal", "(Ljava/util/concurrent/locks/Condition;)V", "cancel", "clearDeadline", "()Lokio/Timeout;", "clearTimeout", "", "duration", "Ljava/util/concurrent/TimeUnit;", "unit", "deadline", "(JLjava/util/concurrent/TimeUnit;)Lokio/Timeout;", "deadlineNanoTime", "()J", "(J)Lokio/Timeout;", "", "hasDeadline", "()Z", "T", "other", "Lkotlin/Function0;", "block", "intersectWith", "(Lokio/Timeout;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "throwIfReached", "timeout", "timeoutNanos", "monitor", "waitUntilNotified", "(Ljava/lang/Object;)V", "cancelMark", "Ljava/lang/Object;", "J", "Z", "Companion"})
@SourceDebugExtension(value={"SMAP\nTimeout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Timeout.kt\nokio/Timeout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,358:1\n1#2:359\n*E\n"})
public class Timeout {
    public static final Companion Companion = new Companion(null);
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;
    private volatile Object cancelMark;
    @JvmField
    public static final Timeout NONE = new Timeout(){

        public final Timeout timeout(long timeout, TimeUnit unit) {
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            return this;
        }

        public final Timeout deadlineNanoTime(long deadlineNanoTime) {
            return this;
        }

        public final void throwIfReached() {
        }
    };

    /*
     * WARNING - void declaration
     */
    public Timeout timeout(long timeout2, TimeUnit unit) {
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(timeout2 >= 0L)) {
            String timeout2 = "timeout < 0: " + timeout2;
            throw new IllegalArgumentException(timeout2.toString());
        }
        this.timeoutNanos = var3_3.toNanos((long)var1_1);
        return this;
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (!this.hasDeadline) {
            String string = "No deadline";
            throw new IllegalStateException(string.toString());
        }
        return this.deadlineNanoTime;
    }

    /*
     * WARNING - void declaration
     */
    public Timeout deadlineNanoTime(long deadlineNanoTime) {
        void var1_1;
        this.hasDeadline = true;
        this.deadlineNanoTime = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final Timeout deadline(long duration2, TimeUnit unit) {
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(duration2 > 0L)) {
            String duration2 = "duration <= 0: " + duration2;
            throw new IllegalArgumentException(duration2.toString());
        }
        return this.deadlineNanoTime(System.nanoTime() + var3_3.toNanos((long)var1_1));
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("interrupted");
        }
        if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
            throw new InterruptedIOException("deadline reached");
        }
    }

    public void cancel() {
        this.cancelMark = new Object();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitSignal(Condition condition) throws InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        try {
            void var1_1;
            void waitNanos;
            long l;
            boolean hasDeadline = this.hasDeadline();
            long timeoutNanos = this.timeoutNanos();
            if (!hasDeadline && timeoutNanos == 0L) {
                condition.await();
                return;
            }
            if (hasDeadline && timeoutNanos != 0L) {
                long deadlineNanos = this.deadlineNanoTime() - System.nanoTime();
                l = Math.min(timeoutNanos, deadlineNanos);
            } else {
                void var3_3;
                void var2_2;
                l = waitNanos = var2_2 != false ? this.deadlineNanoTime() - System.nanoTime() : var3_3;
            }
            if (l <= 0L) {
                throw new InterruptedIOException("timeout");
            }
            Object cancelMarkBefore = this.cancelMark;
            long l2 = var1_1.awaitNanos((long)waitNanos);
            if (l2 > 0L) {
                return;
            }
            if (this.cancelMark != cancelMarkBefore) {
                return;
            }
            throw new InterruptedIOException("timeout");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
    }

    /*
     * WARNING - void declaration
     */
    public void waitUntilNotified(Object monitor) throws InterruptedIOException {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        try {
            void var1_1;
            void waitNanos;
            long l;
            boolean hasDeadline = this.hasDeadline();
            long timeoutNanos = this.timeoutNanos();
            if (!hasDeadline && timeoutNanos == 0L) {
                monitor.wait();
                return;
            }
            long start = System.nanoTime();
            if (hasDeadline && timeoutNanos != 0L) {
                long deadlineNanos = this.deadlineNanoTime() - start;
                l = Math.min(timeoutNanos, deadlineNanos);
            } else {
                void var3_3;
                void var2_2;
                l = waitNanos = var2_2 != false ? this.deadlineNanoTime() - start : var3_3;
            }
            if (l <= 0L) {
                throw new InterruptedIOException("timeout");
            }
            Object cancelMarkBefore = this.cancelMark;
            void waitMillis = waitNanos / 1000000L;
            var1_1.wait((long)waitMillis, (int)(waitNanos - waitMillis * 1000000L));
            long l2 = System.nanoTime() - start;
            if (l2 < waitNanos) {
                return;
            }
            if (this.cancelMark != cancelMarkBefore) {
                return;
            }
            throw new InterruptedIOException("timeout");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("interrupted");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T intersectWith(Timeout other, Function0<? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long originalTimeout = this.timeoutNanos();
        this.timeout(Companion.minTimeout(other.timeoutNanos(), this.timeoutNanos()), TimeUnit.NANOSECONDS);
        if (this.hasDeadline()) {
            long originalDeadline = this.deadlineNanoTime();
            if (other.hasDeadline()) {
                Timeout timeout = this;
                timeout.deadlineNanoTime(Math.min(timeout.deadlineNanoTime(), other.deadlineNanoTime()));
            }
            try {
                block = block.invoke();
                return (T)block;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.timeout(originalTimeout, TimeUnit.NANOSECONDS);
                if (other.hasDeadline()) {
                    this.deadlineNanoTime(originalDeadline);
                }
                InlineMarker.finallyEnd((int)1);
            }
        }
        if (other.hasDeadline()) {
            this.deadlineNanoTime(other.deadlineNanoTime());
        }
        try {
            void var2_2;
            object = var2_2.invoke();
        }
        catch (Throwable throwable) {
            void var1_1;
            void var3_4;
            InlineMarker.finallyStart((int)1);
            this.timeout((long)var3_4, TimeUnit.NANOSECONDS);
            if (var1_1.hasDeadline()) {
                this.clearDeadline();
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        this.timeout(originalTimeout, TimeUnit.NANOSECONDS);
        if (other.hasDeadline()) {
            this.clearDeadline();
        }
        InlineMarker.finallyEnd((int)1);
        return (T)object;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\n\u0010\rJ\u001c\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001"}, d2={"Lokio/Timeout$Companion;", "", "<init>", "()V", "", "aNanos", "bNanos", "minTimeout", "(JJ)J", "Lokio/Timeout;", "timeout", "Lkotlin/time/DurationUnit;", "unit", "(Lokio/Timeout;JLkotlin/time/DurationUnit;)Lokio/Timeout;", "Lkotlin/time/Duration;", "duration", "timeout-HG0u8IE", "(Lokio/Timeout;J)Lokio/Timeout;", "NONE", "Lokio/Timeout;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final Timeout timeout(Timeout $this$timeout, long timeout, DurationUnit unit) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
            return var1_1.timeout((long)var2_2, DurationUnitKt.toTimeUnit((DurationUnit)unit));
        }

        /*
         * WARNING - void declaration
         */
        public final Timeout timeout-HG0u8IE(Timeout $this$timeout_u2dHG0u8IE, long duration) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$timeout_u2dHG0u8IE, (String)"$this$timeout");
            return var1_1.timeout(Duration.getInWholeNanoseconds-impl((long)var2_2), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public final long minTimeout(long aNanos, long bNanos) {
            void var3_2;
            if (aNanos != 0L) {
                if (bNanos == 0L) {
                    return aNanos;
                }
                if (aNanos < bNanos) {
                    void var1_1;
                    return (long)var1_1;
                }
            }
            return (long)var3_2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

