/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.-SegmentedByteString;
import okio.Buffer;
import okio.ByteString;
import okio.ForwardingSink;
import okio.Segment;
import okio.Sink;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001e2\u00020\u00012\u00020\u0002:\u0001\u001eB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nB\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\rB!\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u000f\u0010\u0013\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0013\u001a\u00020\u000e8G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0012R\u0016\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"Lokio/HashingSink;", "Lokio/ForwardingSink;", "Lokio/Sink;", "sink", "Ljava/security/MessageDigest;", "digest", "<init>", "(Lokio/Sink;Ljava/security/MessageDigest;)V", "", "algorithm", "(Lokio/Sink;Ljava/lang/String;)V", "Ljavax/crypto/Mac;", "mac", "(Lokio/Sink;Ljavax/crypto/Mac;)V", "Lokio/ByteString;", "key", "(Lokio/Sink;Lokio/ByteString;Ljava/lang/String;)V", "-deprecated_hash", "()Lokio/ByteString;", "hash", "Lokio/Buffer;", "source", "", "byteCount", "", "write", "(Lokio/Buffer;J)V", "Ljavax/crypto/Mac;", "messageDigest", "Ljava/security/MessageDigest;", "Companion"})
@SourceDebugExtension(value={"SMAP\nHashingSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n+ 2 Util.kt\nokio/-SegmentedByteString\n*L\n1#1,149:1\n86#2:150\n*S KotlinDebug\n*F\n+ 1 HashingSink.kt\nokio/HashingSink\n*L\n76#1:150\n*E\n"})
public final class HashingSink
extends ForwardingSink
implements Sink {
    public static final Companion Companion = new Companion(null);
    private final MessageDigest messageDigest;
    private final Mac mac;

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, MessageDigest digest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        super((Sink)var1_1);
        this.messageDigest = var2_2;
        this.mac = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, String algorithm) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        MessageDigest messageDigest = MessageDigest.getInstance((String)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest, (String)"getInstance(...)");
        this((Sink)var1_1, messageDigest);
    }

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, Mac mac) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super((Sink)var1_1);
        this.mac = var2_2;
        this.messageDigest = null;
    }

    /*
     * WARNING - void declaration
     */
    public HashingSink(Sink sink2, ByteString key, String algorithm) {
        void v3;
        HashingSink hashingSink;
        Object object;
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        Mac mac = object;
        object = this;
        try {
            void var3_3;
            void var2_2;
            void $this$_init__u24lambda_u240;
            HashingSink hashingSink2 = object;
            void v1 = mac;
            object = Mac.getInstance(algorithm);
            mac = object;
            void var6_6 = v1;
            HashingSink hashingSink3 = hashingSink2;
            $this$_init__u24lambda_u240.init(new SecretKeySpec(var2_2.toByteArray(), (String)var3_3));
            hashingSink = hashingSink3;
            v3 = var6_6;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        Intrinsics.checkNotNull((Object)object);
        hashingSink((Sink)v3, (Mac)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void write(Buffer source2, long byteCount) throws IOException {
        void var2_2;
        void var1_1;
        int toHash;
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        -SegmentedByteString.checkOffsetAndCount(source2.size(), 0L, byteCount);
        Segment segment = source2.head;
        Intrinsics.checkNotNull((Object)segment);
        Segment s = segment;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            void a$iv;
            long l = byteCount - hashedCount;
            int b$iv = s.limit - s.pos;
            toHash = (int)Math.min((long)a$iv, (long)b$iv);
            if (this.messageDigest != null) {
                this.messageDigest.update(s.data, s.pos, toHash);
            } else {
                Mac mac = this.mac;
                Intrinsics.checkNotNull((Object)mac);
                mac.update(s.data, s.pos, toHash);
            }
            Intrinsics.checkNotNull((Object)s.next);
        }
        super.write((Buffer)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="hash")
    public final ByteString hash() {
        void var1_1;
        byte[] byArray;
        if (this.messageDigest != null) {
            byArray = this.messageDigest.digest();
        } else {
            Mac mac = this.mac;
            Intrinsics.checkNotNull((Object)mac);
            byArray = mac.doFinal();
        }
        byte[] result = byArray;
        Intrinsics.checkNotNull((Object)result);
        return new ByteString((byte[])var1_1);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hash", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hash")
    public final ByteString -deprecated_hash() {
        return this.hash();
    }

    @JvmStatic
    public static final HashingSink md5(Sink sink2) {
        Sink sink3;
        return Companion.md5(sink3);
    }

    @JvmStatic
    public static final HashingSink sha1(Sink sink2) {
        Sink sink3;
        return Companion.sha1(sink3);
    }

    @JvmStatic
    public static final HashingSink sha256(Sink sink2) {
        Sink sink3;
        return Companion.sha256(sink3);
    }

    @JvmStatic
    public static final HashingSink sha512(Sink sink2) {
        Sink sink3;
        return Companion.sha512(sink3);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSink hmacSha1(Sink sink2, ByteString key) {
        void var1_1;
        Sink sink3;
        return Companion.hmacSha1(sink3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSink hmacSha256(Sink sink2, ByteString key) {
        void var1_1;
        Sink sink3;
        return Companion.hmacSha256(sink3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final HashingSink hmacSha512(Sink sink2, ByteString key) {
        void var1_1;
        Sink sink3;
        return Companion.hmacSha512(sink3, (ByteString)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001f\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0017\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u000e"}, d2={"Lokio/HashingSink$Companion;", "", "<init>", "()V", "Lokio/Sink;", "sink", "Lokio/ByteString;", "key", "Lokio/HashingSink;", "hmacSha1", "(Lokio/Sink;Lokio/ByteString;)Lokio/HashingSink;", "hmacSha256", "hmacSha512", "md5", "(Lokio/Sink;)Lokio/HashingSink;", "sha1", "sha256", "sha512"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink md5(Sink sink2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink((Sink)var1_1, "MD5");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink sha1(Sink sink2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink((Sink)var1_1, "SHA-1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink sha256(Sink sink2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink((Sink)var1_1, "SHA-256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink sha512(Sink sink2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            return new HashingSink((Sink)var1_1, "SHA-512");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink hmacSha1(Sink sink2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink((Sink)var1_1, (ByteString)var2_2, "HmacSHA1");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink hmacSha256(Sink sink2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink((Sink)var1_1, (ByteString)var2_2, "HmacSHA256");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final HashingSink hmacSha512(Sink sink2, ByteString key) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new HashingSink((Sink)var1_1, (ByteString)var2_2, "HmacSHA512");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

