/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import java.lang.reflect.Array;

public abstract class OaIdlUtil {
    /*
     * WARNING - void declaration
     */
    public static Object toPrimitiveArray(OaIdl.SAFEARRAY sa, boolean destruct) {
        Pointer dataPointer = sa.accessData();
        try {
            void var3_6;
            void var2_2;
            int i;
            int dimensions2 = sa.getDimensionCount();
            int[] elements = new int[dimensions2];
            int[] cumElements = new int[dimensions2];
            int varType = sa.getVarType().intValue();
            for (i = 0; i < dimensions2; ++i) {
                elements[i] = sa.getUBound(i) - sa.getLBound(i) + 1;
            }
            for (i = dimensions2 - 1; i >= 0; --i) {
                cumElements[i] = i == dimensions2 - 1 ? 1 : cumElements[i + 1] * elements[i + 1];
            }
            if (dimensions2 == 0) {
                throw new IllegalArgumentException("Supplied Array has no dimensions.");
            }
            int elementCount = cumElements[0] * elements[0];
            switch (varType) {
                case 16: 
                case 17: {
                    Object[] sourceArray = dataPointer.getByteArray(0L, elementCount);
                    break;
                }
                case 2: 
                case 11: 
                case 18: {
                    Object[] sourceArray;
                    sourceArray = sourceArray.getShortArray(0L, elementCount);
                    break;
                }
                case 3: 
                case 10: 
                case 19: 
                case 22: 
                case 23: {
                    Object[] sourceArray;
                    sourceArray = sourceArray.getIntArray(0L, elementCount);
                    break;
                }
                case 4: {
                    Object[] sourceArray;
                    sourceArray = sourceArray.getFloatArray(0L, elementCount);
                    break;
                }
                case 5: 
                case 7: {
                    Object[] sourceArray;
                    sourceArray = sourceArray.getDoubleArray(0L, elementCount);
                    break;
                }
                case 8: {
                    Object[] sourceArray;
                    sourceArray = sourceArray.getPointerArray(0L, elementCount);
                    break;
                }
                case 12: {
                    Object[] sourceArray;
                    Variant.VARIANT dimensions2 = new Variant.VARIANT((Pointer)sourceArray);
                    sourceArray = dimensions2.toArray(elementCount);
                    break;
                }
                default: {
                    throw new IllegalStateException("Type not supported: " + varType);
                }
            }
            Object targetArray = Array.newInstance(Object.class, elements);
            OaIdlUtil.toPrimitiveArray(var2_2, targetArray, elements, cumElements, varType, new int[0]);
            var2_2 = var3_6;
            sa.unaccessData();
            if (destruct) {
                sa.destroy();
            }
            return var2_2;
        }
        catch (Throwable throwable) {
            void var1_1;
            sa.unaccessData();
            if (var1_1 != false) {
                OaIdl.SAFEARRAY sAFEARRAY;
                sAFEARRAY.destroy();
            }
            throw throwable;
        }
    }

    private static void toPrimitiveArray(Object dataArray, Object targetArray, int[] elements, int[] cumElements, int varType, int[] currentIdx) {
        int dimIdx = currentIdx.length;
        int[] subIdx = new int[currentIdx.length + 1];
        System.arraycopy(currentIdx, 0, subIdx, 0, dimIdx);
        block24: for (int i = 0; i < elements[dimIdx]; ++i) {
            subIdx[dimIdx] = i;
            if (dimIdx == elements.length - 1) {
                int offset = 0;
                for (int j = 0; j < dimIdx; ++j) {
                    offset += cumElements[j] * currentIdx[j];
                }
                offset += subIdx[dimIdx];
                int targetPos = subIdx[dimIdx];
                switch (varType) {
                    case 11: {
                        Array.set(targetArray, targetPos, Array.getShort(dataArray, offset) != 0);
                        continue block24;
                    }
                    case 16: 
                    case 17: {
                        Array.set(targetArray, targetPos, Array.getByte(dataArray, offset));
                        continue block24;
                    }
                    case 2: 
                    case 18: {
                        Array.set(targetArray, targetPos, Array.getShort(dataArray, offset));
                        continue block24;
                    }
                    case 3: 
                    case 19: 
                    case 22: 
                    case 23: {
                        Array.set(targetArray, targetPos, Array.getInt(dataArray, offset));
                        continue block24;
                    }
                    case 10: {
                        Array.set(targetArray, targetPos, new WinDef.SCODE(Array.getInt(dataArray, offset)));
                        continue block24;
                    }
                    case 4: {
                        Array.set(targetArray, targetPos, Float.valueOf(Array.getFloat(dataArray, offset)));
                        continue block24;
                    }
                    case 5: {
                        Array.set(targetArray, targetPos, Array.getDouble(dataArray, offset));
                        continue block24;
                    }
                    case 7: {
                        Array.set(targetArray, targetPos, new OaIdl.DATE(Array.getDouble(dataArray, offset)).getAsJavaDate());
                        continue block24;
                    }
                    case 8: {
                        Array.set(targetArray, targetPos, new WTypes.BSTR((Pointer)Array.get(dataArray, offset)).getValue());
                        continue block24;
                    }
                    case 12: {
                        Variant.VARIANT holder = (Variant.VARIANT)((Object)Array.get(dataArray, offset));
                        switch (holder.getVarType().intValue()) {
                            case 0: 
                            case 1: {
                                Array.set(targetArray, targetPos, null);
                                continue block24;
                            }
                            case 11: {
                                Array.set(targetArray, targetPos, holder.booleanValue());
                                continue block24;
                            }
                            case 16: 
                            case 17: {
                                Array.set(targetArray, targetPos, holder.byteValue());
                                continue block24;
                            }
                            case 2: 
                            case 18: {
                                Array.set(targetArray, targetPos, holder.shortValue());
                                continue block24;
                            }
                            case 3: 
                            case 19: 
                            case 22: 
                            case 23: {
                                Array.set(targetArray, targetPos, holder.intValue());
                                continue block24;
                            }
                            case 10: {
                                Array.set(targetArray, targetPos, new WinDef.SCODE(holder.intValue()));
                                continue block24;
                            }
                            case 4: {
                                Array.set(targetArray, targetPos, Float.valueOf(holder.floatValue()));
                                continue block24;
                            }
                            case 5: {
                                Array.set(targetArray, targetPos, holder.doubleValue());
                                continue block24;
                            }
                            case 7: {
                                Array.set(targetArray, targetPos, holder.dateValue());
                                continue block24;
                            }
                            case 8: {
                                Array.set(targetArray, targetPos, holder.stringValue());
                                continue block24;
                            }
                            default: {
                                throw new IllegalStateException("Type not supported: " + holder.getVarType().intValue());
                            }
                        }
                    }
                    default: {
                        throw new IllegalStateException("Type not supported: " + varType);
                    }
                }
            }
            OaIdlUtil.toPrimitiveArray(dataArray, Array.get(targetArray, i), elements, cumElements, varType, subIdx);
        }
    }
}

