/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.Union;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APITypeMapper;

public interface Ntifs
extends BaseTSD,
WinDef {
    public static final int MAXIMUM_REPARSE_DATA_BUFFER_SIZE = 16384;
    public static final int REPARSE_BUFFER_HEADER_SIZE = 8;
    public static final int SYMLINK_FLAG_RELATIVE = 1;

    @Structure.FieldOrder(value={"ReparseTag", "ReparseDataLength", "Reserved", "u"})
    public static class REPARSE_DATA_BUFFER
    extends Structure {
        public int ReparseTag = 0;
        public short ReparseDataLength = 0;
        public short Reserved = 0;
        public REPARSE_UNION u;

        public static int sizeOf() {
            return Native.getNativeSize(REPARSE_DATA_BUFFER.class, null);
        }

        public int getSize() {
            return 8 + this.ReparseDataLength;
        }

        public REPARSE_DATA_BUFFER() {
        }

        /*
         * WARNING - void declaration
         */
        public REPARSE_DATA_BUFFER(int ReparseTag, short Reserved) {
            void var2_2;
            void var1_1;
            this.ReparseTag = var1_1;
            this.Reserved = var2_2;
            this.ReparseDataLength = 0;
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        public REPARSE_DATA_BUFFER(int ReparseTag, short Reserved, SymbolicLinkReparseBuffer symLinkReparseBuffer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.ReparseTag = var1_1;
            this.Reserved = var2_2;
            this.ReparseDataLength = (short)symLinkReparseBuffer.size();
            this.u.setType(SymbolicLinkReparseBuffer.class);
            this.u.symLinkReparseBuffer = var3_3;
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        public REPARSE_DATA_BUFFER(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        public void read() {
            super.read();
            switch (this.ReparseTag) {
                default: {
                    this.u.setType(GenericReparseBuffer.class);
                    break;
                }
                case -1610612733: {
                    this.u.setType(MountPointReparseBuffer.class);
                    break;
                }
                case -1610612724: {
                    this.u.setType(SymbolicLinkReparseBuffer.class);
                }
            }
            this.u.read();
        }

        public static class REPARSE_UNION
        extends Union {
            public SymbolicLinkReparseBuffer symLinkReparseBuffer;
            public MountPointReparseBuffer mountPointReparseBuffer;
            public GenericReparseBuffer genericReparseBuffer;

            public REPARSE_UNION() {
            }

            /*
             * WARNING - void declaration
             */
            public REPARSE_UNION(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }

            public static class ByReference
            extends REPARSE_UNION
            implements Structure.ByReference {
            }
        }

        public static class ByReference
        extends REPARSE_DATA_BUFFER
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }

    @Structure.FieldOrder(value={"DataBuffer"})
    public static class GenericReparseBuffer
    extends Structure {
        public byte[] DataBuffer = new byte[16384];

        public static int sizeOf() {
            return Native.getNativeSize(GenericReparseBuffer.class, null);
        }

        public GenericReparseBuffer() {
        }

        /*
         * WARNING - void declaration
         */
        public GenericReparseBuffer(Pointer memory) {
            super((Pointer)var1_1);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public GenericReparseBuffer(String DataBuffer2) {
            void var1_1;
            this.DataBuffer = var1_1.getBytes();
            this.write();
        }

        public static class ByReference
        extends GenericReparseBuffer
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }

    @Structure.FieldOrder(value={"SubstituteNameOffset", "SubstituteNameLength", "PrintNameOffset", "PrintNameLength", "PathBuffer"})
    public static class MountPointReparseBuffer
    extends Structure {
        public short SubstituteNameOffset = 0;
        public short SubstituteNameLength = 0;
        public short PrintNameOffset = 0;
        public short PrintNameLength = 0;
        public char[] PathBuffer = new char[8192];

        public static int sizeOf() {
            return Native.getNativeSize(MountPointReparseBuffer.class, null);
        }

        public MountPointReparseBuffer() {
            super(W32APITypeMapper.UNICODE);
        }

        /*
         * WARNING - void declaration
         */
        public MountPointReparseBuffer(Pointer memory) {
            super((Pointer)var1_1, 0, W32APITypeMapper.UNICODE);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public MountPointReparseBuffer(String substituteName, String printName) {
            void var2_2;
            void var1_1;
            void var3_3;
            String bothNames = substituteName + printName;
            this.PathBuffer = var3_3.toCharArray();
            this.SubstituteNameOffset = 0;
            this.SubstituteNameLength = (short)substituteName.length();
            this.PrintNameOffset = (short)(var1_1.length() * 2);
            this.PrintNameLength = (short)(var2_2.length() * 2);
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        public MountPointReparseBuffer(short SubstituteNameOffset, short SubstituteNameLength, short PrintNameOffset, short PrintNameLength, String PathBuffer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.SubstituteNameOffset = var1_1;
            this.SubstituteNameLength = var2_2;
            this.PrintNameOffset = var3_3;
            this.PrintNameLength = PrintNameLength;
            this.PathBuffer = PathBuffer.toCharArray();
            this.write();
        }

        public static class ByReference
        extends MountPointReparseBuffer
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }

    @Structure.FieldOrder(value={"SubstituteNameOffset", "SubstituteNameLength", "PrintNameOffset", "PrintNameLength", "Flags", "PathBuffer"})
    public static class SymbolicLinkReparseBuffer
    extends Structure {
        public short SubstituteNameOffset = 0;
        public short SubstituteNameLength = 0;
        public short PrintNameOffset = 0;
        public short PrintNameLength = 0;
        public int Flags = 0;
        public char[] PathBuffer = new char[8192];

        public static int sizeOf() {
            return Native.getNativeSize(MountPointReparseBuffer.class, null);
        }

        public SymbolicLinkReparseBuffer() {
            super(W32APITypeMapper.UNICODE);
        }

        /*
         * WARNING - void declaration
         */
        public SymbolicLinkReparseBuffer(Pointer memory) {
            super((Pointer)var1_1, 0, W32APITypeMapper.UNICODE);
            void var1_1;
            this.read();
        }

        /*
         * WARNING - void declaration
         */
        public SymbolicLinkReparseBuffer(String substituteName, String printName, int Flags) {
            void var3_3;
            void var2_2;
            void var1_1;
            String bothNames = substituteName + printName;
            this.PathBuffer = bothNames.toCharArray();
            this.SubstituteNameOffset = 0;
            this.SubstituteNameLength = (short)(substituteName.length() * 2);
            this.PrintNameOffset = (short)(var1_1.length() * 2);
            this.PrintNameLength = (short)(var2_2.length() * 2);
            this.Flags = var3_3;
            this.write();
        }

        /*
         * WARNING - void declaration
         */
        public SymbolicLinkReparseBuffer(short SubstituteNameOffset, short SubstituteNameLength, short PrintNameOffset, short PrintNameLength, int Flags, String PathBuffer) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.SubstituteNameOffset = var1_1;
            this.SubstituteNameLength = var2_2;
            this.PrintNameOffset = var3_3;
            this.PrintNameLength = PrintNameLength;
            this.Flags = Flags;
            this.PathBuffer = PathBuffer.toCharArray();
            this.write();
        }

        public String getPrintName() {
            return String.copyValueOf(this.PathBuffer, this.PrintNameOffset / 2, this.PrintNameLength / 2);
        }

        public String getSubstituteName() {
            return String.copyValueOf(this.PathBuffer, this.SubstituteNameOffset / 2, this.SubstituteNameLength / 2);
        }

        public static class ByReference
        extends SymbolicLinkReparseBuffer
        implements Structure.ByReference {
            public ByReference() {
            }

            /*
             * WARNING - void declaration
             */
            public ByReference(Pointer memory) {
                super((Pointer)var1_1);
                void var1_1;
            }
        }
    }
}

