/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.tlb.imp;

import com.sun.jna.platform.win32.COM.TypeInfoUtil;
import com.sun.jna.platform.win32.COM.TypeLibUtil;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbAbstractMethod;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbBase;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbFunctionStub;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyGetStub;
import com.sun.jna.platform.win32.COM.tlb.imp.TlbPropertyPutStub;
import com.sun.jna.platform.win32.OaIdl;

public class TlbDispInterface
extends TlbBase {
    public TlbDispInterface(int index, String packagename, TypeLibUtil typeLibUtil) {
        super(index, typeLibUtil, null);
        TypeLibUtil.TypeLibDoc typeLibDoc = this.typeLibUtil.getDocumentation(index);
        String docString = typeLibDoc.getDocString();
        if (typeLibDoc.getName().length() > 0) {
            this.name = typeLibDoc.getName();
        }
        this.logInfo("Type of kind 'DispInterface' found: " + this.name);
        this.createPackageName(packagename);
        TlbDispInterface tlbDispInterface = this;
        tlbDispInterface.createClassName(tlbDispInterface.name);
        TlbDispInterface tlbDispInterface2 = this;
        tlbDispInterface2.setFilename(tlbDispInterface2.name);
        TypeInfoUtil typeInfoUtil = typeLibUtil.getTypeInfoUtil(index);
        OaIdl.TYPEATTR typeAttr = typeInfoUtil.getTypeAttr();
        this.createJavaDocHeader(typeAttr.guid.toGuidString(), docString);
        int cFuncs = typeAttr.cFuncs.intValue();
        for (int i = 0; i < cFuncs; ++i) {
            OaIdl.FUNCDESC funcDesc = typeInfoUtil.getFuncDesc(i);
            Object memberID = funcDesc.memid;
            memberID = typeInfoUtil.getDocumentation((OaIdl.MEMBERID)memberID);
            String methodName = ((TypeInfoUtil.TypeInfoDoc)memberID).getName();
            TlbAbstractMethod method = null;
            if (!this.isReservedMethod(methodName)) {
                if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_FUNC.value) {
                    method = new TlbFunctionStub(index, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYGET.value) {
                    method = new TlbPropertyGetStub(index, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUT.value) {
                    method = new TlbPropertyPutStub(index, typeLibUtil, funcDesc, typeInfoUtil);
                } else if (funcDesc.invkind.value == OaIdl.INVOKEKIND.INVOKE_PROPERTYPUTREF.value) {
                    method = new TlbPropertyPutStub(index, typeLibUtil, funcDesc, typeInfoUtil);
                }
                this.content = this.content + method.getClassBuffer();
                if (i < cFuncs - 1) {
                    this.content = this.content + "\n";
                }
            }
            typeInfoUtil.ReleaseFuncDesc(funcDesc);
        }
        TlbDispInterface tlbDispInterface3 = this;
        tlbDispInterface3.createContent(tlbDispInterface3.content);
    }

    /*
     * WARNING - void declaration
     */
    protected void createJavaDocHeader(String guid, String helpstring) {
        void var2_2;
        void var1_1;
        this.replaceVariable("uuid", (String)var1_1);
        this.replaceVariable("helpstring", (String)var2_2);
    }

    @Override
    protected String getClassTemplate() {
        return "com/sun/jna/platform/win32/COM/tlb/imp/TlbDispInterface.template";
    }
}

