/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.mac;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.mac.XAttr;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class XAttrUtil {
    /*
     * WARNING - void declaration
     */
    public static List<String> listXAttr(String path) {
        void var3_2;
        void var1_1;
        String string;
        long bufferLength = XAttr.INSTANCE.listxattr(path, null, 0L, 0);
        if (bufferLength < 0L) {
            return null;
        }
        if (bufferLength == 0L) {
            return new ArrayList<String>(0);
        }
        Memory valueBuffer = new Memory(bufferLength);
        long valueLength = XAttr.INSTANCE.listxattr(string, (Pointer)valueBuffer, (long)var1_1, 0);
        if (valueLength < 0L) {
            return null;
        }
        return XAttrUtil.decodeStringSequence(var3_2.getByteBuffer(0L, valueLength));
    }

    /*
     * WARNING - void declaration
     */
    public static String getXAttr(String path, String name) {
        void var2_2;
        void var1_1;
        String string;
        long bufferLength = XAttr.INSTANCE.getxattr(path, name, null, 0L, 0, 0);
        if (bufferLength < 0L) {
            return null;
        }
        if (bufferLength == 0L) {
            return "";
        }
        Memory valueBuffer = new Memory(bufferLength);
        valueBuffer.clear();
        long l = XAttr.INSTANCE.getxattr(string, (String)var1_1, (Pointer)valueBuffer, bufferLength, 0, 0);
        if (l < 0L) {
            return null;
        }
        return Native.toString((byte[])valueBuffer.getByteArray(0L, (int)var2_2), (String)"UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public static int setXAttr(String path, String name, String value) {
        void var1_1;
        String string;
        void var2_2;
        Memory valueBuffer = XAttrUtil.encodeString(value);
        void v0 = var2_2;
        return XAttr.INSTANCE.setxattr(string, (String)var1_1, (Pointer)v0, v0.size(), 0, 0);
    }

    /*
     * WARNING - void declaration
     */
    public static int removeXAttr(String path, String name) {
        void var1_1;
        String string;
        return XAttr.INSTANCE.removexattr(string, (String)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    protected static Memory encodeString(String s) {
        void var1_1;
        Object object;
        Object bb = s.getBytes(Charset.forName("UTF-8"));
        Memory valueBuffer = new Memory((long)((Object)bb).length);
        valueBuffer.write(0L, (byte[])bb, 0, ((Object)object).length);
        return var1_1;
    }

    protected static String decodeString(ByteBuffer bb) {
        ByteBuffer byteBuffer;
        return Charset.forName("UTF-8").decode(byteBuffer).toString();
    }

    /*
     * WARNING - void declaration
     */
    protected static List<String> decodeStringSequence(ByteBuffer bb) {
        void var1_1;
        ArrayList<String> names = new ArrayList<String>();
        bb.mark();
        while (bb.hasRemaining()) {
            if (bb.get() != 0) continue;
            ByteBuffer nameBuffer = (ByteBuffer)bb.duplicate().limit(bb.position() - 1).reset();
            if (nameBuffer.hasRemaining()) {
                void var2_2;
                names.add(XAttrUtil.decodeString((ByteBuffer)var2_2));
            }
            bb.mark();
        }
        return var1_1;
    }
}

