/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Random;
import org.fusesource.jansi.internal.OSInfo;

public class JansiLoader {
    private static boolean loaded = false;
    private static String nativeLibraryPath;
    private static String nativeLibrarySourceUrl;

    /*
     * WARNING - void declaration
     */
    public static synchronized boolean initialize() {
        block13: {
            Object cleanup;
            if (!loaded) {
                cleanup = new Thread(JansiLoader::cleanup, "cleanup");
                ((Thread)cleanup).setPriority(1);
                ((Thread)cleanup).setDaemon(true);
                ((Thread)cleanup).start();
            }
            try {
                String string3;
                if (loaded) break block13;
                cleanup = new LinkedList();
                String object = System.getProperty("library.jansi.path");
                String string = System.getProperty("library.jansi.name");
                if (string == null) {
                    string = System.mapLibraryName("jansi");
                    assert (string != null);
                    if (string.endsWith(".dylib")) {
                        string = string.replace(".dylib", ".jnilib");
                    }
                }
                if (object != null) {
                    string3 = object + "/" + OSInfo.getNativeLibFolderPathForCurrentOS();
                    if (JansiLoader.loadNativeLibrary(new File(string3, string))) {
                        loaded = true;
                        break block13;
                    }
                    cleanup.add(string3);
                    if (JansiLoader.loadNativeLibrary(new File(object, string))) {
                        loaded = true;
                        break block13;
                    }
                    cleanup.add(object);
                }
                string3 = JansiLoader.class.getPackage().getName().replace('.', '/');
                String string2 = String.format("/%s/native/%s", string3, OSInfo.getNativeLibFolderPathForCurrentOS());
                boolean string4 = JansiLoader.class.getResource(string3 = string2 + "/" + string) != null;
                if (string4) {
                    String string5 = JansiLoader.getTempDir().getAbsolutePath();
                    if (JansiLoader.extractAndLoadLibraryFile(string2, string, string5)) {
                        loaded = true;
                        break block13;
                    }
                    cleanup.add(string2);
                }
                String string6 = System.getProperty("java.library.path", "");
                for (String string7 : string6.split(File.pathSeparator)) {
                    if (string7.isEmpty()) continue;
                    if (JansiLoader.loadNativeLibrary(new File(string7, string))) {
                        loaded = true;
                        break block13;
                    }
                    cleanup.add(string7);
                }
                throw new Exception(String.format("No native library found for os.name=%s, os.arch=%s, paths=[%s]", OSInfo.getOSName(), OSInfo.getArchName(), String.join((CharSequence)File.pathSeparator, (Iterable<? extends CharSequence>)cleanup)));
            }
            catch (Exception e) {
                void var0_1;
                if (Boolean.parseBoolean(System.getProperty("jansi.graceful", "true"))) break block13;
                throw new RuntimeException("Unable to load jansi native library. You may want set the `jansi.graceful` system property to true to be able to use Jansi on your platform", (Throwable)var0_1);
            }
        }
        return loaded;
    }

    private static File getTempDir() {
        return new File(System.getProperty("jansi.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    /*
     * WARNING - void declaration
     */
    static void cleanup() {
        Object tempFolder = JansiLoader.getTempDir().getAbsolutePath();
        File[] nativeLibFiles = ((File)(tempFolder = new File((String)tempFolder))).listFiles(new FilenameFilter(){
            private final String searchPattern = "jansi-" + JansiLoader.getVersion();

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean accept(File dir, String name) {
                void var2_2;
                return name.startsWith(this.searchPattern) && !var2_2.endsWith(".lck");
            }
        });
        if (nativeLibFiles != null) {
            void var0;
            for (void nativeLibFile : var0) {
                File file = new File(nativeLibFile.getAbsolutePath() + ".lck");
                if (file.exists()) continue;
                try {
                    nativeLibFile.delete();
                }
                catch (SecurityException e) {
                    void var3_4;
                    System.err.println("Failed to delete old native lib" + var3_4.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int readNBytes(InputStream in, byte[] b) throws IOException {
        void var2_2;
        int count;
        void var3_3;
        int cfr_ignored_0 = b.length;
        for (int n = 0; n < 8192 && (count = in.read(b, n, 8192 - n)) > 0; n += var3_3) {
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        String nativeLibraryFilePath2 = libFolderForCurrentOS + "/" + libraryFileName;
        String uuid = Long.toHexString(new Random().nextLong());
        String extractedLibFileName = String.format("jansi-%s-%s-%s", JansiLoader.getVersion(), uuid, libraryFileName);
        String extractedLckFileName = extractedLibFileName + ".lck";
        File extractedLibFile = new File(targetFolder, extractedLibFileName);
        File extractedLckFile = new File(targetFolder, extractedLckFileName);
        try {
            void var1_3;
            InputStream inputStream;
            try {
                try (InputStream in = JansiLoader.class.getResourceAsStream(nativeLibraryFilePath2);){
                    if (!extractedLckFile.exists()) {
                        new FileOutputStream(extractedLckFile).close();
                    }
                    Files.copy(in, extractedLibFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                extractedLibFile.deleteOnExit();
                extractedLckFile.deleteOnExit();
            }
            catch (Throwable nativeLibraryFilePath2) {
                extractedLibFile.deleteOnExit();
                ((File)((Object)inputStream)).deleteOnExit();
                throw nativeLibraryFilePath2;
            }
            extractedLibFile.setReadable(true);
            extractedLibFile.setWritable(true);
            extractedLibFile.setExecutable(true);
            try (InputStream nativeIn = JansiLoader.class.getResourceAsStream(nativeLibraryFilePath2);
                 FileInputStream extractedLibIn = new FileInputStream(extractedLibFile);){
                String eq;
                String string;
                block29: {
                    int n;
                    block28: {
                        FileInputStream fileInputStream = extractedLibIn;
                        inputStream = nativeIn;
                        byte[] byArray = new byte[8192];
                        byte[] byArray2 = new byte[8192];
                        do {
                            int n2 = JansiLoader.readNBytes(inputStream, byArray);
                            n = JansiLoader.readNBytes(fileInputStream, byArray2);
                            if (n2 <= 0) break block28;
                            if (n <= 0) {
                                string = "EOF on second stream but not first";
                            } else {
                                if (n == n2) continue;
                                string = "Read size different (" + n2 + " vs " + n + ")";
                            }
                            break block29;
                        } while (Arrays.equals(byArray, byArray2));
                        string = "Content differs";
                        break block29;
                    }
                    string = eq = n > 0 ? "EOF on first stream but not second" : null;
                }
                if (string != null) {
                    throw new RuntimeException(String.format("Failed to write a native library file at %s because %s", extractedLibFile, eq));
                }
            }
            if (JansiLoader.loadNativeLibrary((File)var1_3)) {
                String string;
                nativeLibrarySourceUrl = JansiLoader.class.getResource(string).toExternalForm();
                return true;
            }
        }
        catch (IOException e) {
            void var3_6;
            System.err.println(var3_6.getMessage());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean loadNativeLibrary(File libPath) {
        if (libPath.exists()) {
            try {
                String path = libPath.getAbsolutePath();
                System.load(path);
                nativeLibraryPath = path;
                return true;
            }
            catch (UnsatisfiedLinkError e) {
                void var1_2;
                if (!libPath.canExecute()) {
                    System.err.printf("Failed to load native library:%s. The native library file at %s is not executable, make sure that the directory is mounted on a partition without the noexec flag, or set the jansi.tmpdir system property to point to a proper location.  osinfo: %s%n", libPath.getName(), libPath, OSInfo.getNativeLibFolderPathForCurrentOS());
                } else {
                    File file;
                    System.err.printf("Failed to load native library:%s. osinfo: %s%n", file.getName(), OSInfo.getNativeLibFolderPathForCurrentOS());
                }
                System.err.println(var1_2);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String getVersion() {
        void var1_1;
        URL versionFile = JansiLoader.class.getResource("/org/fusesource/jansi/jansi.properties");
        String version = "unknown";
        try {
            if (versionFile != null) {
                void var0;
                Properties versionData = new Properties();
                versionData.load(var0.openStream());
                version = versionData.getProperty("version", version);
                version = version.trim().replaceAll("[^0-9.]", "");
            }
        }
        catch (IOException e) {
            void var2_3;
            System.err.println(var2_3);
        }
        return var1_1;
    }
}

