/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import java.io.IOException;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.data.FileAttributesFlags;
import mslinks.data.Filetime;
import mslinks.data.GUID;
import mslinks.data.HotKeyFlags;
import mslinks.data.LinkFlags;

public final class ShellLinkHeader
implements Serializable {
    private static int headerSize = 76;
    private static GUID clsid = new GUID("00021401-0000-0000-C000-000000000046");
    private LinkFlags lf;
    private FileAttributesFlags faf;
    private Filetime creationTime;
    private Filetime accessTime;
    private Filetime writeTime;
    private int fileSize;
    private int iconIndex;
    private int showCommand;
    private HotKeyFlags hkf;

    public ShellLinkHeader() {
        this.lf = new LinkFlags(0);
        this.faf = new FileAttributesFlags(0);
        this.creationTime = new Filetime();
        this.accessTime = new Filetime();
        this.writeTime = new Filetime();
        this.showCommand = 1;
        this.hkf = new HotKeyFlags();
    }

    /*
     * WARNING - void declaration
     */
    public ShellLinkHeader(ByteReader data) throws ShellLinkException, IOException {
        void var1_1;
        int n = (int)data.read4bytes();
        if (n != headerSize) {
            throw new ShellLinkException();
        }
        GUID gUID = new GUID(data);
        if (!gUID.equals(clsid)) {
            throw new ShellLinkException();
        }
        this.lf = new LinkFlags(data);
        this.faf = new FileAttributesFlags(data);
        this.creationTime = new Filetime(data);
        this.accessTime = new Filetime(data);
        this.writeTime = new Filetime(data);
        this.fileSize = (int)data.read4bytes();
        this.iconIndex = (int)data.read4bytes();
        this.showCommand = (int)data.read4bytes();
        if (this.showCommand != 1 && this.showCommand != 3 && this.showCommand != 7) {
            throw new ShellLinkException();
        }
        this.hkf = new HotKeyFlags(data);
        data.read2bytes();
        var1_1.read8bytes();
    }

    public final LinkFlags getLinkFlags() {
        return this.lf;
    }
}

