/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.Map;
import mslinks.LinkInfo;
import mslinks.LinkTargetIDList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.ShellLinkHeader;
import mslinks.data.CNRLink;
import mslinks.data.ItemID;
import mslinks.data.LinkFlags;
import mslinks.extra.ConsoleData;
import mslinks.extra.ConsoleFEData;
import mslinks.extra.EnvironmentVariable;
import mslinks.extra.Stub;
import mslinks.extra.Tracker;
import mslinks.extra.VistaIDList;

public final class ShellLink {
    private static Map<String, String> env = System.getenv();
    private static HashMap<Integer, Class<? extends Serializable>> extraTypes = new HashMap<Integer, Class<EnvironmentVariable>>(Map.of(-1610612734, ConsoleData.class, -1610612732, ConsoleFEData.class, -1610612733, Tracker.class, -1610612724, VistaIDList.class, -1610612735, EnvironmentVariable.class));
    private ShellLinkHeader header;
    private LinkTargetIDList idlist;
    private LinkInfo info;
    private String name;
    private String relativePath;
    private String workingDir;
    private String cmdArgs;
    private String iconLocation;
    private HashMap<Integer, Serializable> extra = new HashMap();
    private Path linkFileSource;

    public ShellLink() {
        this.header = new ShellLinkHeader();
        this.header.getLinkFlags().setIsUnicode();
    }

    /*
     * WARNING - void declaration
     */
    public ShellLink(File file) throws IOException, ShellLinkException {
        this(var1_1.toPath());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ShellLink(Path file) throws IOException, ShellLinkException {
        this(Files.newInputStream(file, new OpenOption[0]));
        void var1_1;
        this.linkFileSource = var1_1.toAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    private ShellLink(InputStream in) throws IOException, ShellLinkException {
        ByteReader reader = new ByteReader(in);
        try {
            int n;
            ByteReader byteReader = reader;
            ShellLink shellLink = this;
            this.header = new ShellLinkHeader(byteReader);
            LinkFlags linkFlags = shellLink.header.getLinkFlags();
            if (linkFlags.hasLinkTargetIDList()) {
                shellLink.idlist = new LinkTargetIDList(byteReader);
            }
            if (linkFlags.hasLinkInfo()) {
                shellLink.info = new LinkInfo(byteReader);
            }
            if (linkFlags.hasName()) {
                shellLink.name = byteReader.readUnicodeString();
            }
            if (linkFlags.hasRelativePath()) {
                shellLink.relativePath = byteReader.readUnicodeString();
            }
            if (linkFlags.hasWorkingDir()) {
                shellLink.workingDir = byteReader.readUnicodeString();
            }
            if (linkFlags.hasArguments()) {
                shellLink.cmdArgs = byteReader.readUnicodeString();
            }
            if (linkFlags.hasIconLocation()) {
                shellLink.iconLocation = byteReader.readUnicodeString();
            }
            while ((n = (int)byteReader.read4bytes()) >= 4) {
                java.io.Serializable serializable;
                int n2 = (int)byteReader.read4bytes();
                try {
                    serializable = extraTypes.get(n2);
                    if (serializable != null) {
                        shellLink.extra.put(n2, (Serializable)((Class)serializable).getConstructor(ByteReader.class, Integer.TYPE).newInstance(byteReader, n));
                        continue;
                    }
                    shellLink.extra.put(n2, new Stub(byteReader, n, n2));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    serializable = exception;
                    exception.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            try {
                void var1_1;
                var1_1.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        reader.close();
    }

    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public final String resolveTarget() {
        ItemID itemID;
        Object object;
        if (this.header.getLinkFlags().hasLinkTargetIDList() && this.idlist != null) {
            boolean bl;
            block9: {
                object = this.idlist;
                object = ((AbstractSequentialList)object).iterator();
                while (object.hasNext()) {
                    itemID = (ItemID)object.next();
                    if (itemID.getType() != 0) continue;
                    bl = false;
                    break block9;
                }
                bl = true;
            }
            if (bl) {
                return this.idlist.buildPath();
            }
        }
        if (this.header.getLinkFlags().hasLinkInfo() && this.info != null) {
            CNRLink l = this.info.getCommonNetworkRelativeLink();
            String cps = this.info.getCommonPathSuffix();
            String lbp = this.info.getLocalBasePath();
            if (lbp != null) {
                void var3_3;
                String path = var3_3;
                if (cps != null && !cps.equals("")) {
                    void v1 = path;
                    if (v1.charAt(v1.length() - 1) != File.separatorChar) {
                        path = (String)path + File.separatorChar;
                    }
                    path = path + cps;
                }
                return object;
            }
            if (object != null && cps != null) {
                return ((CNRLink)object).getNetName() + File.separator + (String)((Object)itemID);
            }
        }
        if (this.linkFileSource != null && this.header.getLinkFlags().hasRelativePath() && this.relativePath != null) {
            return this.linkFileSource.resolveSibling(this.relativePath).normalize().toString();
        }
        return "<unknown>";
    }
}

