/*
 * Decompiled with CFR 0.152.
 */
package mslinks;

import io.ByteReader;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import mslinks.Serializable;
import mslinks.ShellLinkException;
import mslinks.UnsupportedCLSIDException;
import mslinks.data.ItemID;

public final class LinkTargetIDList
extends LinkedList<ItemID>
implements Serializable {
    public LinkTargetIDList() {
    }

    /*
     * WARNING - void declaration
     */
    public LinkTargetIDList(ByteReader data) throws IOException, ShellLinkException {
        void var2_2;
        int n;
        void var1_1;
        int size = (int)data.read2bytes();
        int pos = data.getPosition();
        boolean binary = false;
        int s = (int)data.read2bytes();
        while (s != 0) {
            s -= 2;
            if (binary) {
                byte[] b = new byte[s];
                for (int i = 0; i < s; ++i) {
                    b[i] = (byte)data.read();
                }
                this.add(new ItemID(b));
            } else {
                try {
                    this.add(new ItemID(data, s));
                }
                catch (UnsupportedCLSIDException unsupportedCLSIDException) {
                    System.err.println("unsupported CLSID");
                    binary = true;
                }
            }
            s = (int)data.read2bytes();
        }
        n = var1_1.getPosition() - n;
        if (n != var2_2) {
            throw new ShellLinkException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String buildPath() {
        void var1_1;
        StringBuilder path = new StringBuilder();
        for (ItemID i : this) {
            void var3_3;
            if (i.getType() == 47 || i.getType() == 35) {
                path.append(i.getName());
                continue;
            }
            if (i.getType() == 49 || i.getType() == 53) {
                path.append(i.getName() + File.separator);
                continue;
            }
            if (i.getType() != 50 && i.getType() != 54) continue;
            path.append(var3_3.getName());
        }
        return var1_1.toString();
    }
}

