/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkFilterInputStream;
import com.dd.plist.LocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.XMLLocationInformation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLPropertyListParser {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSObject parse(InputStream is) throws ParserConfigurationException, IOException, SAXException, PropertyListFormatException {
        ByteOrderMarkFilterInputStream byteOrderMarkFilterInputStream;
        ByteOrderMarkFilterInputStream filteredInputStream = new ByteOrderMarkFilterInputStream(is, false);
        boolean bl = false;
        byteOrderMarkFilterInputStream = new InputSource(byteOrderMarkFilterInputStream);
        Object object = FACTORY.newDocumentBuilder();
        ((DocumentBuilder)object).setEntityResolver(new PlistDtdResolver());
        byteOrderMarkFilterInputStream = ((DocumentBuilder)object).parse((InputSource)((Object)byteOrderMarkFilterInputStream));
        object = byteOrderMarkFilterInputStream.getDoctype();
        if (object == null ? !byteOrderMarkFilterInputStream.getDocumentElement().getNodeName().equals("plist") : !object.getName().equals("plist")) {
            throw new PropertyListFormatException("The given XML document is not a property list.");
        }
        if (byteOrderMarkFilterInputStream.getDocumentElement().getNodeName().equals("plist")) {
            object = "/plist";
            if ((byteOrderMarkFilterInputStream = XMLPropertyListParser.filterElementNodes(byteOrderMarkFilterInputStream.getDocumentElement().getChildNodes())).isEmpty()) {
                throw new PropertyListFormatException("The given XML property list has no root element!");
            }
            if (byteOrderMarkFilterInputStream.size() != 1) throw new PropertyListFormatException("The given XML property list has more than one root element!");
            byteOrderMarkFilterInputStream = byteOrderMarkFilterInputStream.get(0);
            return XMLPropertyListParser.parseObject(byteOrderMarkFilterInputStream, (String)object + "/" + byteOrderMarkFilterInputStream.getNodeName());
        } else {
            byteOrderMarkFilterInputStream = byteOrderMarkFilterInputStream.getDocumentElement();
            object = "";
        }
        return XMLPropertyListParser.parseObject(byteOrderMarkFilterInputStream, (String)object + "/" + byteOrderMarkFilterInputStream.getNodeName());
    }

    /*
     * WARNING - void declaration
     */
    private static NSObject parseObject(Node n, String xpath) throws PropertyListFormatException {
        Object children;
        String type = n.getNodeName();
        XMLLocationInformation loc = new XMLLocationInformation(n, xpath);
        NSObject parsedObject = null;
        try {
            int n2 = -1;
            switch (type.hashCode()) {
                case 3083190: {
                    if (!type.equals("dict")) break;
                    n2 = 0;
                    break;
                }
                case 93090393: {
                    if (!type.equals("array")) break;
                    n2 = 1;
                    break;
                }
                case 3569038: {
                    if (!type.equals("true")) break;
                    n2 = 2;
                    break;
                }
                case 97196323: {
                    if (!type.equals("false")) break;
                    n2 = 3;
                    break;
                }
                case 1958052158: {
                    if (!type.equals("integer")) break;
                    n2 = 4;
                    break;
                }
                case 3496350: {
                    if (!type.equals("real")) break;
                    n2 = 5;
                    break;
                }
                case -891985903: {
                    if (!type.equals("string")) break;
                    n2 = 6;
                    break;
                }
                case 3076010: {
                    if (!type.equals("data")) break;
                    n2 = 7;
                    break;
                }
                case 3076014: {
                    if (!type.equals("date")) break;
                    n2 = 8;
                }
            }
            switch (n2) {
                case 0: {
                    NSDictionary dict = new NSDictionary();
                    parsedObject = dict;
                    List<Node> children2 = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                    for (int i = 0; i < children2.size(); i += 2) {
                        Node node = children2.get(i);
                        String keyString = XMLPropertyListParser.getNodeTextContents(node);
                        Node value = children2.get(i + 1);
                        String childPath = xpath + "/*[" + (1 + i + 1) + "]";
                        dict.put(keyString, XMLPropertyListParser.parseObject(value, childPath));
                    }
                    break;
                }
                case 1: {
                    children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
                    NSArray array = new NSArray(children.size());
                    parsedObject = array;
                    for (int i = 0; i < children.size(); ++i) {
                        String childPath = xpath + "/*[" + (i + 1) + "]";
                        array.setValue$1ef468a(i, XMLPropertyListParser.parseObject((Node)children.get(i), childPath));
                    }
                    break;
                }
                case 2: {
                    parsedObject = new NSNumber(true);
                    break;
                }
                case 3: {
                    parsedObject = new NSNumber(false);
                    break;
                }
                case 4: 
                case 5: {
                    parsedObject = new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case 6: {
                    parsedObject = new NSString(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case 7: {
                    parsedObject = new NSData(XMLPropertyListParser.getNodeTextContents(n));
                    break;
                }
                case 8: {
                    parsedObject = new NSDate(XMLPropertyListParser.getNodeTextContents(n));
                }
            }
        }
        catch (PropertyListFormatException propertyListFormatException) {
            children = propertyListFormatException;
            throw propertyListFormatException;
        }
        catch (Exception ex) {
            void var2_3;
            void var1_1;
            Node node;
            throw new PropertyListFormatException(loc.hasLineInformation() ? "The " + n.getNodeName() + " node at line " + loc.getLineNumber() + " and column " + loc.getColumnNumber() + " could not be parsed." : "The " + node.getNodeName() + " node at " + (String)var1_1 + " could not be parsed.", loc, (Throwable)var2_3);
        }
        if (parsedObject != null) {
            void var3_4;
            parsedObject.setLocationInformation((LocationInformation)var3_4);
        }
        return parsedObject;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Node> filterElementNodes(NodeList list) {
        void var1_1;
        ArrayList<Node> result = new ArrayList<Node>(list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result.add(list.item(i));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String getNodeTextContents(Node n) {
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            String content = (n = (Text)n).getWholeText();
            if (content == null) {
                return "";
            }
            return content;
        }
        if (n.hasChildNodes()) {
            String children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String string;
                void var2_3;
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                children = (Text)var2_3;
                String content = children.getWholeText();
                if (content == null) {
                    return "";
                }
                return string;
            }
        }
        return "";
    }

    static {
        try {
            FACTORY.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        try {
            FACTORY.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        try {
            FACTORY.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        FACTORY.setExpandEntityReferences(false);
        FACTORY.setNamespaceAware(false);
        FACTORY.setIgnoringComments(true);
        FACTORY.setCoalescing(true);
        FACTORY.setValidating(false);
    }

    private static final class PlistDtdResolver
    implements EntityResolver {
        PlistDtdResolver() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final InputSource resolveEntity(String publicId, String systemId) {
            void var1_1;
            if ("-//Apple Computer//DTD PLIST 1.0//EN".equals(publicId) || "-//Apple//DTD PLIST 1.0//EN".equals(var1_1)) {
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }
    }
}

