/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.BinaryPropertyListParser;
import com.dd.plist.NSObject;

public final class NSNumber
extends NSObject {
    private int type;
    private long longValue;
    private double doubleValue;
    private boolean boolValue;

    /*
     * WARNING - void declaration
     */
    public NSNumber(byte[] bytes, int startIndex, int endIndex, int type) {
        switch (type) {
            case 0: {
                this.longValue = BinaryPropertyListParser.parseLong(bytes, startIndex, endIndex);
                this.doubleValue = this.longValue;
                break;
            }
            case 1: {
                void var3_3;
                void var2_2;
                void var1_1;
                this.doubleValue = BinaryPropertyListParser.parseDouble((byte[])var1_1, (int)var2_2, (int)var3_3);
                this.longValue = Math.round(this.doubleValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type argument is not valid.");
            }
        }
        this.type = type;
    }

    /*
     * WARNING - void declaration
     */
    public NSNumber(String text) {
        if (text == null) {
            throw new IllegalArgumentException("The given string is null and cannot be parsed as number.");
        }
        if (text.equalsIgnoreCase("true") || text.equalsIgnoreCase("YES")) {
            this.type = 2;
            this.boolValue = true;
            NSNumber nSNumber = this;
            nSNumber.longValue = 1L;
            nSNumber.doubleValue = 1.0;
            return;
        }
        if (text.equalsIgnoreCase("false") || text.equalsIgnoreCase("NO")) {
            this.type = 2;
            this.boolValue = false;
            NSNumber nSNumber = this;
            nSNumber.longValue = 0L;
            nSNumber.doubleValue = 0.0;
            return;
        }
        if (text.equalsIgnoreCase("nan")) {
            this.doubleValue = Double.NaN;
            this.longValue = 0L;
            this.type = 1;
            return;
        }
        if (text.equalsIgnoreCase("+infinity")) {
            this.doubleValue = Double.POSITIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
            return;
        }
        if (text.equalsIgnoreCase("-infinity")) {
            this.doubleValue = Double.NEGATIVE_INFINITY;
            this.longValue = 0L;
            this.type = 1;
            return;
        }
        try {
            void var2_2;
            long l = text.startsWith("0x") ? Long.parseLong(text.substring(2), 16) : Long.parseLong(text);
            this.longValue = var2_2;
            this.doubleValue = this.longValue;
            this.type = 0;
            return;
        }
        catch (Exception exception) {
            try {
                void var1_1;
                this.doubleValue = Double.parseDouble((String)var1_1);
                this.longValue = Math.round(this.doubleValue);
                this.type = 1;
                return;
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("The given string neither represents a double, an int nor a boolean value.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public NSNumber(int i) {
        void var1_1;
        this.longValue = (long)var1_1;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    /*
     * WARNING - void declaration
     */
    public NSNumber(long l) {
        void var1_1;
        this.longValue = var1_1;
        this.doubleValue = this.longValue;
        this.type = 0;
    }

    /*
     * WARNING - void declaration
     */
    public NSNumber(double d) {
        void var1_1;
        this.doubleValue = var1_1;
        this.longValue = (long)this.doubleValue;
        this.type = 1;
    }

    /*
     * WARNING - void declaration
     */
    public NSNumber(boolean b) {
        void var1_1;
        this.boolValue = b;
        this.longValue = var1_1 != false ? 1L : 0L;
        this.doubleValue = this.longValue;
        this.type = 2;
    }

    public final boolean isBoolean() {
        return this.type == 2;
    }

    public final boolean isInteger() {
        return this.type == 0;
    }

    public final boolean isReal() {
        return this.type == 1;
    }

    public final boolean boolValue() {
        if (this.type == 2) {
            return this.boolValue;
        }
        return !Double.isNaN(this.doubleValue) && this.doubleValue != 0.0;
    }

    public final long longValue() {
        this.throwIfIntegerValueNotAvailable();
        return this.longValue;
    }

    public final int intValue() {
        this.throwIfIntegerValueNotAvailable();
        return (int)this.longValue;
    }

    public final double doubleValue() {
        return this.doubleValue;
    }

    public final float floatValue() {
        return (float)this.doubleValue;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        void var1_1;
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSNumber n = (NSNumber)obj;
        return this.type == n.type && this.longValue == n.longValue && this.doubleValue == n.doubleValue && this.boolValue == var1_1.boolValue;
    }

    public final int hashCode() {
        int n;
        int hash = this.type;
        hash = 37 * hash + (int)(this.longValue ^ this.longValue >>> 32);
        hash = 37 * hash + (int)(Double.doubleToLongBits(this.doubleValue) ^ Double.doubleToLongBits(this.doubleValue) >>> 32);
        n = 37 * n + (this.boolValue() ? 1 : 0);
        return n;
    }

    @Override
    private NSNumber clone() {
        switch (this.type) {
            case 0: {
                return new NSNumber(this.longValue);
            }
            case 1: {
                return new NSNumber(this.doubleValue);
            }
            case 2: {
                return new NSNumber(this.boolValue);
            }
        }
        throw new IllegalStateException("The NSNumber instance has an invalid type: " + this.type);
    }

    public final String toString() {
        NSNumber nSNumber = this;
        switch (nSNumber.type) {
            case 0: {
                return String.valueOf(this.longValue);
            }
            case 1: {
                nSNumber = this;
                if (Double.isNaN(nSNumber.doubleValue)) {
                    return "nan";
                }
                if (nSNumber.doubleValue == Double.POSITIVE_INFINITY) {
                    return "+infinity";
                }
                if (nSNumber.doubleValue == Double.NEGATIVE_INFINITY) {
                    return "-infinity";
                }
                return String.valueOf(nSNumber.doubleValue);
            }
            case 2: {
                return String.valueOf(this.boolValue);
            }
        }
        return super.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object toJavaObject() {
        switch (this.type) {
            case 0: {
                long longVal = this.longValue();
                if (longVal > Integer.MAX_VALUE || longVal < Integer.MIN_VALUE) {
                    void var1_1;
                    return (long)var1_1;
                }
                return this.intValue();
            }
            case 2: {
                return this.boolValue();
            }
        }
        NSNumber nSNumber = this;
        return nSNumber.doubleValue;
    }

    private void throwIfIntegerValueNotAvailable() {
        if (this.type == 1) {
            if (Double.isNaN(this.doubleValue)) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is NaN.");
            }
            if (this.doubleValue == Double.POSITIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is positive infinity.");
            }
            if (this.doubleValue == Double.NEGATIVE_INFINITY) {
                throw new IllegalStateException("The integer value is not available because the value of this NSNumber instance is negative infinity.");
            }
        }
    }
}

