/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ASCIILocationInformation;
import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.LocationInformation;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.LinkedList;

public final class ASCIIPropertyListParser {
    private final char[] data;
    private int index;
    private int lineNo = 1;
    private int lineBeginning = -1;

    /*
     * WARNING - void declaration
     */
    private ASCIIPropertyListParser(byte[] propertyListContent, String encoding) throws UnsupportedEncodingException {
        this(new String((byte[])var1_1, (String)var2_2).toCharArray());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ASCIIPropertyListParser(char[] propertyListContent) {
        void var1_1;
        this.data = var1_1;
    }

    public static NSObject parse(InputStream in) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(in));
    }

    /*
     * WARNING - void declaration
     */
    private static NSObject parse(byte[] bytes) throws ParseException {
        String charset = ByteOrderMarkReader.detect(bytes);
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            String string = charset;
            ASCIIPropertyListParser aSCIIPropertyListParser = new ASCIIPropertyListParser((byte[])bytes, string);
            bytes = aSCIIPropertyListParser;
            return aSCIIPropertyListParser.parse();
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            void var1_2;
            throw new RuntimeException("Unsupported property list encoding (" + (String)var1_2 + "): " + var0_1.getMessage());
        }
    }

    private boolean acceptSequence(char ... sequence) {
        if (this.index + sequence.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (this.data[this.index + i] == sequence[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean accept(char ... acceptableSymbols) {
        void var2_2;
        boolean symbolPresent = false;
        if (this.index < this.data.length) {
            void var1_1;
            for (void c : var1_1) {
                if (this.data[this.index] != c) continue;
                symbolPresent = true;
                break;
            }
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean accept(char acceptableSymbol) {
        void var1_1;
        return this.index < this.data.length && this.data[this.index] == var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void expect(char ... expectedSymbols) throws ParseException {
        if (!this.accept(expectedSymbols)) {
            void var2_2;
            StringBuilder excString = new StringBuilder();
            excString.append("Expected '").append(expectedSymbols[0]).append("'");
            for (int i = 1; i < expectedSymbols.length; ++i) {
                excString.append(" or '").append(expectedSymbols[i]).append("'");
            }
            if (this.index < this.data.length) {
                excString.append(" but found '").append(this.data[this.index]).append("'");
            } else {
                excString.append(" but reached end of input");
            }
            throw this.createParseException(var2_2.toString(), this.index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void read(char symbol) throws ParseException {
        void var1_1;
        ASCIIPropertyListParser aSCIIPropertyListParser = this;
        void var2_3 = var1_1;
        if (!aSCIIPropertyListParser.accept((char)var2_3)) {
            ASCIIPropertyListParser aSCIIPropertyListParser2 = aSCIIPropertyListParser;
            throw aSCIIPropertyListParser2.createParseException(aSCIIPropertyListParser2.index < aSCIIPropertyListParser.data.length ? "Expected '" + (char)var2_3 + "' but found '" + aSCIIPropertyListParser.data[aSCIIPropertyListParser.index] + "'" : "Expected '" + (char)var2_3 + "' but reached end of input", aSCIIPropertyListParser.index);
        }
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    /*
     * WARNING - void declaration
     */
    private void skip(int numSymbols) {
        void var1_1;
        this.index += var1_1;
    }

    private void trackLineBreak() {
        if (this.data[this.index] == '\n') {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
        if (this.data[this.index] == '\r' && (this.index + 1 >= this.data.length || this.data[this.index + 1] != '\n')) {
            ++this.lineNo;
            this.lineBeginning = this.index;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void skipWhitespacesAndComments() {
        void var1_1;
        do {
            boolean commentSkipped = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.trackLineBreak();
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
            } else {
                if (!this.acceptSequence('/', '*')) continue;
                this.skip(2);
                while (this.index < this.data.length) {
                    if (this.acceptSequence('*', '/')) {
                        this.skip(2);
                        break;
                    }
                    this.trackLineBreak();
                    this.skip();
                }
            }
            commentSkipped = true;
        } while (var1_1 != false);
    }

    /*
     * WARNING - void declaration
     */
    private String readInputUntil(char ... symbols) {
        void var2_2;
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbols)) {
            strBuf.append(this.data[this.index]);
            this.skip();
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String readInputUntil(char symbol) {
        void var2_2;
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbol)) {
            strBuf.append(this.data[this.index]);
            this.trackLineBreak();
            this.skip();
        }
        return var2_2.toString();
    }

    private NSObject parse() throws ParseException {
        this.index = 0;
        if (this.data.length == 0) {
            throw new ParseException("The property list is empty.", 0);
        }
        if (this.data[0] == '\ufeff') {
            this.skip(1);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.createParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    /*
     * WARNING - void declaration
     */
    private NSObject parseObject() throws ParseException {
        Object result;
        ASCIIPropertyListParser aSCIIPropertyListParser;
        ASCIILocationInformation loc = new ASCIILocationInformation(this.index, this.lineNo, this.index - this.lineBeginning);
        switch (this.data[this.index]) {
            case '(': {
                aSCIIPropertyListParser = this;
                aSCIIPropertyListParser.skip();
                aSCIIPropertyListParser.skipWhitespacesAndComments();
                LinkedList<NSObject> linkedList = new LinkedList<NSObject>();
                while (!aSCIIPropertyListParser.accept(')')) {
                    linkedList.add(aSCIIPropertyListParser.parseObject());
                    aSCIIPropertyListParser.skipWhitespacesAndComments();
                    if (!aSCIIPropertyListParser.accept(',')) break;
                    aSCIIPropertyListParser.skip();
                    aSCIIPropertyListParser.skipWhitespacesAndComments();
                }
                aSCIIPropertyListParser.read(')');
                result = new NSArray(linkedList.toArray(new NSObject[0]));
                break;
            }
            case '{': {
                result = this;
                ((ASCIIPropertyListParser)result).skip();
                super.skipWhitespacesAndComments();
                NSDictionary nSDictionary = new NSDictionary();
                while (!super.accept('}')) {
                    Object object;
                    if (super.accept('\"')) {
                        object = super.parseQuotedString();
                    } else {
                        object = result;
                        object = super.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
                    }
                    super.skipWhitespacesAndComments();
                    super.read('=');
                    super.skipWhitespacesAndComments();
                    NSObject nSObject = super.parseObject();
                    nSDictionary.put((String)object, nSObject);
                    super.skipWhitespacesAndComments();
                    super.read(';');
                    super.skipWhitespacesAndComments();
                }
                super.skip();
                result = nSDictionary;
                break;
            }
            case '<': {
                result = this.parseData();
                break;
            }
            case '\"': {
                void var3_5;
                String quotedString = this.parseQuotedString();
                if (quotedString.length() == 20 && quotedString.charAt(4) == '-') {
                    try {
                        result = new NSDate(quotedString);
                    }
                    catch (Exception exception) {
                        result = new NSString(quotedString);
                    }
                    break;
                }
                result = new NSString((String)var3_5);
                break;
            }
            default: {
                result = this.data[this.index] >= '0' && this.data[this.index] <= '9' ? this.parseDateString() : new NSString(this.parseString());
            }
        }
        if (result != null) {
            void var1_1;
            ((NSObject)result).setLocationInformation((LocationInformation)var1_1);
        }
        return aSCIIPropertyListParser;
    }

    /*
     * WARNING - void declaration
     */
    private NSObject parseData() throws ParseException {
        NSData nSData;
        Object dataString;
        int dataStartIndex = this.index;
        NSNumber obj = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                obj = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                Object dateString = this.readInputUntil('>');
                dateString = new NSDate((String)dateString);
            } else if (this.accept('I', 'R')) {
                this.skip();
                Object numberString = this.readInputUntil('>');
                try {
                    numberString = new NSNumber((String)numberString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.createParseException("The NSNumber object has an invalid format.", dataStartIndex);
                }
            }
            this.read('>');
        } else if (this.accept('[')) {
            this.skip();
            dataString = this.readInputUntil(']');
            try {
                dataString = new NSData((String)dataString);
            }
            catch (IOException iOException) {
                throw this.createParseException("The NSData object could be parsed.", dataStartIndex);
            }
            this.skip();
            this.read('>');
        } else {
            void var3_4;
            dataString = this.readInputUntil('>');
            dataString = ((String)dataString).replaceAll("\\s+", "");
            int n = ((String)dataString).length() / 2;
            byte[] bytes = new byte[n];
            int bi = 0;
            int ci = 0;
            while (bi < bytes.length) {
                int nibble1 = Character.digit(((String)dataString).charAt(ci), 16);
                int nibble2 = Character.digit(((String)dataString).charAt(ci + 1), 16);
                if (nibble1 == -1 || nibble2 == -1) {
                    throw this.createParseException("The NSData object contains non-hexadecimal characters.", dataStartIndex);
                }
                bytes[bi] = (byte)(nibble1 << 4 | nibble2);
                ++bi;
                ci += 2;
            }
            nSData = new NSData((byte[])var3_4);
            this.skip();
        }
        return nSData;
    }

    private NSObject parseDateString() {
        ASCIIPropertyListParser aSCIIPropertyListParser = this;
        String numericalString = aSCIIPropertyListParser.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
        if (numericalString.length() > 4 && numericalString.charAt(4) == '-') {
            try {
                return new NSDate(numericalString);
            }
            catch (Exception exception) {}
        }
        return new NSString((String)((Object)aSCIIPropertyListParser));
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    /*
     * WARNING - void declaration
     */
    private String parseQuotedString() throws ParseException {
        void var1_1;
        this.skip();
        StringBuilder stringBuilder = new StringBuilder();
        EscapeSequenceHandler escapeSequenceHandler = null;
        while (this.data[this.index] != '\"' || escapeSequenceHandler != null) {
            char c = this.data[this.index];
            if (escapeSequenceHandler != null) {
                if (escapeSequenceHandler.handleNextChar(c)) {
                    escapeSequenceHandler = null;
                }
            } else if (c == '\\') {
                escapeSequenceHandler = new EscapeSequenceHandler(stringBuilder);
            } else {
                void var3_3;
                stringBuilder.append((char)var3_3);
            }
            this.trackLineBreak();
            this.skip();
        }
        if (escapeSequenceHandler != null) {
            void var2_2;
            var2_2.handleEndOfString();
        }
        this.skip();
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private ParseException createParseException(String message, int index) {
        void var2_2;
        void var1_1;
        return new ParseException((String)var1_1 + " (" + this.lineNo + ":" + (index - this.lineBeginning) + ")", (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ParseException access$200(ASCIIPropertyListParser x0, String x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.createParseException((String)var1_1, (int)var2_2);
    }

    private final class EscapeSequenceHandler {
        private final int startIndex;
        private final StringBuilder stringBuilder;
        private int unicodeReferenceRadix = 0;
        private StringBuilder unicodeReference;

        /*
         * WARNING - void declaration
         */
        public EscapeSequenceHandler(StringBuilder stringBuilder) {
            void var2_2;
            this.startIndex = ASCIIPropertyListParser.this.index;
            this.stringBuilder = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean handleNextChar(char c222) throws ParseException {
            void var1_1;
            switch (this.unicodeReferenceRadix) {
                case 8: {
                    char c = c222;
                    EscapeSequenceHandler c222 = this;
                    if (Character.digit(c, 8) == -1) {
                        String string = new String(c222.ASCIIPropertyListParser.this.data, c222.startIndex, c222.ASCIIPropertyListParser.this.index - c222.startIndex + 1);
                        throw ASCIIPropertyListParser.access$200(c222.ASCIIPropertyListParser.this, "The property list contains a string with an invalid escape sequence: " + string, c222.startIndex);
                    }
                    c222.unicodeReference.append(c);
                    if (c222.unicodeReference.length() == 3) {
                        c = (char)Integer.parseInt(c222.unicodeReference.toString(), 8);
                        c222.stringBuilder.append(c);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    char c222;
                    char c = c222;
                    EscapeSequenceHandler c222 = this;
                    if (Character.digit(c, 16) == -1) {
                        String string = new String(c222.ASCIIPropertyListParser.this.data, c222.startIndex, c222.ASCIIPropertyListParser.this.index - c222.startIndex + 1);
                        throw ASCIIPropertyListParser.access$200(c222.ASCIIPropertyListParser.this, "The property list contains a string with an invalid escape sequence: " + string, c222.startIndex);
                    }
                    c222.unicodeReference.append(c);
                    if (c222.unicodeReference.length() == 4) {
                        c = (char)Integer.parseInt(c222.unicodeReference.toString(), 16);
                        c222.stringBuilder.append(c);
                        return true;
                    }
                    return false;
                }
            }
            void var2_9 = var1_1;
            EscapeSequenceHandler escapeSequenceHandler = this;
            switch (var2_9) {
                case 34: 
                case 39: 
                case 92: {
                    escapeSequenceHandler.stringBuilder.append((char)var2_9);
                    return true;
                }
                case 98: {
                    escapeSequenceHandler.stringBuilder.append('\b');
                    return true;
                }
                case 110: {
                    escapeSequenceHandler.stringBuilder.append('\n');
                    return true;
                }
                case 114: {
                    escapeSequenceHandler.stringBuilder.append('\r');
                    return true;
                }
                case 116: {
                    escapeSequenceHandler.stringBuilder.append('\t');
                    return true;
                }
                case 85: 
                case 117: {
                    escapeSequenceHandler.unicodeReferenceRadix = 16;
                    escapeSequenceHandler.unicodeReference = new StringBuilder(4);
                    return false;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    escapeSequenceHandler.unicodeReferenceRadix = 8;
                    escapeSequenceHandler.unicodeReference = new StringBuilder(3);
                    escapeSequenceHandler.unicodeReference.append((char)var2_9);
                    return false;
                }
            }
            throw ASCIIPropertyListParser.access$200(escapeSequenceHandler.ASCIIPropertyListParser.this, "The property list contains an invalid escape sequence: \\" + (char)var2_9, escapeSequenceHandler.startIndex);
        }

        /*
         * WARNING - void declaration
         */
        public final void handleEndOfString() throws ParseException {
            void var1_1;
            String sequence = new String(ASCIIPropertyListParser.this.data, this.startIndex, ASCIIPropertyListParser.this.index - this.startIndex + 1);
            throw ASCIIPropertyListParser.access$200(ASCIIPropertyListParser.this, "The property list contains a string with an incomplete escape sequence: " + (String)var1_1, this.startIndex);
        }
    }
}

