/*
 * Decompiled with CFR 0.152.
 */
package com.materialkolor.utils;

import com.materialkolor.utils.MathUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\n\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0015\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015\u00a2\u0006\u0004\b#\u0010\u0018J\u0015\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015\u00a2\u0006\u0004\b%\u0010\u0018R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0014\u0010*\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+"}, d2={"Lcom/materialkolor/utils/ColorUtils;", "", "<init>", "()V", "", "red", "green", "blue", "argbFromRgb", "(III)I", "", "linrgb", "argbFromLinrgb", "([D)I", "argb", "redFromArgb", "(I)I", "greenFromArgb", "xyzFromArgb", "(I)[D", "labFromArgb", "", "lstar", "yFromLstar", "(D)D", "y", "lstarFromY", "rgbComponent", "linearized", "(I)D", "delinearized", "(D)I", "whitePointD65", "()[D", "t", "labF", "ft", "labInvf", "", "SRGB_TO_XYZ", "[[D", "XYZ_TO_SRGB", "WHITE_POINT_D65", "[D"})
public final class ColorUtils {
    public static final ColorUtils INSTANCE = new ColorUtils();
    private static final double[][] SRGB_TO_XYZ;
    private static final double[][] XYZ_TO_SRGB;
    private static final double[] WHITE_POINT_D65;

    private ColorUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static int argbFromRgb(int red, int green, int blue) {
        void var2_2;
        void var1_1;
        int n;
        return 0xFF000000 | (n & 0xFF) << 16 | (var1_1 & 0xFF) << 8 | var2_2 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final int argbFromLinrgb(double[] linrgb) {
        void var1_2;
        void var3_4;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)linrgb, (String)"linrgb");
        int r = ColorUtils.delinearized(linrgb[0]);
        int g = ColorUtils.delinearized(linrgb[1]);
        int b = ColorUtils.delinearized(linrgb[2]);
        return ColorUtils.argbFromRgb((int)var2_3, (int)var3_4, (int)var1_2);
    }

    private static int redFromArgb(int argb) {
        return argb >> 16 & 0xFF;
    }

    private static int greenFromArgb(int argb) {
        return argb >> 8 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final double[] xyzFromArgb(int argb) {
        void var2_3;
        void var1_1;
        double r = ColorUtils.linearized(ColorUtils.redFromArgb(argb));
        double g = ColorUtils.linearized(ColorUtils.greenFromArgb(argb));
        double b = ColorUtils.linearized(var1_1 & 0xFF);
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = var2_3;
        dArray2[1] = g;
        dArray2[2] = b;
        return MathUtils.matrixMultiply(dArray2, SRGB_TO_XYZ);
    }

    /*
     * WARNING - void declaration
     */
    public final double[] labFromArgb(int argb) {
        double[] dArray;
        void var2_3;
        double linearR = ColorUtils.linearized(ColorUtils.redFromArgb(argb));
        double linearG = ColorUtils.linearized(ColorUtils.greenFromArgb(argb));
        double linearB = ColorUtils.linearized(argb & 0xFF);
        double[][] matrix = SRGB_TO_XYZ;
        double x = SRGB_TO_XYZ[0][0] * linearR + matrix[0][1] * linearG + matrix[0][2] * linearB;
        double y = matrix[1][0] * linearR + matrix[1][1] * linearG + matrix[1][2] * linearB;
        double z = matrix[2][0] * var2_3 + matrix[2][1] * linearG + matrix[2][2] * linearB;
        double[] whitePoint = WHITE_POINT_D65;
        double xNormalized = x / whitePoint[0];
        double yNormalized = y / whitePoint[1];
        double zNormalized = z / dArray[2];
        double fx = ColorUtils.labF(xNormalized);
        double fy = ColorUtils.labF(yNormalized);
        double fz = ColorUtils.labF(zNormalized);
        double l = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        double[] dArray2 = new double[3];
        dArray = dArray2;
        dArray2[0] = l;
        dArray[1] = a;
        dArray[2] = b;
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public final double yFromLstar(double lstar) {
        void var1_1;
        return 100.0 * ColorUtils.labInvf((double)((var1_1 + 16.0) / 116.0));
    }

    public final double lstarFromY(double y) {
        return ColorUtils.labF(y / 100.0) * 116.0 - 16.0;
    }

    /*
     * WARNING - void declaration
     */
    public static double linearized(int rgbComponent) {
        void var1_1;
        double d;
        double normalized = (double)rgbComponent / 255.0;
        if (d <= 0.040449936) {
            return normalized / 12.92 * 100.0;
        }
        return Math.pow((double)((var1_1 + 0.055) / 1.055), 2.4) * 100.0;
    }

    /*
     * WARNING - void declaration
     */
    public static int delinearized(double rgbComponent) {
        void var2_1;
        double d;
        double normalized = rgbComponent / 100.0;
        double d2 = d <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow((double)var2_1, 0.4166666666666667) - 0.055;
        return (int)RangesKt.coerceIn((double)Math.rint(d2 * 255.0), (double)0.0, (double)255.0);
    }

    public static double[] whitePointD65() {
        return WHITE_POINT_D65;
    }

    public static double labF(double t) {
        double d;
        if (t > 0.008856451679035631) {
            return Math.pow(t, 0.3333333333333333);
        }
        return (903.2962962962963 * d + 16.0) / 116.0;
    }

    /*
     * WARNING - void declaration
     */
    private static double labInvf(double ft) {
        double d;
        double d2;
        double d3 = ft;
        double ft3 = d3 * d3 * ft;
        if (d2 > 0.008856451679035631) {
            void var2_1;
            return (double)var2_1;
        }
        return (116.0 * d - 16.0) / 903.2962962962963;
    }

    static {
        double[][] dArrayArray = new double[3][];
        Object object = dArrayArray;
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = 0.41233895;
        dArray2[1] = 0.35762064;
        dArray2[2] = 0.18051042;
        dArrayArray[0] = dArray2;
        double[] dArray3 = new double[3];
        dArray2 = dArray3;
        dArray3[0] = 0.2126;
        dArray2[1] = 0.7152;
        dArray2[2] = 0.0722;
        object[1] = dArray2;
        double[] dArray4 = new double[3];
        dArray2 = dArray4;
        dArray4[0] = 0.01932141;
        dArray2[1] = 0.11916382;
        dArray2[2] = 0.95034478;
        object[2] = dArray2;
        SRGB_TO_XYZ = object;
        double[][] dArrayArray2 = new double[3][];
        object = dArrayArray2;
        double[] dArray5 = new double[3];
        dArray2 = dArray5;
        dArray5[0] = 3.2413774792388685;
        dArray2[1] = -1.5376652402851851;
        dArray2[2] = -0.49885366846268053;
        dArrayArray2[0] = dArray2;
        double[] dArray6 = new double[3];
        dArray2 = dArray6;
        dArray6[0] = -0.9691452513005321;
        dArray2[1] = 1.8758853451067872;
        dArray2[2] = 0.04156585616912061;
        object[1] = dArray2;
        double[] dArray7 = new double[3];
        dArray2 = dArray7;
        dArray7[0] = 0.05562093689691305;
        dArray2[1] = -0.20395524564742123;
        dArray2[2] = 1.0571799111220335;
        object[2] = dArray2;
        XYZ_TO_SRGB = object;
        double[] dArray8 = new double[3];
        object = dArray8;
        dArray8[0] = 95.047;
        object[1] = (double[])100.0;
        object[2] = (double[])108.883;
        WHITE_POINT_D65 = (double[])object;
    }
}

