/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.TextLayoutResult;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=0)
public final class SelectableInfo {
    private final long selectableId;
    private final int slot;
    private final int rawStartHandleOffset;
    private final int rawEndHandleOffset;
    private final int rawPreviousHandleOffset;
    private final TextLayoutResult textLayoutResult;
    public static final int $stable = TextLayoutResult.$stable;

    /*
     * WARNING - void declaration
     */
    public SelectableInfo(long selectableId2, int slot, int rawStartHandleOffset, int rawEndHandleOffset, int rawPreviousHandleOffset, TextLayoutResult textLayoutResult) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
        this.selectableId = var1_1;
        this.slot = var3_2;
        this.rawStartHandleOffset = rawStartHandleOffset;
        this.rawEndHandleOffset = rawEndHandleOffset;
        this.rawPreviousHandleOffset = rawPreviousHandleOffset;
        this.textLayoutResult = textLayoutResult;
    }

    public final long getSelectableId() {
        return this.selectableId;
    }

    public final int getSlot() {
        return this.slot;
    }

    public final int getRawStartHandleOffset() {
        return this.rawStartHandleOffset;
    }

    public final int getRawEndHandleOffset() {
        return this.rawEndHandleOffset;
    }

    public final int getRawPreviousHandleOffset() {
        return this.rawPreviousHandleOffset;
    }

    public final TextLayoutResult getTextLayoutResult() {
        return this.textLayoutResult;
    }

    public final String getInputText() {
        return this.textLayoutResult.getLayoutInput().getText().getText();
    }

    public final int getTextLength() {
        return this.getInputText().length();
    }

    public final CrossStatus getRawCrossStatus() {
        if (this.rawStartHandleOffset < this.rawEndHandleOffset) {
            return CrossStatus.NOT_CROSSED;
        }
        if (this.rawStartHandleOffset > this.rawEndHandleOffset) {
            return CrossStatus.CROSSED;
        }
        return CrossStatus.COLLAPSED;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean shouldRecomputeSelection(SelectableInfo other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.selectableId != other.selectableId || this.rawStartHandleOffset != other.rawStartHandleOffset || this.rawEndHandleOffset != var1_1.rawEndHandleOffset;
    }

    /*
     * WARNING - void declaration
     */
    public final Selection.AnchorInfo anchorForOffset(int offset) {
        void var1_1;
        return new Selection.AnchorInfo(SelectionLayoutKt.access$getTextDirectionForOffset(this.textLayoutResult, offset), (int)var1_1, this.selectableId);
    }

    /*
     * WARNING - void declaration
     */
    public final Selection makeSingleLayoutSelection(int start, int end) {
        void var2_2;
        void var1_1;
        return new Selection(this.anchorForOffset(start), this.anchorForOffset(end), var1_1 > var2_2);
    }

    public final String toString() {
        SelectableInfo selectableInfo = this;
        SelectableInfo selectableInfo2 = selectableInfo;
        selectableInfo2 = this;
        return "SelectionInfo(id=" + this.selectableId + ", range=(" + this.rawStartHandleOffset + '-' + SelectionLayoutKt.access$getTextDirectionForOffset(selectableInfo.textLayoutResult, selectableInfo2.rawStartHandleOffset) + ',' + this.rawEndHandleOffset + '-' + SelectionLayoutKt.access$getTextDirectionForOffset(selectableInfo2.textLayoutResult, selectableInfo2.rawEndHandleOffset) + "), prevOffset=" + this.rawPreviousHandleOffset + ')';
    }
}

