/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.collection.LongIntMap;
import androidx.collection.LongObjectMap;
import androidx.collection.LongObjectMapKt;
import androidx.collection.MutableLongObjectMap;
import androidx.compose.foundation.text.selection.CrossStatus;
import androidx.compose.foundation.text.selection.SelectableInfo;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayout;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@SourceDebugExtension(value={"SMAP\nSelectionLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,733:1\n1#2:734\n69#3,6:735\n*S KotlinDebug\n*F\n+ 1 SelectionLayout.kt\nandroidx/compose/foundation/text/selection/MultiSelectionLayout\n*L\n270#1:735,6\n*E\n"})
final class MultiSelectionLayout
implements SelectionLayout {
    private final LongIntMap selectableIdToInfoListIndex;
    private final List<SelectableInfo> infoList;
    private final int startSlot;
    private final int endSlot;
    private final boolean isStartHandle;
    private final Selection previousSelection;

    /*
     * WARNING - void declaration
     */
    public MultiSelectionLayout(LongIntMap selectableIdToInfoListIndex, List<SelectableInfo> infoList, int startSlot, int endSlot, boolean isStartHandle, Selection previousSelection) {
        void var3_3;
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)selectableIdToInfoListIndex, (String)"selectableIdToInfoListIndex");
        Intrinsics.checkNotNullParameter(infoList, (String)"infoList");
        this.selectableIdToInfoListIndex = string;
        this.infoList = var2_2;
        this.startSlot = var3_3;
        this.endSlot = endSlot;
        this.isStartHandle = isStartHandle;
        this.previousSelection = previousSelection;
        if (!(this.infoList.size() > 1)) {
            string = "MultiSelectionLayout requires an infoList size greater than 1, was " + this.infoList.size() + '.';
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final int getStartSlot() {
        return this.startSlot;
    }

    @Override
    public final int getEndSlot() {
        return this.endSlot;
    }

    @Override
    public final boolean isStartHandle() {
        return this.isStartHandle;
    }

    @Override
    public final Selection getPreviousSelection() {
        return this.previousSelection;
    }

    @Override
    public final int getSize() {
        return this.infoList.size();
    }

    @Override
    public final CrossStatus getCrossStatus() {
        MultiSelectionLayout multiSelectionLayout = this;
        MultiSelectionLayout multiSelectionLayout2 = multiSelectionLayout;
        multiSelectionLayout2 = this;
        if (multiSelectionLayout.startSlot < multiSelectionLayout2.endSlot) {
            return CrossStatus.NOT_CROSSED;
        }
        MultiSelectionLayout multiSelectionLayout3 = this;
        multiSelectionLayout2 = multiSelectionLayout3;
        multiSelectionLayout2 = this;
        if (multiSelectionLayout3.startSlot > multiSelectionLayout2.endSlot) {
            return CrossStatus.CROSSED;
        }
        multiSelectionLayout2 = this;
        return this.infoList.get(multiSelectionLayout2.startSlot / 2).getRawCrossStatus();
    }

    @Override
    public final SelectableInfo getStartInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.startSlot, true));
    }

    @Override
    public final SelectableInfo getEndInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        return this.infoList.get(multiSelectionLayout.startOrEndSlotToIndex(multiSelectionLayout.endSlot, false));
    }

    @Override
    public final SelectableInfo getCurrentInfo() {
        MultiSelectionLayout multiSelectionLayout = this;
        if (multiSelectionLayout.isStartHandle) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final SelectableInfo getFirstInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getEndInfo();
        }
        return this.getStartInfo();
    }

    private SelectableInfo getLastInfo() {
        if (this.getCrossStatus() == CrossStatus.CROSSED) {
            return this.getStartInfo();
        }
        return this.getEndInfo();
    }

    @Override
    public final void forEachMiddleInfo(Function1<? super SelectableInfo, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        MultiSelectionLayout multiSelectionLayout = this;
        int minIndex = multiSelectionLayout.getInfoListIndexBySelectableId(multiSelectionLayout.getFirstInfo().getSelectableId());
        MultiSelectionLayout multiSelectionLayout2 = this;
        int maxIndex = multiSelectionLayout2.getInfoListIndexBySelectableId(multiSelectionLayout2.getLastInfo().getSelectableId());
        if (minIndex + 1 >= maxIndex) {
            return;
        }
        for (int i = minIndex + 1; i < maxIndex; ++i) {
            block.invoke((Object)this.infoList.get(i));
        }
    }

    @Override
    public final boolean shouldRecomputeSelection(SelectionLayout other) {
        block9: {
            block8: {
                boolean bl;
                block7: {
                    MultiSelectionLayout multiSelectionLayout;
                    MultiSelectionLayout multiSelectionLayout2 = this;
                    if (multiSelectionLayout2.previousSelection == null || other == null || !(other instanceof MultiSelectionLayout)) break block8;
                    MultiSelectionLayout multiSelectionLayout3 = this;
                    multiSelectionLayout2 = multiSelectionLayout3;
                    multiSelectionLayout2 = (MultiSelectionLayout)other;
                    if (multiSelectionLayout3.isStartHandle != multiSelectionLayout2.isStartHandle) break block8;
                    MultiSelectionLayout multiSelectionLayout4 = this;
                    multiSelectionLayout2 = multiSelectionLayout4;
                    multiSelectionLayout2 = (MultiSelectionLayout)other;
                    if (multiSelectionLayout4.startSlot != multiSelectionLayout2.startSlot) break block8;
                    MultiSelectionLayout multiSelectionLayout5 = this;
                    multiSelectionLayout2 = multiSelectionLayout5;
                    multiSelectionLayout2 = (MultiSelectionLayout)other;
                    if (multiSelectionLayout5.endSlot != multiSelectionLayout2.endSlot) break block8;
                    multiSelectionLayout2 = multiSelectionLayout;
                    multiSelectionLayout = this;
                    if (multiSelectionLayout.getSize() != multiSelectionLayout2.getSize()) {
                        bl = true;
                    } else {
                        int n = multiSelectionLayout.infoList.size();
                        for (int i = 0; i < n; ++i) {
                            SelectableInfo selectableInfo;
                            SelectableInfo selectableInfo2 = multiSelectionLayout.infoList.get(i);
                            if (!selectableInfo2.shouldRecomputeSelection(selectableInfo = multiSelectionLayout2.infoList.get(i))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final LongObjectMap<Selection> createSubSelections(Selection selection) {
        void var1_1;
        void var3_3;
        MutableLongObjectMap mutableLongObjectMap;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (selection.getStart().getSelectableId() == selection.getEnd().getSelectableId()) {
            if (!(selection.getHandlesCrossed() && selection.getStart().getOffset() >= selection.getEnd().getOffset() || !selection.getHandlesCrossed() && selection.getStart().getOffset() <= selection.getEnd().getOffset())) {
                String string = "unexpectedly miss-crossed selection: " + selection;
                throw new IllegalStateException(string.toString());
            }
            return LongObjectMapKt.longObjectMapOf$7a6e42a6((long)selection.getStart().getSelectableId(), (Selection)selection);
        }
        MutableLongObjectMap $this$createSubSelections_u24lambda_u244 = mutableLongObjectMap = LongObjectMapKt.mutableLongObjectMapOf();
        Selection $this$createSubSelections_u24lambda_u244_u24lambda_u242 = selection;
        Selection.AnchorInfo minAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u242.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u242.getEnd() : $this$createSubSelections_u24lambda_u244_u24lambda_u242.getStart();
        MultiSelectionLayout.createAndPutSubSelection((MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection, this.getFirstInfo(), minAnchor.getOffset(), this.getFirstInfo().getTextLength());
        this.forEachMiddleInfo((Function1<? super SelectableInfo, Unit>)((Function1)new Function1<SelectableInfo, Unit>(this, (MutableLongObjectMap<Selection>)$this$createSubSelections_u24lambda_u244, selection){
            final /* synthetic */ MultiSelectionLayout this$0;
            final /* synthetic */ MutableLongObjectMap<Selection> $this_apply;
            final /* synthetic */ Selection $selection;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$this_apply = var2_2;
                this.$selection = var3_3;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(SelectableInfo info) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                MultiSelectionLayout.access$createAndPutSubSelection(this.this$0, this.$this_apply, this.$selection, info, 0, var1_1.getTextLength());
            }
        }));
        Selection $this$createSubSelections_u24lambda_u244_u24lambda_u243 = selection;
        Selection.AnchorInfo maxAnchor = $this$createSubSelections_u24lambda_u244_u24lambda_u243.getHandlesCrossed() ? $this$createSubSelections_u24lambda_u244_u24lambda_u243.getStart() : $this$createSubSelections_u24lambda_u244_u24lambda_u243.getEnd();
        MultiSelectionLayout.createAndPutSubSelection((MutableLongObjectMap<Selection>)var3_3, (Selection)var1_1, this.getLastInfo(), 0, maxAnchor.getOffset());
        return (LongObjectMap)mutableLongObjectMap;
    }

    /*
     * WARNING - void declaration
     */
    private static void createAndPutSubSelection(MutableLongObjectMap<Selection> $this$createAndPutSubSelection, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        void var1_1;
        void var2_2;
        MutableLongObjectMap<Selection> mutableLongObjectMap;
        void var3_3;
        Selection subSelection = selection.getHandlesCrossed() ? info.makeSingleLayoutSelection(maxOffset, minOffset) : info.makeSingleLayoutSelection(minOffset, maxOffset);
        if (!(var3_3 <= maxOffset)) {
            $this$createAndPutSubSelection = "minOffset should be less than or equal to maxOffset: " + subSelection;
            throw new IllegalStateException($this$createAndPutSubSelection.toString());
        }
        mutableLongObjectMap.put$33cced79(var2_2.getSelectableId(), (Selection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void $this$toString_u24lambda_u247;
        MultiSelectionLayout multiSelectionLayout = this;
        Object object = multiSelectionLayout;
        MultiSelectionLayout multiSelectionLayout2 = this;
        object = multiSelectionLayout2;
        MultiSelectionLayout multiSelectionLayout3 = this;
        object = multiSelectionLayout3;
        object = new StringBuilder();
        StringBuilder stringBuilder = object;
        StringBuilder stringBuilder2 = new StringBuilder("MultiSelectionLayout(isStartHandle=").append(multiSelectionLayout.isStartHandle).append(", startPosition=").append((float)(multiSelectionLayout2.startSlot + 1) / 2.0f).append(", endPosition=").append((float)(multiSelectionLayout3.endSlot + 1) / 2.0f).append(", crossed=").append((Object)this.getCrossStatus()).append(", infos=");
        $this$toString_u24lambda_u247.append("[\n\t");
        boolean first = true;
        List<SelectableInfo> $this$fastForEachIndexed$iv = this.infoList;
        int n = $this$fastForEachIndexed$iv.size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            void info;
            SelectableInfo item$iv = $this$fastForEachIndexed$iv.get(index$iv);
            int index = index$iv;
            if (first) {
                first = false;
            } else {
                $this$toString_u24lambda_u247.append(",\n\t");
            }
            $this$toString_u24lambda_u247.append(index + 1 + " -> " + info);
        }
        stringBuilder.append("\n]");
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder2.append(string).append(')').toString();
    }

    /*
     * WARNING - void declaration
     */
    private final int startOrEndSlotToIndex(int slot, boolean isStartSlot) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.getCrossStatus().ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = isStartSlot;
                break;
            }
            case 3: {
                void var2_2;
                if (var2_2 == false) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return MultiSelectionLayout.slotToIndex(slot, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static int slotToIndex(int slot, boolean isMinimumSlot) {
        void var1_1;
        int n;
        boolean slotAdjustment = !isMinimumSlot;
        return (n - var1_1) / 2;
    }

    /*
     * WARNING - void declaration
     */
    private final int getInfoListIndexBySelectableId(long id) {
        int n;
        try {
            n = this.selectableIdToInfoListIndex.get(id);
        }
        catch (NoSuchElementException e) {
            void var3_3;
            void var1_1;
            throw new IllegalStateException("Invalid selectableId: " + (long)var1_1, (Throwable)var3_3);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$createAndPutSubSelection(MultiSelectionLayout $this, MutableLongObjectMap $receiver, Selection selection, SelectableInfo info, int minOffset, int maxOffset) {
        void var3_3;
        void var2_2;
        MultiSelectionLayout.createAndPutSubSelection((MutableLongObjectMap<Selection>)$receiver, (Selection)var2_2, (SelectableInfo)var3_3, 0, maxOffset);
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CrossStatus.values().length];
            try {
                nArray[CrossStatus.COLLAPSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.NOT_CROSSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[CrossStatus.CROSSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

