/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.SuspendAnimationKt;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.lazy.layout.LazyLayoutAnimateScrollScope;
import androidx.compose.foundation.pager.DefaultPagerState;
import androidx.compose.foundation.pager.PagerLayoutInfo;
import androidx.compose.foundation.pager.PagerMeasureResult;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.saveable.RememberSaveableKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.layout.AlignmentLine;
import androidx.compose.ui.layout.MeasureResult;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import java.util.Map;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;

@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,961:1\n868#1,4:968\n1225#2,6:962\n149#3:972\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n*L\n895#1:968,4\n88#1:962,6\n828#1:972\n*E\n"})
public final class PagerStateKt {
    private static final float DefaultPositionThreshold = Dp.constructor-impl((float)56.0f);
    private static final PagerMeasureResult EmptyLayoutInfo;
    private static final UnitDensity.1 UnitDensity;

    /*
     * WARNING - void declaration
     */
    @Composable
    public static final PagerState rememberPagerState(int initialPage2, float initialPageOffsetFraction2, Function0<Integer> pageCount, Composer $composer, int $changed, int n) {
        void var2_5;
        void var3_6;
        Saver<DefaultPagerState, ?> saver2;
        DefaultPagerState defaultPagerState;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter(pageCount, (String)"pageCount");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart((int)-1210768637, (int)0, (int)-1, (String)"androidx.compose.foundation.pager.rememberPagerState (PagerState.kt:86)");
        }
        Object[] objectArray = new Object[]{};
        Saver<DefaultPagerState, ?> saver3 = DefaultPagerState.Companion.getSaver();
        Object v2 = null;
        Composer initialPageOffsetFraction2 = $composer;
        boolean invalid$iv = $composer.changed(initialPage2) | $composer.changed(0.0f) | $composer.changed(pageCount);
        Saver<DefaultPagerState, ?> it$iv = $this$cache$iv.rememberedValue();
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            void var0_1;
            void value$iv;
            it$iv = saver3;
            Object[] objectArray2 = objectArray;
            Function0 initialPage2 = (Function0)new Function0<DefaultPagerState>(initialPage2, 0.0f, pageCount){
                final /* synthetic */ int $initialPage;
                final /* synthetic */ float $initialPageOffsetFraction;
                final /* synthetic */ Function0<Integer> $pageCount;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.$initialPage = var1_1;
                    this.$initialPageOffsetFraction = var2_2;
                    this.$pageCount = var3_3;
                    super(0);
                }

                public final DefaultPagerState invoke() {
                    return new DefaultPagerState(this.$initialPage, this.$initialPageOffsetFraction, this.$pageCount);
                }
            };
            objectArray = objectArray2;
            saver3 = it$iv;
            v2 = null;
            defaultPagerState.updateRememberedValue(value$iv);
            saver2 = var0_1;
        } else {
            saver2 = it$iv;
        }
        Object object = (Function0)saver2;
        object = RememberSaveableKt.rememberSaveable((Object[])objectArray, saver3, v2, (Function0)object, (Composer)var3_6, (int)0, (int)4);
        defaultPagerState = (DefaultPagerState)object;
        defaultPagerState.getPageCountState().setValue((Object)var2_5);
        object = (DefaultPagerState)object;
        return (PagerState)object;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object animateToNextPage(PagerState $this$animateToNextPage, Continuation<? super Unit> $completion) {
        if ($this$animateToNextPage.getCurrentPage() + 1 < $this$animateToNextPage.getPageCount()) {
            void var1_1;
            PagerState pagerState;
            PagerState pagerState2 = pagerState;
            Object object = PagerState.animateScrollToPage$default(pagerState2, pagerState2.getCurrentPage() + 1, 0.0f, null, (Continuation)var1_1, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object animateToPreviousPage(PagerState $this$animateToPreviousPage, Continuation<? super Unit> $completion) {
        if ($this$animateToPreviousPage.getCurrentPage() - 1 >= 0) {
            void var1_1;
            PagerState pagerState;
            PagerState pagerState2 = pagerState;
            Object object = PagerState.animateScrollToPage$default(pagerState2, pagerState2.getCurrentPage() - 1, 0.0f, null, (Continuation)var1_1, 6, null);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final float getDefaultPositionThreshold() {
        return DefaultPositionThreshold;
    }

    public static final PagerMeasureResult getEmptyLayoutInfo() {
        return EmptyLayoutInfo;
    }

    /*
     * WARNING - void declaration
     */
    public static final long calculateNewMaxScrollOffset(PagerLayoutInfo $this$calculateNewMaxScrollOffset, int pageCount) {
        void var0_1;
        void var3_5;
        void var1_2;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)$this$calculateNewMaxScrollOffset, (String)"<this>");
        int pageSizeWithSpacing = $this$calculateNewMaxScrollOffset.getPageSpacing() + $this$calculateNewMaxScrollOffset.getPageSize();
        long maxScrollPossible = (long)pageCount * (long)var2_3 + (long)$this$calculateNewMaxScrollOffset.getBeforeContentPadding() + (long)$this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int layoutSize = $this$calculateNewMaxScrollOffset.getOrientation() == Orientation.Horizontal ? IntSize.getWidth-impl((long)$this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g()) : IntSize.getHeight-impl((long)$this$calculateNewMaxScrollOffset.getViewportSize-YbymL2g());
        SnapPosition snapPosition = $this$calculateNewMaxScrollOffset.getSnapPosition();
        $this$calculateNewMaxScrollOffset.getPageSize();
        $this$calculateNewMaxScrollOffset.getBeforeContentPadding();
        $this$calculateNewMaxScrollOffset.getAfterContentPadding();
        int snapPositionDiscount = layoutSize - RangesKt.coerceIn((int)snapPosition.position$6046c8c8(), (int)0, (int)var1_2);
        return RangesKt.coerceAtLeast((long)(var3_5 - (long)var0_1), (long)0L);
    }

    public static final /* synthetic */ UnitDensity.1 access$getUnitDensity$p() {
        return UnitDensity;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object access$animateScrollToPage$29849e11(LazyLayoutAnimateScrollScope $receiver, int targetPage2, float targetPageOffsetToSnappedPosition, AnimationSpec animationSpec, Function2 updateTargetPage, PagerState.animateScrollToPage.1 $completion) {
        void var3_3;
        void var2_2;
        void var1_1;
        LazyLayoutAnimateScrollScope lazyLayoutAnimateScrollScope = $receiver;
        Function2 function2 = updateTargetPage;
        PagerState.animateScrollToPage.1 var5_5 = $completion;
        Object object = lazyLayoutAnimateScrollScope.scroll((Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ScrollScope, Continuation<? super Unit>, Object>((Function2<? super ScrollScope, ? super Integer, Unit>)function2, (int)var1_1, lazyLayoutAnimateScrollScope, (float)var2_2, (AnimationSpec<Float>)var3_3, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<ScrollScope, Integer, Unit> $updateTargetPage;
            final /* synthetic */ int $targetPage;
            final /* synthetic */ LazyLayoutAnimateScrollScope $this_animateScrollToPage;
            final /* synthetic */ float $targetPageOffsetToSnappedPosition;
            final /* synthetic */ AnimationSpec<Float> $animationSpec;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$updateTargetPage = var1_1;
                this.$targetPage = var2_2;
                this.$this_animateScrollToPage = var3_3;
                this.$targetPageOffsetToSnappedPosition = $targetPageOffsetToSnappedPosition;
                this.$animationSpec = $animationSpec;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var3_6;
                        void var2_4;
                        ResultKt.throwOnFailure((Object)object);
                        ScrollScope $this$scroll = (ScrollScope)this.L$0;
                        this.$updateTargetPage.invoke((Object)$this$scroll, (Object)Boxing.boxInt((int)this.$targetPage));
                        boolean forward = this.$targetPage > this.$this_animateScrollToPage.getFirstVisibleItemIndex();
                        int visiblePages = this.$this_animateScrollToPage.getLastVisibleItemIndex() - this.$this_animateScrollToPage.getFirstVisibleItemIndex() + 1;
                        if ((forward && this.$targetPage > this.$this_animateScrollToPage.getLastVisibleItemIndex() || !forward && this.$targetPage < this.$this_animateScrollToPage.getFirstVisibleItemIndex()) && Math.abs(this.$targetPage - this.$this_animateScrollToPage.getFirstVisibleItemIndex()) >= 3) {
                            int preJumpPosition = forward ? RangesKt.coerceAtLeast((int)(this.$targetPage - visiblePages), (int)this.$this_animateScrollToPage.getFirstVisibleItemIndex()) : RangesKt.coerceAtMost((int)(this.$targetPage + visiblePages), (int)this.$this_animateScrollToPage.getFirstVisibleItemIndex());
                            this.$this_animateScrollToPage.snapToItem($this$scroll, preJumpPosition, 0);
                        }
                        float displacement = this.$this_animateScrollToPage.calculateDistanceTo(this.$targetPage) + this.$targetPageOffsetToSnappedPosition;
                        Ref.FloatRef previousValue = new Ref.FloatRef();
                        this.label = 1;
                        if (SuspendAnimationKt.animate$default$6b5a86c3((float)0.0f, (float)var2_4, (float)0.0f, this.$animationSpec, (Function2)((Function2)new Function2<Float, Float, Unit>((Ref.FloatRef)var3_6, $this$scroll){
                            final /* synthetic */ Ref.FloatRef $previousValue;
                            final /* synthetic */ ScrollScope $$this$scroll;
                            {
                                void var2_2;
                                void var1_1;
                                this.$previousValue = var1_1;
                                this.$$this$scroll = var2_2;
                                super(2);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void invoke(float currentValue, float f) {
                                void var1_1;
                                float delta = currentValue - this.$previousValue.element;
                                float consumed = this.$$this$scroll.scrollBy(delta);
                                this.$previousValue.element += var1_1;
                            }
                        }), (Continuation)((Continuation)this), (int)4) != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)object);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            /*
             * WARNING - void declaration
             */
            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                void var1_1;
                Function2<ScrollScope, Continuation<? super Unit>, Object> function2;
                function2 = new /* invalid duplicate definition of identical inner class */;
                v0.L$0 = var1_1;
                return (Continuation)function2;
            }
        }), (Continuation<? super Unit>)var5_5);
        if (object != IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            object = Unit.INSTANCE;
        }
        return object;
    }

    public static final /* synthetic */ long access$calculateNewMinScrollOffset(PagerMeasureResult $receiver, int pageCount) {
        int n;
        void var0_1 = n;
        PagerMeasureResult pagerMeasureResult = $receiver;
        n = pagerMeasureResult.getOrientation() == Orientation.Horizontal ? IntSize.getWidth-impl((long)pagerMeasureResult.getViewportSize-YbymL2g()) : IntSize.getHeight-impl((long)pagerMeasureResult.getViewportSize-YbymL2g());
        SnapPosition snapPosition = pagerMeasureResult.getSnapPosition();
        pagerMeasureResult.getPageSize();
        pagerMeasureResult.getBeforeContentPadding();
        pagerMeasureResult.getAfterContentPadding();
        return RangesKt.coerceIn((int)snapPosition.position$6046c8c8(), (int)0, (int)n);
    }

    static {
        List list = CollectionsKt.emptyList();
        Orientation orientation = Orientation.Horizontal;
        SnapPosition.Start start = SnapPosition.Start.INSTANCE;
        MeasureResult measureResult2 = new MeasureResult(){
            private final int width;
            private final int height;
            private final Map<AlignmentLine, Integer> alignmentLines;
            {
                this.alignmentLines = MapsKt.emptyMap();
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            public final Map<AlignmentLine, Integer> getAlignmentLines() {
                return this.alignmentLines;
            }

            public final void placeChildren() {
            }
        };
        CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
        EmptyLayoutInfo = new PagerMeasureResult(list, 0, 0, 0, orientation, 0, 0, false, 0, null, null, 0.0f, 0, false, start, measureResult2, false, null, null, coroutineScope, 393216, null);
        UnitDensity = new Density(){
            private final float density;
            private final float fontScale;
            {
                this.density = 1.0f;
                this.fontScale = 1.0f;
            }

            public final float getDensity() {
                return this.density;
            }

            public final float getFontScale() {
                return this.fontScale;
            }
        };
    }
}

