/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.foundation.lazy.layout.LazyLayoutBeyondBoundsState;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.layout.Remeasurement;
import java.util.Collection;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@StabilityInferred(parameters=1)
public final class PagerBeyondBoundsState
implements LazyLayoutBeyondBoundsState {
    private final PagerState state;
    private final int beyondViewportPageCount;

    /*
     * WARNING - void declaration
     */
    public PagerBeyondBoundsState(PagerState state, int beyondViewportPageCount) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = var1_1;
        this.beyondViewportPageCount = var2_2;
    }

    @Override
    public final void remeasure() {
        Remeasurement remeasurement = this.state.getRemeasurement$foundation();
        if (remeasurement != null) {
            remeasurement.forceRemeasure();
            return;
        }
    }

    @Override
    public final int getItemCount() {
        return this.state.getPageCount();
    }

    @Override
    public final boolean getHasVisibleItems() {
        return !((Collection)this.state.getLayoutInfo().getVisiblePagesInfo()).isEmpty();
    }

    @Override
    public final int getFirstPlacedIndex() {
        return Math.max(0, this.state.getFirstVisiblePage$foundation() - this.beyondViewportPageCount);
    }

    @Override
    public final int getLastPlacedIndex() {
        PagerBeyondBoundsState pagerBeyondBoundsState = this;
        return Math.min(pagerBeyondBoundsState.state.getPageCount() - 1, ((PageInfo)CollectionsKt.last(this.state.getLayoutInfo().getVisiblePagesInfo())).getIndex() + this.beyondViewportPageCount);
    }
}

