/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehaviorKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPosition;
import androidx.compose.foundation.gestures.snapping.SnapPositionKt;
import androidx.compose.foundation.pager.PageInfo;
import androidx.compose.foundation.pager.PagerSnapDistance;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.List;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;

@SourceDebugExtension(value={"SMAP\nPagerSnapLayoutInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,315:1\n226#1,4:316\n226#1,4:321\n226#1,4:325\n226#1,4:329\n226#1,4:333\n1#2:320\n*S KotlinDebug\n*F\n+ 1 PagerSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/PagerSnapLayoutInfoProviderKt\n*L\n255#1:316,4\n278#1:321,4\n288#1:325,4\n296#1:329,4\n300#1:333,4\n*E\n"})
public final class PagerSnapLayoutInfoProviderKt {
    /*
     * WARNING - void declaration
     */
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(PagerState pagerState, PagerSnapDistance pagerSnapDistance, Function3<? super Float, ? super Float, ? super Float, Float> calculateFinalSnappingBound) {
        void var1_1;
        void var2_2;
        PagerState pagerState2;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)pagerSnapDistance, (String)"pagerSnapDistance");
        Intrinsics.checkNotNullParameter(calculateFinalSnappingBound, (String)"calculateFinalSnappingBound");
        return new SnapLayoutInfoProvider(pagerState2, (Function3<? super Float, ? super Float, ? super Float, Float>)var2_2, (PagerSnapDistance)var1_1){
            final /* synthetic */ PagerState $pagerState;
            final /* synthetic */ Function3<Float, Float, Float, Float> $calculateFinalSnappingBound;
            final /* synthetic */ PagerSnapDistance $pagerSnapDistance;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$pagerState = var1_1;
                this.$calculateFinalSnappingBound = var2_2;
                this.$pagerSnapDistance = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public final float calculateSnapOffset(float velocity) {
                float f;
                Object snapPosition = this.$pagerState.getLayoutInfo().getSnapPosition();
                float f2 = velocity;
                SnapPosition snapPosition2 = snapPosition;
                snapPosition = this;
                float f3 = Float.NEGATIVE_INFINITY;
                float f4 = Float.POSITIVE_INFINITY;
                Object object = snapPosition;
                List<PageInfo> list = object.$pagerState.getLayoutInfo().getVisiblePagesInfo();
                PagerState pagerState = snapPosition.$pagerState;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    float f5;
                    PageInfo pageInfo = list.get(i);
                    object = snapPosition;
                    object = object.$pagerState.getLayoutInfo();
                    Intrinsics.checkNotNullParameter((Object)object, (String)"<this>");
                    int n2 = object.getOrientation() == Orientation.Vertical ? IntSize.getHeight-impl((long)object.getViewportSize-YbymL2g()) : IntSize.getWidth-impl((long)object.getViewportSize-YbymL2g());
                    Object object2 = snapPosition;
                    object = object2;
                    Object object3 = snapPosition;
                    object = object3;
                    object = snapPosition;
                    float f6 = SnapPositionKt.calculateDistanceToDesiredSnapPosition(n2, object2.$pagerState.getLayoutInfo().getBeforeContentPadding(), object3.$pagerState.getLayoutInfo().getAfterContentPadding(), object.$pagerState.getLayoutInfo().getPageSize(), pageInfo.getOffset(), pageInfo.getIndex(), snapPosition2, pagerState.getPageCount());
                    if (f5 <= 0.0f && f6 > f3) {
                        f3 = f6;
                    }
                    if (!(f6 >= 0.0f) || !(f6 < f4)) continue;
                    f4 = f6;
                }
                if (f3 == Float.NEGATIVE_INFINITY) {
                    f3 = f4;
                }
                if (f4 == Float.POSITIVE_INFINITY) {
                    f4 = f3;
                }
                if (!snapPosition.$pagerState.getCanScrollForward()) {
                    f4 = 0.0f;
                    if (PagerSnapLayoutInfoProviderKt.access$isScrollingForward(snapPosition.$pagerState, f2)) {
                        f3 = 0.0f;
                    }
                }
                if (!snapPosition.$pagerState.getCanScrollBackward()) {
                    f3 = 0.0f;
                    if (!PagerSnapLayoutInfoProviderKt.access$isScrollingForward(snapPosition.$pagerState, f2)) {
                        f4 = 0.0f;
                    }
                }
                snapPosition = TuplesKt.to((Object)Float.valueOf(f3), (Object)Float.valueOf(f4));
                float lowerBoundOffset = ((Number)snapPosition.component1()).floatValue();
                float upperBoundOffset = ((Number)snapPosition.component2()).floatValue();
                float finalDistance2 = ((Number)this.$calculateFinalSnappingBound.invoke((Object)Float.valueOf(velocity), (Object)Float.valueOf(lowerBoundOffset), (Object)Float.valueOf(upperBoundOffset))).floatValue();
                if (!(finalDistance2 == lowerBoundOffset || finalDistance2 == upperBoundOffset || finalDistance2 == 0.0f)) {
                    void var3_7;
                    String finalDistance2 = "Final Snapping Offset Should Be one of " + (float)var3_7 + ", " + f + " or 0.0";
                    throw new IllegalStateException(finalDistance2.toString());
                }
                f = finalDistance2;
                if (!(f == Float.POSITIVE_INFINITY) && !(f == Float.NEGATIVE_INFINITY)) {
                    void var1_1;
                    return (float)var1_1;
                }
                return 0.0f;
            }

            /*
             * WARNING - void declaration
             */
            public final float calculateApproachOffset(float velocity, float decayOffset) {
                float f;
                void var2_3;
                void var3_4;
                void animationOffsetPx;
                int effectivePageSizePx = this.$pagerState.getPageSize$foundation() + this.$pagerState.getPageSpacing$foundation();
                if (effectivePageSizePx == 0) {
                    return 0.0f;
                }
                int startPage = velocity < 0.0f ? this.$pagerState.getFirstVisiblePage$foundation() + 1 : this.$pagerState.getFirstVisiblePage$foundation();
                void pagesInAnimationOffset = animationOffsetPx / (float)effectivePageSizePx;
                int targetPage2 = RangesKt.coerceIn((int)(startPage + (int)pagesInAnimationOffset), (int)0, (int)this.$pagerState.getPageCount());
                this.$pagerState.getPageSize$foundation();
                this.$pagerState.getPageSpacing$foundation();
                targetPage2 = RangesKt.coerceIn((int)this.$pagerSnapDistance.calculateTargetPage$2e9b9ea2(startPage, targetPage2), (int)0, (int)this.$pagerState.getPageCount());
                targetPage2 = (targetPage2 - startPage) * effectivePageSizePx;
                int flingApproachOffsetPx = RangesKt.coerceAtLeast((int)(Math.abs(targetPage2) - var3_4), (int)0);
                f = flingApproachOffsetPx == 0 ? (float)flingApproachOffsetPx : (float)var2_3 * Math.signum(f);
                return f;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isScrollingForward(PagerState $this$isScrollingForward, float velocity) {
        void var2_3;
        void var0_1;
        PagerState pagerState;
        boolean isForward;
        void var1_2;
        boolean reverseScrollDirection = $this$isScrollingForward.getLayoutInfo().getReverseLayout();
        boolean bl = $this$isScrollingForward.isNotGestureAction$foundation() ? var1_2 < 0.0f : (isForward = PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) > 0.0f);
        return bl && reverseScrollDirection || var0_1 == false && var2_3 == false;
    }

    private static final float dragGestureDelta(PagerState $this$dragGestureDelta) {
        PagerState pagerState;
        if ($this$dragGestureDelta.getLayoutInfo().getOrientation() == Orientation.Horizontal) {
            return Offset.getX-impl((long)$this$dragGestureDelta.getUpDownDifference-F1C5BW0$foundation());
        }
        return Offset.getY-impl((long)pagerState.getUpDownDifference-F1C5BW0$foundation());
    }

    /*
     * WARNING - void declaration
     */
    public static final float calculateFinalSnappingBound(PagerState pagerState, LayoutDirection layoutDirection, float snapPositionalThreshold, float flingVelocity, float lowerBoundOffset, float upperBoundOffset) {
        int n;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)layoutDirection, (String)"layoutDirection");
        boolean isScrollingForward = PagerSnapLayoutInfoProviderKt.isScrollingForward(pagerState, flingVelocity);
        boolean isForward = pagerState.getLayoutInfo().getOrientation() == Orientation.Vertical ? isScrollingForward : (layoutDirection == LayoutDirection.Ltr ? isScrollingForward : !isScrollingForward);
        int pageSize = pagerState.getLayoutInfo().getPageSize();
        float offsetFromSnappedPosition = pageSize == 0 ? 0.0f : PagerSnapLayoutInfoProviderKt.dragGestureDelta(pagerState) / (float)pageSize;
        float offsetFromSnappedPositionOverflow = offsetFromSnappedPosition - (float)((int)offsetFromSnappedPosition);
        Density density = pagerState.getDensity$foundation();
        void var8_13 = var3_4;
        Density density2 = density;
        Intrinsics.checkNotNullParameter((Object)density, (String)"<this>");
        int n2 = Math.abs((float)var8_13) < density2.toPx-0680j_4(SnapFlingBehaviorKt.getMinFlingVelocityDp()) ? FinalSnappingItem.Companion.getClosestItem-bbeMdSM() : (var8_13 > 0.0f ? FinalSnappingItem.Companion.getNextItem-bbeMdSM() : FinalSnappingItem.Companion.getPreviousItem-bbeMdSM());
        n2 = n2;
        if (FinalSnappingItem.equals-impl0(n, FinalSnappingItem.Companion.getClosestItem-bbeMdSM())) {
            PagerState pagerState2;
            void var2_3;
            if (Math.abs(offsetFromSnappedPositionOverflow) > var2_3) {
                if (isForward) {
                    return upperBoundOffset;
                }
                return lowerBoundOffset;
            }
            if (Math.abs(offsetFromSnappedPosition) >= Math.abs(pagerState2.getPositionThresholdFraction$foundation())) {
                void var1_2;
                if (var1_2 != false) {
                    return lowerBoundOffset;
                }
                return upperBoundOffset;
            }
            if (Math.abs(lowerBoundOffset) < Math.abs(upperBoundOffset)) {
                return lowerBoundOffset;
            }
            return upperBoundOffset;
        }
        if (FinalSnappingItem.equals-impl0(n2, FinalSnappingItem.Companion.getNextItem-bbeMdSM())) {
            return upperBoundOffset;
        }
        if (FinalSnappingItem.equals-impl0(n2, FinalSnappingItem.Companion.getPreviousItem-bbeMdSM())) {
            return lowerBoundOffset;
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isScrollingForward(PagerState $receiver, float velocity) {
        void var1_1;
        return PagerSnapLayoutInfoProviderKt.isScrollingForward($receiver, (float)var1_1);
    }
}

