/*
 * Decompiled with CFR 0.152.
 */
package io.kamel.core.cache.disk;

import androidx.compose.runtime.internal.StabilityInferred;
import io.kamel.core.cache.disk.DiskLruCache;
import io.kamel.core.cache.disk.FaultHidingSink;
import io.kamel.core.utils.FileSystemKt;
import io.ktor.util.collections.ConcurrentMap;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 5 Okio.kt\nokio/Okio__OkioKt\n+ 6 FileSystem.kt\nokio/FileSystem\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,867:1\n1#2:868\n27#3:869\n27#3:901\n27#3:939\n27#3:941\n27#3:943\n27#3:945\n27#3:947\n27#3:957\n16#4:870\n16#4:902\n16#4:940\n16#4:942\n16#4:944\n16#4:946\n16#4:948\n16#4:958\n66#5:871\n52#5,4:873\n60#5,10:878\n56#5,3:888\n71#5,3:891\n52#5,4:906\n60#5,10:911\n56#5,18:921\n67#6:872\n68#6:877\n80#6:903\n165#6:904\n81#6:905\n82#6:910\n381#7,7:894\n37#8:949\n36#8,3:950\n37#8:953\n36#8,3:954\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache\n*L\n169#1:869\n329#1:901\n374#1:939\n397#1:941\n453#1:943\n540#1:945\n586#1:947\n649#1:957\n169#1:870\n329#1:902\n374#1:940\n397#1:942\n453#1:944\n540#1:946\n586#1:948\n649#1:958\n215#1:871\n215#1:873,4\n215#1:878,10\n215#1:888,3\n215#1:891,3\n332#1:906,4\n332#1:911,10\n332#1:921,18\n215#1:872\n215#1:877\n332#1:903\n332#1:904\n332#1:905\n332#1:910\n279#1:894,7\n593#1:949\n593#1:950,3\n640#1:953\n640#1:954,3\n*E\n"})
public final class DiskLruCache
implements AutoCloseable {
    public static final Companion Companion = new Companion(null);
    private final Path directory;
    private final long maxSize;
    private final int appVersion;
    private final int valueCount;
    private final Path journalFile;
    private final Path journalFileTmp;
    private final Path journalFileBackup;
    private final ConcurrentMap<String, Entry> lruEntries;
    private final CoroutineScope cleanupScope;
    private long size;
    private int operationsSinceRewrite;
    private BufferedSink journalWriter;
    private boolean hasJournalErrors;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private final fileSystem.1 fileSystem;
    public static final int $stable = 8;
    private static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");

    /*
     * WARNING - void declaration
     */
    private DiskLruCache(FileSystem fileSystem2, Path directory, CoroutineDispatcher cleanupDispatcher, long maxSize, int appVersion, int valueCount) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)cleanupDispatcher, (String)"cleanupDispatcher");
        this.directory = var2_2;
        this.maxSize = maxSize;
        this.appVersion = appVersion;
        this.valueCount = valueCount;
        if (!(this.maxSize > 0L)) {
            fileSystem2 = "maxSize <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        if (!(this.valueCount > 0)) {
            fileSystem2 = "valueCount <= 0";
            throw new IllegalArgumentException(fileSystem2.toString());
        }
        this.journalFile = this.directory.resolve("journal");
        this.journalFileTmp = this.directory.resolve("journal.tmp");
        this.journalFileBackup = this.directory.resolve("journal.bkp");
        this.lruEntries = new ConcurrentMap(0, 1, null);
        this.cleanupScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default$11598906(null, (int)1).plus((CoroutineContext)var3_3));
        this.fileSystem = new ForwardingFileSystem((FileSystem)var1_1){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Sink sink(Path file, boolean mustCreate) {
                void var2_2;
                void var1_1;
                block0: {
                    void var3_3;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path p0 = path;
                    this.createDirectories((Path)var3_3);
                }
                return super.sink((Path)var1_1, (boolean)var2_2);
            }
        };
    }

    public /* synthetic */ DiskLruCache(FileSystem fileSystem2, Path path, CoroutineDispatcher coroutineDispatcher, long l, int n, int n2, int n3) {
        this(fileSystem2, path, coroutineDispatcher, l, 1, 1);
    }

    private final void initialize() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            block44: {
                if (this.initialized) {
                    return;
                }
                this.fileSystem.delete(this.journalFileTmp);
                if (this.fileSystem.exists(this.journalFileBackup)) {
                    if (this.fileSystem.exists(this.journalFile)) {
                        this.fileSystem.delete(this.journalFileBackup);
                    } else {
                        this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
                    }
                }
                if (!this.fileSystem.exists(this.journalFile)) break block44;
                try {
                    Object object;
                    Object object2 = this;
                    Object object3 = (FileSystem)((DiskLruCache)object2).fileSystem;
                    Object object4 = ((DiskLruCache)object2).journalFile;
                    Object object5 = (Closeable)Okio.buffer((Source)object3.source(object4));
                    Throwable throwable = null;
                    try {
                        BufferedSource bufferedSource = (BufferedSource)object5;
                        object = bufferedSource;
                        object = bufferedSource;
                        object3 = bufferedSource.readUtf8LineStrict();
                        object4 = object.readUtf8LineStrict();
                        String string = object.readUtf8LineStrict();
                        String string2 = object.readUtf8LineStrict();
                        Object object6 = object.readUtf8LineStrict();
                        if (!(Intrinsics.areEqual((Object)"libcore.io.DiskLruCache", (Object)object3) && Intrinsics.areEqual((Object)"1", (Object)object4) && Intrinsics.areEqual((Object)String.valueOf(((DiskLruCache)object2).appVersion), (Object)string) && Intrinsics.areEqual((Object)String.valueOf(((DiskLruCache)object2).valueCount), (Object)string2) && !(((CharSequence)object6).length() > 0))) {
                            throw new IOException("unexpected journal header: [" + (String)object3 + ", " + (String)object4 + ", " + string + ", " + string2 + ", " + (String)object6 + ']');
                        }
                        int n = 0;
                        try {
                            while (true) {
                                block47: {
                                    Object v;
                                    Object object7;
                                    Object object8;
                                    int n2;
                                    int n3;
                                    block46: {
                                        int n4;
                                        block45: {
                                            string = object.readUtf8LineStrict();
                                            object4 = object2;
                                            n3 = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)0, (boolean)false, (int)6, null);
                                            if (n3 == -1) {
                                                throw new IOException("unexpected journal line: " + string);
                                            }
                                            n4 = n3 + 1;
                                            n2 = StringsKt.indexOf$default((CharSequence)string, (char)' ', (int)n4, (boolean)false, (int)4, null);
                                            if (n2 != -1) break block45;
                                            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n4), (String)"substring(...)");
                                            if (n3 != 6 || !StringsKt.startsWith$default((String)string, (String)"REMOVE", (boolean)false, (int)2, null)) break block46;
                                            object4.lruEntries.remove(object6);
                                            break block47;
                                        }
                                        String string3 = string.substring(n4, n2);
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                                        object6 = string3;
                                    }
                                    if ((object8 = (object7 = (Map)object4.lruEntries).get(object6)) == null) {
                                        object8 = (DiskLruCache)object4.new Entry((String)object6);
                                        object7.put(object6, object8);
                                        v = object8;
                                    } else {
                                        v = object8;
                                    }
                                    object6 = (Entry)v;
                                    if (n2 != -1 && n3 == 5 && StringsKt.startsWith$default((String)string, (String)"CLEAN", (boolean)false, (int)2, null)) {
                                        String string4 = string.substring(n2 + 1);
                                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                                        char[] cArray = new char[1];
                                        object4 = cArray;
                                        cArray[0] = 32;
                                        object7 = StringsKt.split$default((CharSequence)string4, (char[])object4, (boolean)false, (int)0, (int)6, null);
                                        ((Entry)object6).setReadable(true);
                                        ((Entry)object6).setCurrentEditor(null);
                                        ((Entry)object6).setLengths((List<String>)object7);
                                    } else if (n2 == -1 && n3 == 5 && StringsKt.startsWith$default((String)string, (String)"DIRTY", (boolean)false, (int)2, null)) {
                                        ((Entry)object6).setCurrentEditor(new Editor((DiskLruCache)object4, (Entry)object6));
                                    } else if (n2 != -1 || n3 != 4 || !StringsKt.startsWith$default((String)string, (String)"READ", (boolean)false, (int)2, null)) {
                                        throw new IOException("unexpected journal line: " + string);
                                    }
                                }
                                ++n;
                            }
                        }
                        catch (EOFException eOFException) {
                            ((DiskLruCache)object2).operationsSinceRewrite = n - ((DiskLruCache)object2).lruEntries.size();
                            if (!object.exhausted()) {
                                super.writeJournal();
                            } else {
                                ((DiskLruCache)object2).journalWriter = super.newJournalWriter();
                            }
                            try {
                                Object object9 = object5;
                                if (object9 != null) {
                                    object9.close();
                                }
                            }
                            catch (Throwable throwable2) {
                                object2 = throwable2;
                                throwable = throwable2;
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        object2 = throwable3;
                        throwable = throwable3;
                        try {
                            Closeable closeable = object5;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable throwable4) {
                            ExceptionsKt.addSuppressed((Throwable)throwable, (Throwable)throwable4);
                        }
                    }
                    catch (Throwable throwable5) {
                        try {
                            Closeable closeable = object5;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable throwable6) {}
                        throw throwable5;
                    }
                    Throwable throwable7 = throwable;
                    if (throwable7 != null) {
                        throw throwable7;
                    }
                    object2 = this;
                    long l = 0L;
                    object = ((DiskLruCache)object2).lruEntries.values().iterator();
                    while (object.hasNext()) {
                        int n;
                        object5 = (Entry)object.next();
                        if (((Entry)object5).getCurrentEditor() == null) {
                            int n5 = ((DiskLruCache)object2).valueCount;
                            for (n = 0; n < n5; ++n) {
                                l += ((Entry)object5).getLengths()[n];
                            }
                            continue;
                        }
                        ((Entry)object5).setCurrentEditor(null);
                        int n6 = ((DiskLruCache)object2).valueCount;
                        for (n = 0; n < n6; ++n) {
                            fileSystem.1 v13 = ((DiskLruCache)object2).fileSystem;
                            Path path = ((Entry)object5).getCleanFiles().get(n);
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                            v13.delete(path);
                            fileSystem.1 v15 = ((DiskLruCache)object2).fileSystem;
                            Path path2 = ((Entry)object5).getDirtyFiles().get(n);
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                            v15.delete(path2);
                        }
                        object.remove();
                    }
                    ((DiskLruCache)object2).size = l;
                    this.initialized = true;
                    return;
                }
                catch (IOException iOException) {
                    try {
                        DiskLruCache diskLruCache2 = this;
                        diskLruCache2.close();
                        FileSystemKt.deleteContents((FileSystem)diskLruCache2.fileSystem, diskLruCache2.directory);
                    }
                    finally {
                        this.closed = false;
                    }
                }
            }
            this.writeJournal();
            this.initialized = true;
            return;
        }
    }

    private final BufferedSink newJournalWriter() {
        FaultHidingSink faultHidingSink;
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        faultHidingSink = new FaultHidingSink(faultHidingSink, (Function1<? super IOException, Unit>)((Function1)arg_0 -> DiskLruCache.newJournalWriter$lambda$4(this, arg_0)));
        return Okio.buffer((Sink)faultHidingSink);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeJournal() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            void var3_3;
            block19: {
                Object $this$writeJournal_u24lambda_u247_u24lambda_u2462222;
                void $this$iv;
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    bufferedSink.close();
                }
                FileSystem fileSystem2 = (FileSystem)this.fileSystem;
                Path file$iv = this.journalFileTmp;
                Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
                Throwable thrown$iv$iv = null;
                try {
                    BufferedSink bufferedSink2;
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = bufferedSink2 = (BufferedSink)$this$use$iv$iv;
                    bufferedSink2.writeUtf8("libcore.io.DiskLruCache").writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8("1").writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeDecimalLong((long)this.appVersion).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeDecimalLong((long)this.valueCount).writeByte(10);
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                    for (Entry entry : this.lruEntries.values()) {
                        if (entry.getCurrentEditor() != null) {
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8("DIRTY");
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(32);
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(entry.getKey());
                            $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                            continue;
                        }
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8("CLEAN");
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(32);
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeUtf8(entry.getKey());
                        entry.writeLengths((BufferedSink)$this$writeJournal_u24lambda_u247_u24lambda_u2462222);
                        $this$writeJournal_u24lambda_u247_u24lambda_u2462222.writeByte(10);
                    }
                }
                catch (Throwable throwable) {
                    Throwable $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = throwable;
                    thrown$iv$iv = throwable;
                    try {
                        Closeable closeable = $this$use$iv$iv;
                        if (closeable != null) {
                            closeable.close();
                        }
                        break block19;
                    }
                    catch (Throwable t$iv$iv) {
                        ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv);
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    try {
                        FileSystem fileSystem3 = fileSystem2;
                        if (fileSystem3 == null) throw throwable;
                        fileSystem3.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$writeJournal_u24lambda_u247_u24lambda_u2462222 = throwable;
                    thrown$iv$iv = throwable;
                }
            }
            void v7 = var3_3;
            if (v7 != null) {
                throw v7;
            }
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            }
            this.journalWriter = this.newJournalWriter();
            this.operationsSinceRewrite = 0;
            this.hasJournalErrors = false;
            this.mostRecentRebuildFailed = false;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Snapshot get(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            void var3_4;
            void var1_1;
            Object object;
            block5: {
                this.checkNotClosed();
                DiskLruCache.validateKey(key);
                this.initialize();
                object = (Entry)this.lruEntries.get((Object)key);
                if (object != null && (object = ((Entry)object).snapshot()) != null) break block5;
                return null;
            }
            Object snapshot = object;
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink = this.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink $this$get_u24lambda_u249_u24lambda_u248 = bufferedSink;
            bufferedSink.writeUtf8("READ");
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(32);
            $this$get_u24lambda_u249_u24lambda_u248.writeUtf8((String)var1_1);
            $this$get_u24lambda_u249_u24lambda_u248.writeByte(10);
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            var1_1 = var3_4;
            return var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Editor edit(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            void var3_4;
            Editor editor;
            Entry entry;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            this.checkNotClosed();
                            DiskLruCache.validateKey(key);
                            this.initialize();
                            entry = (Entry)this.lruEntries.get((Object)key);
                            if ((entry != null ? entry.getCurrentEditor() : null) == null) break block8;
                            return null;
                        }
                        if (entry == null || entry.getLockingSnapshotCount() == 0) break block9;
                        return null;
                    }
                    if (!this.mostRecentTrimFailed && !this.mostRecentRebuildFailed) break block10;
                    this.launchCleanup();
                    return null;
                }
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                BufferedSink bufferedSink2 = bufferedSink;
                BufferedSink $this$edit_u24lambda_u2411_u24lambda_u2410 = bufferedSink;
                bufferedSink.writeUtf8("DIRTY");
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(32);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeUtf8(key);
                $this$edit_u24lambda_u2411_u24lambda_u2410.writeByte(10);
                $this$edit_u24lambda_u2411_u24lambda_u2410.flush();
                if (!this.hasJournalErrors) break block11;
                return null;
            }
            if (entry == null) {
                entry = new Entry(key);
                ((Map)this.lruEntries).put(editor, entry);
            }
            Editor editor2 = new Editor(this, entry);
            var3_4.setCurrentEditor(editor2);
            editor = editor2;
            return editor;
        }
    }

    private final boolean journalRewriteRequired() {
        return this.operationsSinceRewrite >= 2000;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeEntry(Entry entry) {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            void var1_1;
            block9: {
                if (entry.getLockingSnapshotCount() > 0) {
                    BufferedSink bufferedSink = this.journalWriter;
                    if (bufferedSink != null) {
                        BufferedSink bufferedSink2 = bufferedSink;
                        BufferedSink $this$removeEntry_u24lambda_u2416_u24lambda_u24142 = bufferedSink;
                        bufferedSink.writeUtf8("DIRTY");
                        $this$removeEntry_u24lambda_u2416_u24lambda_u24142.writeByte(32);
                        $this$removeEntry_u24lambda_u2416_u24lambda_u24142.writeUtf8(entry.getKey());
                        $this$removeEntry_u24lambda_u2416_u24lambda_u24142.writeByte(10);
                        $this$removeEntry_u24lambda_u2416_u24lambda_u24142.flush();
                    }
                }
                if (entry.getLockingSnapshotCount() <= 0 && entry.getCurrentEditor() == null) break block9;
                entry.setZombie(true);
                return true;
            }
            int $this$removeEntry_u24lambda_u2416_u24lambda_u24142 = this.valueCount;
            for (int i = 0; i < $this$removeEntry_u24lambda_u2416_u24lambda_u24142; ++i) {
                Path path = entry.getCleanFiles().get(i);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                this.fileSystem.delete(path);
                this.size -= entry.getLengths()[i];
                entry.getLengths()[i] = 0L;
            }
            int n = this.operationsSinceRewrite;
            this.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                void var3_6;
                BufferedSink $this$removeEntry_u24lambda_u2416_u24lambda_u24142 = bufferedSink;
                BufferedSink $this$removeEntry_u24lambda_u2416_u24lambda_u2415 = bufferedSink;
                bufferedSink.writeUtf8("REMOVE");
                $this$removeEntry_u24lambda_u2416_u24lambda_u2415.writeByte(32);
                $this$removeEntry_u24lambda_u2416_u24lambda_u2415.writeUtf8(entry.getKey());
                var3_6.writeByte(10);
            }
            this.lruEntries.remove((Object)var1_1.getKey());
            if (this.journalRewriteRequired()) {
                this.launchCleanup();
            }
            return true;
        }
    }

    private final void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final void close() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            if (!this.initialized || this.closed) {
                this.closed = true;
            } else {
                Collection collection;
                Collection object2 = collection = this.lruEntries.values();
                for (Entry entry : collection.toArray(new Entry[0])) {
                    Editor editor = entry.getCurrentEditor();
                    if (editor == null) continue;
                    editor.detach();
                }
                this.trimToSize();
                int n = 1;
                CoroutineScope coroutineScope = null;
                coroutineScope = this.cleanupScope;
                CoroutineScopeKt.cancel((CoroutineScope)coroutineScope, null);
                BufferedSink bufferedSink = this.journalWriter;
                Intrinsics.checkNotNull((Object)bufferedSink);
                bufferedSink.close();
                this.journalWriter = null;
                this.closed = true;
            }
            return;
        }
    }

    private final void trimToSize() {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            void var2_2;
            if (toEvict.getZombie()) continue;
            this.removeEntry((Entry)var2_2);
            return true;
        }
        return false;
    }

    private final Job launchCleanup() {
        DiskLruCache diskLruCache = this;
        synchronized (diskLruCache) {
            Job job = BuildersKt.launch$default((CoroutineScope)this.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ DiskLruCache this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(2, (Continuation)var2_2);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            if (!DiskLruCache.access$getInitialized$p(this.this$0) || DiskLruCache.access$getClosed$p(this.this$0)) {
                                return Unit.INSTANCE;
                            }
                            try {
                                DiskLruCache.access$trimToSize(this.this$0);
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentTrimFailed$p(this.this$0, true);
                            }
                            try {
                                if (DiskLruCache.access$journalRewriteRequired(this.this$0)) {
                                    DiskLruCache.access$writeJournal(this.this$0);
                                }
                            }
                            catch (IOException iOException) {
                                DiskLruCache.access$setMostRecentRebuildFailed$p(this.this$0, true);
                                DiskLruCache.access$setJournalWriter$p(this.this$0, Okio.buffer((Sink)Okio.blackhole()));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                /*
                 * WARNING - void declaration
                 */
                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    void var2_2;
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }
            }), (int)3, null);
            return job;
        }
    }

    private static void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            String string;
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    private static final Unit newJournalWriter$lambda$4(DiskLruCache this$0, IOException it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        var0.hasJournalErrors = true;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$removeEntry(DiskLruCache $this, Entry entry) {
        void var1_1;
        return $this.removeEntry((Entry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$completeEdit(DiskLruCache $this, Editor editor, boolean success) {
        DiskLruCache diskLruCache;
        DiskLruCache diskLruCache2 = diskLruCache = $this;
        synchronized (diskLruCache) {
            int n;
            int n2;
            void var2_3;
            Path path;
            Entry entry = path.getEntry();
            if (!Intrinsics.areEqual((Object)entry.getCurrentEditor(), (Object)path)) {
                throw new IllegalStateException("Check failed.");
            }
            if (var2_3 != false && !entry.getZombie()) {
                n2 = diskLruCache.valueCount;
                for (n = 0; n < n2; ++n) {
                    if (!path.getWritten()[n]) continue;
                    fileSystem.1 v0 = diskLruCache.fileSystem;
                    Path path2 = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                    if (v0.exists(path2)) continue;
                    path.abort();
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return;
                }
                n2 = diskLruCache.valueCount;
                for (n = 0; n < n2; ++n) {
                    long l;
                    Path path3;
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getDirtyFiles().get(n), (String)"get(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)entry.getCleanFiles().get(n), (String)"get(...)");
                    if (diskLruCache.fileSystem.exists(path)) {
                        diskLruCache.fileSystem.atomicMove(path, path3);
                    } else {
                        FileSystem fileSystem2 = (FileSystem)diskLruCache.fileSystem;
                        Path path4 = entry.getCleanFiles().get(n);
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                        FileSystemKt.createFile(fileSystem2, path4);
                    }
                    long l2 = entry.getLengths()[n];
                    Long l3 = diskLruCache.fileSystem.metadata(path3).getSize();
                    entry.getLengths()[n] = l = l3 != null ? l3 : 0L;
                    diskLruCache.size = diskLruCache.size - l2 + l;
                }
            } else {
                n2 = diskLruCache.valueCount;
                for (n = 0; n < n2; ++n) {
                    fileSystem.1 v5 = diskLruCache.fileSystem;
                    Path path5 = entry.getDirtyFiles().get(n);
                    Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
                    v5.delete(path5);
                }
            }
            entry.setCurrentEditor(null);
            if (entry.getZombie()) {
                diskLruCache.removeEntry(entry);
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return;
            }
            n = diskLruCache.operationsSinceRewrite;
            diskLruCache.operationsSinceRewrite = n + 1;
            BufferedSink bufferedSink = diskLruCache.journalWriter;
            Intrinsics.checkNotNull((Object)bufferedSink);
            BufferedSink bufferedSink2 = bufferedSink;
            BufferedSink bufferedSink3 = bufferedSink;
            if (var2_3 != false || entry.getReadable()) {
                entry.setReadable(true);
                bufferedSink3.writeUtf8("CLEAN");
                bufferedSink3.writeByte(32);
                bufferedSink3.writeUtf8(entry.getKey());
                entry.writeLengths(bufferedSink3);
                bufferedSink3.writeByte(10);
            } else {
                diskLruCache.lruEntries.remove((Object)entry.getKey());
                bufferedSink3.writeUtf8("REMOVE");
                bufferedSink3.writeByte(32);
                bufferedSink3.writeUtf8(entry.getKey());
                bufferedSink3.writeByte(10);
            }
            bufferedSink3.flush();
            if (diskLruCache.size > diskLruCache.maxSize || diskLruCache.journalRewriteRequired()) {
                diskLruCache.launchCleanup();
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    public static final /* synthetic */ boolean access$getClosed$p(DiskLruCache $this) {
        return $this.closed;
    }

    public static final /* synthetic */ void access$trimToSize(DiskLruCache $this) {
        $this.trimToSize();
    }

    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentTrimFailed = true;
    }

    public static final /* synthetic */ boolean access$journalRewriteRequired(DiskLruCache $this) {
        return $this.journalRewriteRequired();
    }

    public static final /* synthetic */ void access$writeJournal(DiskLruCache $this) {
        $this.writeJournal();
    }

    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        $this.mostRecentRebuildFailed = true;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        void var1_1;
        $this.journalWriter = var1_1;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006"}, d2={"Lio/kamel/core/cache/disk/DiskLruCache$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Editor\n+ 2 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 3 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,867:1\n27#2:868\n27#2:871\n27#2:873\n16#3:869\n16#3:872\n16#3:874\n1#4:870\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Editor\n*L\n721#1:868\n748#1:871\n762#1:873\n721#1:869\n748#1:872\n762#1:874\n*E\n"})
    public final class Editor {
        private final Entry entry;
        private boolean closed;
        private final boolean[] written;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Editor(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
            this.written = new boolean[this.this$0.valueCount];
        }

        public final Entry getEntry() {
            return this.entry;
        }

        public final boolean[] getWritten() {
            return this.written;
        }

        private final Path file(int index) {
            Object object = this.this$0;
            Editor editor = this;
            synchronized (editor) {
                if (!(!this.closed)) {
                    object = "editor is closed";
                    throw new IllegalStateException(object.toString());
                }
                this.written[0] = true;
                Path path = this.entry.getDirtyFiles().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Path path2 = path;
                object = ((DiskLruCache)object).fileSystem;
                Path p0 = path2;
                FileSystemKt.createFile((FileSystem)object, p0);
                object = path2;
                return object;
            }
        }

        public final Path file() {
            return this.file(0);
        }

        public final void detach() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                this.entry.setZombie(true);
            }
        }

        public final void commit() {
            this.complete(true);
        }

        public final void abort() {
            this.complete(false);
        }

        /*
         * WARNING - void declaration
         */
        private final void complete(boolean success2) {
            DiskLruCache diskLruCache = this.this$0;
            Editor editor = this;
            synchronized (editor) {
                if (!(!this.closed)) {
                    String success2 = "editor is closed";
                    throw new IllegalStateException(success2.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor(), (Object)this)) {
                    void var1_1;
                    DiskLruCache.access$completeEdit(diskLruCache, this, (boolean)var1_1);
                }
                this.closed = true;
                return;
            }
        }
    }

    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Entry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,867:1\n1863#2,2:868\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Entry\n*L\n838#1:868,2\n*E\n"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final ArrayList<Path> cleanFiles;
        private final ArrayList<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSnapshotCount;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.valueCount];
            this.cleanFiles = new ArrayList(DiskLruCache.this.valueCount);
            this.dirtyFiles = new ArrayList(DiskLruCache.this.valueCount);
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.valueCount;
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path = DiskLruCache.this.directory;
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(path.resolve(string));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path2 = DiskLruCache.this.directory;
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(path2.resolve(string2));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey() {
            return this.key;
        }

        public final long[] getLengths() {
            return this.lengths;
        }

        public final ArrayList<Path> getCleanFiles() {
            return this.cleanFiles;
        }

        public final ArrayList<Path> getDirtyFiles() {
            return this.dirtyFiles;
        }

        public final boolean getReadable() {
            return this.readable;
        }

        public final void setReadable(boolean bl) {
            this.readable = true;
        }

        public final boolean getZombie() {
            return this.zombie;
        }

        public final void setZombie(boolean bl) {
            this.zombie = true;
        }

        public final Editor getCurrentEditor() {
            return this.currentEditor;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentEditor(Editor editor) {
            void var1_1;
            this.currentEditor = var1_1;
        }

        public final int getLockingSnapshotCount() {
            return this.lockingSnapshotCount;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLockingSnapshotCount(int n) {
            void var1_1;
            this.lockingSnapshotCount = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths(List<String> strings) {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.valueCount) {
                throw new IOException("unexpected journal line: " + strings);
            }
            try {
                int n = ((Collection)strings).size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                throw new IOException("unexpected journal line: " + var1_1);
            }
        }

        public final void writeLengths(BufferedSink writer) {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        public final Snapshot snapshot() {
            if (!this.readable) {
                return null;
            }
            if (this.currentEditor != null || this.zombie) {
                return null;
            }
            Object object = this.cleanFiles;
            DiskLruCache diskLruCache = DiskLruCache.this;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                Path file = (Path)e;
                if (diskLruCache.fileSystem.exists((Path)e)) continue;
                try {
                    DiskLruCache.access$removeEntry(diskLruCache, this);
                }
                catch (IOException iOException) {}
                return null;
            }
            int n = this.lockingSnapshotCount;
            this.lockingSnapshotCount = n + 1;
            return new Snapshot(DiskLruCache.this, this);
        }
    }

    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Snapshot\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Synchronized.common.kt\nkotlinx/coroutines/internal/Synchronized_commonKt\n+ 4 Synchronized.kt\nkotlinx/coroutines/internal/SynchronizedKt\n*L\n1#1,867:1\n1#2:868\n27#3:869\n27#3:871\n16#4:870\n16#4:872\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nio/kamel/core/cache/disk/DiskLruCache$Snapshot\n*L\n686#1:869\n701#1:871\n686#1:870\n701#1:872\n*E\n"})
    public final class Snapshot
    implements Closeable {
        private final Entry entry;
        private boolean closed;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Snapshot(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
        }

        public final Path file() {
            boolean bl = false;
            Object object = this;
            if (!(!((Snapshot)object).closed)) {
                object = "snapshot is closed";
                throw new IllegalStateException(object.toString());
            }
            Path path = ((Snapshot)object).entry.getCleanFiles().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @Override
        public final void close() {
            DiskLruCache diskLruCache = this.this$0;
            DiskLruCache diskLruCache2 = this.this$0;
            synchronized (diskLruCache) {
                if (!this.closed) {
                    this.closed = true;
                    BuildersKt.launch$default((CoroutineScope)diskLruCache2.cleanupScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diskLruCache2, null){
                        int label;
                        final /* synthetic */ Snapshot this$0;
                        final /* synthetic */ DiskLruCache this$1;
                        {
                            void var3_3;
                            void var2_2;
                            void var1_1;
                            this.this$0 = var1_1;
                            this.this$1 = var2_2;
                            super(2, (Continuation)var3_3);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    object = Snapshot.access$getEntry$p(this.this$0);
                                    int n = ((Entry)object).getLockingSnapshotCount();
                                    ((Entry)object).setLockingSnapshotCount(n + -1);
                                    if (Snapshot.access$getEntry$p(this.this$0).getLockingSnapshotCount() == 0 && Snapshot.access$getEntry$p(this.this$0).getZombie()) {
                                        BuildersKt.launch$default((CoroutineScope)DiskLruCache.access$getCleanupScope$p(this.this$1), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ DiskLruCache this$0;
                                            final /* synthetic */ Snapshot this$1;
                                            {
                                                void var3_3;
                                                void var2_2;
                                                void var1_1;
                                                this.this$0 = var1_1;
                                                this.this$1 = var2_2;
                                                super(2, (Continuation)var3_3);
                                            }

                                            public final Object invokeSuspend(Object object) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        DiskLruCache.access$removeEntry(this.this$0, Snapshot.access$getEntry$p(this.this$1));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                void var2_2;
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }
                                        }), (int)3, null);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            void var2_2;
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }
                    }), (int)3, null);
                }
                return;
            }
        }

        public static final /* synthetic */ Entry access$getEntry$p(Snapshot $this) {
            return $this.entry;
        }
    }
}

