/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.mylzw;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public final class MyBitInputStream
extends FilterInputStream {
    private final ByteOrder byteOrder;
    private final boolean tiffLZWMode;
    private long bytesRead;
    private int bitsInCache;
    private int bitCache;

    /*
     * WARNING - void declaration
     */
    public MyBitInputStream(InputStream is, ByteOrder byteOrder, boolean tiffLZWMode) {
        super((InputStream)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.byteOrder = var2_2;
        this.tiffLZWMode = var3_3;
    }

    @Override
    public final int read() throws IOException {
        return this.readBits(8);
    }

    /*
     * WARNING - void declaration
     */
    public final int readBits(int sampleBits) throws IOException {
        void var2_2;
        void var1_1;
        while (this.bitsInCache < sampleBits) {
            int next = this.in.read();
            if (next < 0) {
                if (this.tiffLZWMode) {
                    return 257;
                }
                return -1;
            }
            int newByte = 0xFF & next;
            this.bitCache = this.byteOrder == ByteOrder.BIG_ENDIAN ? this.bitCache << 8 | newByte : newByte << this.bitsInCache | this.bitCache;
            ++this.bytesRead;
            this.bitsInCache += 8;
        }
        int sampleMask = (1 << sampleBits) - 1;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            int sample = sampleMask & this.bitCache >> this.bitsInCache - sampleBits;
        } else {
            sample &= this.bitCache;
            this.bitCache >>= sampleBits;
        }
        this.bitsInCache -= sampleBits;
        int remainderMask = (1 << this.bitsInCache) - 1;
        this.bitCache &= var1_1;
        return (int)var2_2;
    }
}

