/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.xpm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BasicCParser;
import org.apache.commons.imaging.formats.xpm.XpmImagingParameters;

public class XpmImageParser
extends AbstractImageParser<XpmImagingParameters> {
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.XPM.getExtensions();
    private static Map<String, Integer> colorNames;
    private static final String DEFAULT_EXTENSION;
    private static final char[] WRITE_PALETTE;

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.XPM};
    }

    /*
     * Exception decompiling
     */
    private static int parseColor(String color) throws ImagingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    private static boolean parseNextString(BasicCParser cParser, StringBuilder stringBuilder) throws IOException, ImagingException {
        void var2_2;
        stringBuilder.setLength(0);
        String token = cParser.nextToken();
        if (token.charAt(0) != '\"') {
            throw new ImagingException("Parsing XPM file failed, no string found where expected");
        }
        do {
            BasicCParser.unescapeString(stringBuilder, token);
        } while ((token = cParser.nextToken()).charAt(0) == '\"');
        if (",".equals(token)) {
            return true;
        }
        if ("}".equals(var2_2)) {
            return false;
        }
        throw new ImagingException("Parsing XPM file failed, no ',' or '}' found where expected");
    }

    /*
     * WARNING - void declaration
     */
    private XpmParseResult parseXpmHeader(ByteSource byteSource) throws ImagingException, IOException {
        void var2_2;
        block25: {
            InputStream is = byteSource.getInputStream();
            try {
                char c;
                XpmImageParser xpmImageParser;
                StringBuilder firstComment = new StringBuilder();
                ByteArrayOutputStream preprocessedFile = BasicCParser.preprocess(is, firstComment, null);
                if (!"XPM".equals(firstComment.toString().trim())) {
                    throw new ImagingException("Parsing XPM file failed, signature isn't '/* XPM */'");
                }
                XpmParseResult xpmParseResult = new XpmParseResult(0);
                new XpmParseResult(0).cParser = new BasicCParser(new ByteArrayInputStream(((ByteArrayOutputStream)((Object)xpmImageParser)).toByteArray()));
                Object object = xpmParseResult.cParser;
                xpmImageParser = this;
                Object object2 = ((BasicCParser)object).nextToken();
                if (!"static".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no 'static' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"char".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no 'char' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"*".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no '*' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (object2 == null) {
                    throw new ImagingException("Parsing XPM file failed, no variable name");
                }
                if (((String)object2).charAt(0) != '_' && !Character.isLetter(((String)object2).charAt(0))) {
                    throw new ImagingException("Parsing XPM file failed, variable name doesn't start with letter or underscore");
                }
                for (int i = 0; i < ((String)object2).length(); ++i) {
                    c = ((String)object2).charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_') continue;
                    throw new ImagingException("Parsing XPM file failed, variable name contains non-letter non-digit non-underscore");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"[".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no '[' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"]".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no ']' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"=".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no '=' token");
                }
                object2 = ((BasicCParser)object).nextToken();
                if (!"{".equals(object2)) {
                    throw new ImagingException("Parsing XPM file failed, no '{' token");
                }
                Object object3 = new StringBuilder();
                boolean bl = XpmImageParser.parseNextString((BasicCParser)object, (StringBuilder)object3);
                c = (char)(bl ? 1 : 0);
                if (!bl) {
                    throw new ImagingException("Parsing XPM file failed, file too short");
                }
                object2 = XpmImageParser.parseXpmValuesSection(((StringBuilder)object3).toString());
                object3 = object;
                object = object2;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < ((XpmHeader)object).numColors; ++i) {
                    String string;
                    stringBuilder.setLength(0);
                    boolean bl2 = XpmImageParser.parseNextString((BasicCParser)object3, stringBuilder);
                    if (!bl2) {
                        throw new ImagingException("Parsing XPM file failed, file ended while reading palette");
                    }
                    String string2 = stringBuilder.substring(0, ((XpmHeader)object).numCharsPerPixel);
                    String[] stringArray = BasicCParser.tokenizeRow(stringBuilder.substring(((XpmHeader)object).numCharsPerPixel));
                    PaletteEntry paletteEntry = new PaletteEntry(0);
                    new PaletteEntry(0).index = i;
                    int n = Integer.MIN_VALUE;
                    StringBuilder stringBuilder2 = new StringBuilder();
                    for (int j = 0; j < stringArray.length; ++j) {
                        string = stringArray[j];
                        boolean bl3 = false;
                        if (n < j - 1 && "m".equals(string) || "g4".equals(string) || "g".equals(string) || "c".equals(string) || "s".equals(string)) {
                            bl3 = true;
                        }
                        if (bl3) {
                            if (n >= 0) {
                                String string3 = stringArray[n];
                                string = stringBuilder2.toString();
                                stringBuilder2.setLength(0);
                                xpmImageParser.populatePaletteEntry(paletteEntry, string3, string);
                            }
                            n = j;
                            continue;
                        }
                        if (n < 0) break;
                        if (stringBuilder2.length() > 0) {
                            stringBuilder2.append(' ');
                        }
                        stringBuilder2.append(string);
                    }
                    if (n >= 0 && stringBuilder2.length() > 0) {
                        String string4 = stringArray[n];
                        string = stringBuilder2.toString();
                        stringBuilder2.setLength(0);
                        xpmImageParser.populatePaletteEntry(paletteEntry, string4, string);
                    }
                    ((XpmHeader)object).palette.put(string2, paletteEntry);
                }
                xpmParseResult.xpmHeader = object2;
                if (is == null) break block25;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static XpmHeader parseXpmValuesSection(String row) throws ImagingException {
        String[] tokens = BasicCParser.tokenizeRow(row);
        if (tokens.length < 4 || tokens.length > 7) {
            throw new ImagingException("Parsing XPM file failed, <Values> section has incorrect tokens");
        }
        try {
            void var3_4;
            void var2_3;
            int width = Integer.parseInt(tokens[0]);
            int height = Integer.parseInt(tokens[1]);
            int numColors = Integer.parseInt(tokens[2]);
            int numCharsPerPixel = Integer.parseInt(tokens[3]);
            int xHotSpot = -1;
            int yHotSpot = -1;
            boolean xpmExt = false;
            if (tokens.length >= 6) {
                xHotSpot = Integer.parseInt(tokens[4]);
                yHotSpot = Integer.parseInt(tokens[5]);
            }
            if (tokens.length == 5 || tokens.length == 7) {
                String[] stringArray;
                if (!"XPMEXT".equals(stringArray[stringArray.length - 1])) {
                    throw new ImagingException("Parsing XPM file failed, can't parse <Values> section XPMEXT");
                }
                xpmExt = true;
            }
            return new XpmHeader(width, (int)var2_3, (int)var3_4, numCharsPerPixel, xHotSpot, yHotSpot, xpmExt);
        }
        catch (NumberFormatException nfe) {
            void var1_2;
            throw new ImagingException("Parsing XPM file failed, error parsing <Values> section", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void populatePaletteEntry(PaletteEntry paletteEntry, String key, String color) throws ImagingException {
        void var2_2;
        if ("m".equals(key)) {
            paletteEntry.monoArgb = XpmImageParser.parseColor(color);
            paletteEntry.haveMono = true;
            return;
        }
        if ("g4".equals(key)) {
            paletteEntry.gray4LevelArgb = XpmImageParser.parseColor(color);
            paletteEntry.haveGray4Level = true;
            return;
        }
        if ("g".equals(key)) {
            paletteEntry.grayArgb = XpmImageParser.parseColor(color);
            paletteEntry.haveGray = true;
            return;
        }
        if ("s".equals(key) || "c".equals(var2_2)) {
            void var3_3;
            paletteEntry.colorArgb = XpmImageParser.parseColor((String)var3_3);
            var1_1.haveColor = true;
        }
    }

    static {
        DEFAULT_EXTENSION = ImageFormats.XPM.getDefaultExtension();
        WRITE_PALETTE = new char[]{' ', '.', 'X', 'o', 'O', '+', '@', '#', '$', '%', '&', '*', '=', '-', ';', ':', '>', ',', '<', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'p', 'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'z', 'x', 'c', 'v', 'b', 'n', 'm', 'M', 'N', 'B', 'V', 'C', 'Z', 'A', 'S', 'D', 'F', 'G', 'H', 'J', 'K', 'L', 'P', 'I', 'U', 'Y', 'T', 'R', 'E', 'W', 'Q', '!', '~', '^', '/', '(', ')', '_', '`', '\'', ']', '[', '{', '}', '|'};
    }

    private static final class XpmHeader {
        final int height;
        final int numCharsPerPixel;
        final int numColors;
        final Map<Object, PaletteEntry> palette = new HashMap<Object, PaletteEntry>();
        final int width;
        int xHotSpot = -1;
        final boolean xpmExt;
        int yHotSpot = -1;

        /*
         * WARNING - void declaration
         */
        XpmHeader(int width, int height, int numColors, int numCharsPerPixel, int xHotSpot, int yHotSpot, boolean xpmExt) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.numColors = var3_3;
            this.numCharsPerPixel = numCharsPerPixel;
            this.xHotSpot = xHotSpot;
            this.yHotSpot = yHotSpot;
            this.xpmExt = xpmExt;
        }
    }

    private static final class XpmParseResult {
        BasicCParser cParser;
        XpmHeader xpmHeader;

        private XpmParseResult() {
        }

        /* synthetic */ XpmParseResult(byte by) {
            this();
        }
    }

    private static final class PaletteEntry {
        int colorArgb;
        int gray4LevelArgb;
        int grayArgb;
        boolean haveColor;
        boolean haveGray;
        boolean haveGray4Level;
        boolean haveMono;
        int index;
        int monoArgb;

        private PaletteEntry() {
        }

        final int getBestArgb() {
            if (this.haveColor) {
                return this.colorArgb;
            }
            if (this.haveGray) {
                return this.grayArgb;
            }
            if (this.haveGray4Level) {
                return this.gray4LevelArgb;
            }
            if (this.haveMono) {
                return this.monoArgb;
            }
            return 0;
        }

        /* synthetic */ PaletteEntry(byte by) {
            this();
        }
    }
}

