/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.wbmp;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.wbmp.WbmpImagingParameters;

public final class WbmpImageParser
extends AbstractImageParser<WbmpImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.WBMP.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.WBMP.getExtensions();

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.WBMP};
    }

    /*
     * WARNING - void declaration
     */
    private BufferedImage getBufferedImage$1fd63e3d(ByteSource byteSource) throws ImagingException, IOException {
        Object object;
        block7: {
            InputStream is = byteSource.getInputStream();
            try {
                InputStream inputStream = is;
                WbmpImageParser wbmpImageParser = this;
                int n = WbmpImageParser.readMultiByteInteger(inputStream);
                if (n != 0) {
                    throw new ImagingException("Invalid/unsupported WBMP type " + n);
                }
                int n2 = BinaryFunctions.readByte$74534d56(inputStream, "Invalid WBMP File");
                if ((n2 & 0x9F) != 0) {
                    throw new ImagingException("Invalid/unsupported WBMP FixHeaderField 0x" + Integer.toHexString(0xFF & n2));
                }
                int n3 = WbmpImageParser.readMultiByteInteger(inputStream);
                int n4 = WbmpImageParser.readMultiByteInteger(inputStream);
                WbmpHeader wbmpHeader = new WbmpHeader(n, (byte)n2, n3, n4);
                Object object2 = wbmpHeader;
                object = is;
                object2 = wbmpHeader;
                n2 = (wbmpHeader.width + 7) / 8;
                byte[] byArray = BinaryFunctions.readBytes("Pixels", (InputStream)object, n2 * ((WbmpHeader)object2).height, "Error reading image pixels");
                object = new DataBufferByte(byArray, byArray.length);
                object2 = Raster.createPackedRaster((DataBuffer)object, ((WbmpHeader)object2).width, ((WbmpHeader)object2).height, 1, null);
                object = new int[]{0, 0xFFFFFF};
                object = new IndexColorModel(1, 2, (int[])object, 0, false, -1, 0);
                object = new BufferedImage((ColorModel)object, (WritableRaster)object2, ((ColorModel)object).isAlphaPremultiplied(), new Properties());
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static int readMultiByteInteger(InputStream is) throws ImagingException, IOException {
        void var1_1;
        void var2_3;
        int value = 0;
        int totalBits = 0;
        do {
            byte nextByte = BinaryFunctions.readByte$74534d56(is, "Error reading WBMP header");
            value <<= 7;
            value |= nextByte & 0x7F;
            if ((totalBits += 7) <= 31) continue;
            throw new ImagingException("Overflow reading WBMP multi-byte field");
        } while ((var2_3 & 0x80) != 0);
        return (int)var1_1;
    }

    static final class WbmpHeader {
        final int typeField;
        final byte fixHeaderField;
        final int width;
        final int height;

        /*
         * WARNING - void declaration
         */
        WbmpHeader(int typeField, byte fixHeaderField, int width, int height) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.typeField = var1_1;
            this.fixHeaderField = var2_2;
            this.width = var3_3;
            this.height = height;
        }
    }
}

