/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public final class PhotometricInterpreterLogLuv
extends PhotometricInterpreter {
    /*
     * WARNING - void declaration
     */
    public PhotometricInterpreterLogLuv(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height) {
        super((int)var1_1, (int[])var2_2, (int)var3_3, width, height);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        void var2_8;
        void var3_9;
        void var1_1;
        if (samples == null || samples.length != 3) {
            throw new ImagingException("Invalid length of bits per sample (expected 3).");
        }
        int cieL4222 = samples[0];
        int cieA322 = samples[1];
        int cieB4222 = samples[2];
        int n = cieL4222;
        int n2 = cieA322;
        cieA322 = cieB4222;
        cieL4222 = n2;
        cieB4222 = n;
        float cieB4222 = ((float)n * 100.0f / 255.0f + 16.0f) / 116.0f;
        float f = (float)cieL4222 / 500.0f + cieB4222;
        float f2 = cieB4222 - (float)cieA322 / 200.0f;
        float cieL4222 = (float)Math.pow(f, 3.0);
        float cieA322 = (float)Math.pow(cieB4222, 3.0);
        float f3 = (float)Math.pow(f2, 3.0);
        cieB4222 = cieA322 > 0.008856f ? cieA322 : (cieB4222 - 0.13793103f) / 7.787f;
        f = cieL4222 > 0.008856f ? cieL4222 : (f - 0.13793103f) / 7.787f;
        f2 = f3 > 0.008856f ? f3 : (f2 - 0.13793103f) / 7.787f;
        TristimulusValues cieL4222 = new TristimulusValues();
        new TristimulusValues().x = 95.047f * f;
        cieL4222.y = 100.0f * cieB4222;
        cieL4222.z = 108.883f * f2;
        TristimulusValues tristimulusValues = cieL4222;
        TristimulusValues cieB4222 = tristimulusValues;
        cieB4222 = tristimulusValues;
        cieA322 = tristimulusValues.x / 100.0f;
        float cieL4222 = cieB4222.y / 100.0f;
        float cieB4222 = cieB4222.z / 100.0f;
        f = cieA322 * 3.2406f + cieL4222 * -1.5372f + cieB4222 * -0.4986f;
        f2 = cieA322 * -0.9689f + cieL4222 * 1.8758f + cieB4222 * 0.0415f;
        cieL4222 = cieA322 * 0.0557f + cieL4222 * -0.204f + cieB4222 * 1.057f;
        f = (double)f > 0.0031308 ? 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f : 12.92f * f;
        f2 = (double)f2 > 0.0031308 ? 1.055f * (float)Math.pow(f2, 0.4166666666666667) - 0.055f : 12.92f * f2;
        cieL4222 = (double)cieL4222 > 0.0031308 ? 1.055f * (float)Math.pow(cieL4222, 0.4166666666666667) - 0.055f : 12.92f * cieL4222;
        RgbValues cieA322 = new RgbValues();
        new RgbValues().r = (int)(f * 255.0f);
        cieA322.g = (int)(f2 * 255.0f);
        cieA322.b = (int)(cieL4222 * 255.0f);
        RgbValues rgbValues = cieA322;
        int red = Math.min(255, Math.max(0, rgbValues.r));
        int green = Math.min(255, Math.max(0, rgbValues.g));
        int blue = Math.min(255, Math.max(0, rgbValues.b));
        int rgb = 0xFF000000 | red << 16 | green << 8 | blue << 0;
        var1_1.setRgb((int)var3_9, y, (int)var2_8);
    }

    static final class TristimulusValues {
        public float x;
        public float y;
        public float z;

        TristimulusValues() {
        }
    }

    static final class RgbValues {
        public int r;
        public int g;
        public int b;

        RgbValues() {
        }
    }
}

