/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.FormatCompliance;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.tiff.AbstractTiffElement;
import org.apache.commons.imaging.formats.tiff.AbstractTiffImageData;
import org.apache.commons.imaging.formats.tiff.JpegImageData;
import org.apache.commons.imaging.formats.tiff.TiffContents;
import org.apache.commons.imaging.formats.tiff.TiffDirectory;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffHeader;
import org.apache.commons.imaging.formats.tiff.TiffImagingParameters;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.imaging.formats.tiff.constants.TiffTagConstants;
import org.apache.commons.imaging.formats.tiff.fieldtypes.AbstractFieldType;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfoDirectory;

public final class TiffReader
extends BinaryFileParser {
    private final boolean strict;
    private boolean bigTiff;
    private boolean standardTiff;
    private int entryMaxValueLength;

    /*
     * WARNING - void declaration
     */
    public TiffReader(boolean strict) {
        void var1_1;
        this.strict = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void read$73bdd89e(ByteSource byteSource, FormatCompliance formatCompliance, FirstDirectoryCollector listener) throws ImagingException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.readDirectories((ByteSource)var1_1, (FormatCompliance)var2_2, (Listener)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final TiffContents readDirectories(ByteSource byteSource, boolean readImageData, FormatCompliance formatCompliance) throws ImagingException, IOException {
        void var1_1;
        void var2_3;
        void var3_4;
        TiffImagingParameters params = new TiffImagingParameters();
        params.setReadThumbnails(true);
        Collector collector = new Collector(params);
        this.readDirectories(byteSource, (FormatCompliance)var3_4, collector);
        TiffContents contents = var2_3.getContents();
        if (contents.directories.isEmpty()) {
            throw new ImagingException("Image did not contain any directories.");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void readDirectories(ByteSource byteSource, FormatCompliance formatCompliance, Listener listener) throws ImagingException, IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        TiffHeader tiffHeader = this.readTiffHeader(byteSource);
        listener.setTiffHeader(tiffHeader);
        long offset = tiffHeader.offsetToFirstIFD;
        ArrayList<Number> visited = new ArrayList<Number>();
        this.readDirectory((ByteSource)var1_1, offset, 0, (FormatCompliance)var2_2, (Listener)var3_3, visited);
    }

    /*
     * WARNING - void declaration
     */
    private boolean readDirectory(ByteSource byteSource, long directoryOffset, int dirType, FormatCompliance formatCompliance, Listener listener, boolean ignoreNextDirectory, List<Number> visited) throws ImagingException, IOException {
        if (visited.contains(directoryOffset)) {
            return false;
        }
        visited.add(directoryOffset);
        try (InputStream is = byteSource.getInputStream();){
            void var2_2;
            long entryCount;
            if (directoryOffset >= byteSource.size()) {
                return true;
            }
            BinaryFunctions.skipBytes(is, directoryOffset);
            ArrayList<TiffField> fields = new ArrayList<TiffField>();
            try {
                entryCount = this.standardTiff ? (long)BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid TIFF File", this.getByteOrder()) : BinaryFunctions.read8Bytes$47efdc83(is, "Not a Valid TIFF File", this.getByteOrder());
            }
            catch (IOException e) {
                if (this.strict) {
                    throw e;
                }
                if (is != null) {
                    is.close();
                }
                return true;
            }
            int i = 0;
            while ((long)i < entryCount) {
                block39: {
                    byte[] value;
                    AbstractFieldType abstractFieldType;
                    long offset;
                    long count;
                    int tag;
                    block43: {
                        byte[] offsetBytes;
                        block41: {
                            long valueLength;
                            block42: {
                                tag = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid TIFF File", this.getByteOrder());
                                int type = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid TIFF File", this.getByteOrder());
                                if (this.standardTiff) {
                                    count = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid TIFF File", this.getByteOrder());
                                    offsetBytes = BinaryFunctions.readBytes("Offset", is, 4, "Not a Valid TIFF File");
                                    ByteOrder byteOrder = this.getByteOrder();
                                    byte[] byArray = offsetBytes;
                                    offset = 0xFFFFFFFFL & (long)ByteConversions.toInt(offsetBytes, 0, byteOrder);
                                } else {
                                    count = BinaryFunctions.read8Bytes$47efdc83(is, "Not a Valid TIFF File", this.getByteOrder());
                                    offsetBytes = BinaryFunctions.readBytes("Offset", is, 8, "Not a Valid TIFF File");
                                    offset = ByteConversions.toLong(offsetBytes, this.getByteOrder());
                                }
                                if (tag == 0) break block39;
                                try {
                                    abstractFieldType = AbstractFieldType.getFieldType(type);
                                }
                                catch (ImagingException imagingException) {
                                    break block39;
                                }
                                valueLength = count * (long)abstractFieldType.getSize();
                                if (valueLength <= (long)this.entryMaxValueLength) break block41;
                                if (offset >= 0L && offset + valueLength <= byteSource.size()) break block42;
                                if (this.strict) {
                                    throw new IOException("Attempt to read byte range starting from " + offset + " of length " + valueLength + " which is outside the file's size of " + byteSource.size());
                                }
                                break block39;
                            }
                            value = byteSource.getByteArray(offset, (int)valueLength);
                            break block43;
                        }
                        value = offsetBytes;
                    }
                    TiffField field = new TiffField(tag, dirType, abstractFieldType, count, offset, value, this.getByteOrder(), i);
                    fields.add(field);
                    listener.addField(field);
                }
                ++i;
            }
            long nextDirectoryOffset = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid TIFF File", this.getByteOrder());
            TiffDirectory directory = new TiffDirectory(dirType, fields, (long)var2_2, nextDirectoryOffset, this.getByteOrder());
            if (listener.readImageData()) {
                int n;
                Object object;
                if (directory.hasTiffImageData()) {
                    AbstractTiffImageData abstractTiffImageData;
                    TiffField tiffField;
                    object = directory;
                    ByteSource byteSource2 = byteSource;
                    List<TiffDirectory.ImageDataElement> list = ((TiffDirectory)object).getTiffRawImageDataElements();
                    AbstractTiffImageData.Data[] dataArray = new AbstractTiffImageData.Data[list.size()];
                    for (int j = 0; j < list.size(); ++j) {
                        TiffDirectory.ImageDataElement imageDataElement = list.get(j);
                        byte[] byArray = byteSource2.getByteArray(imageDataElement.offset, imageDataElement.length);
                        dataArray[j] = new AbstractTiffImageData.Data(imageDataElement.offset, imageDataElement.length, byArray);
                    }
                    if (((TiffDirectory)object).imageDataInStrips()) {
                        tiffField = ((TiffDirectory)object).findField(TiffTagConstants.TIFF_TAG_ROWS_PER_STRIP);
                        n = Integer.MAX_VALUE;
                        if (tiffField != null) {
                            n = tiffField.getIntValue();
                        } else {
                            TiffField tiffField2 = ((TiffDirectory)object).findField(TiffTagConstants.TIFF_TAG_IMAGE_LENGTH);
                            if (tiffField2 != null) {
                                n = tiffField2.getIntValue();
                            }
                        }
                        abstractTiffImageData = new AbstractTiffImageData.Strips(dataArray, n);
                    } else {
                        tiffField = ((TiffDirectory)object).findField(TiffTagConstants.TIFF_TAG_TILE_WIDTH);
                        if (tiffField == null) {
                            throw new ImagingException("Can't find tile width field.");
                        }
                        n = tiffField.getIntValue();
                        TiffField tiffField3 = ((TiffDirectory)object).findField(TiffTagConstants.TIFF_TAG_TILE_LENGTH);
                        if (tiffField3 == null) {
                            throw new ImagingException("Can't find tile length field.");
                        }
                        int n2 = tiffField3.getIntValue();
                        abstractTiffImageData = new AbstractTiffImageData.Tiles(dataArray, n, n2);
                    }
                    AbstractTiffImageData.Strips rawImageData = abstractTiffImageData;
                    directory.setTiffImageData(rawImageData);
                }
                if (directory.hasJpegImageData()) {
                    AbstractTiffElement abstractTiffElement = directory;
                    object = byteSource;
                    TiffReader tiffReader = this;
                    abstractTiffElement = abstractTiffElement.getJpegRawImageDataElement();
                    long l = ((TiffDirectory.ImageDataElement)abstractTiffElement).offset;
                    n = ((TiffDirectory.ImageDataElement)abstractTiffElement).length;
                    if (l + (long)n > ((ByteSource)object).size()) {
                        n = (int)(((ByteSource)object).size() - l);
                    }
                    byte[] byArray = ((ByteSource)object).getByteArray(l, n);
                    if (tiffReader.strict && (n < 2 || ((byArray[byArray.length - 2] & 0xFF) << 8 | byArray[byArray.length - 1] & 0xFF) != 65497)) {
                        throw new ImagingException("JPEG EOI marker could not be found at expected location");
                    }
                    JpegImageData rawJpegImageData = new JpegImageData(l, n, byArray);
                    directory.setJpegImageData(rawJpegImageData);
                }
            }
            if (!listener.addDirectory(directory)) {
                return true;
            }
            TagInfoDirectory[] offsetFields = new TagInfoDirectory[]{ExifTagConstants.EXIF_TAG_EXIF_OFFSET, ExifTagConstants.EXIF_TAG_GPSINFO, ExifTagConstants.EXIF_TAG_INTEROP_OFFSET};
            int[] directoryTypes = new int[]{-2, -3, -4};
            for (int i2 = 0; i2 < offsetFields.length; ++i2) {
                boolean subDirectoryRead;
                TiffField field;
                block40: {
                    TagInfoDirectory offsetField = offsetFields[i2];
                    field = directory.findField(offsetField);
                    if (field == null) continue;
                    subDirectoryRead = false;
                    try {
                        long subDirectoryOffset = directory.getFieldValue$611ae69c(offsetField);
                        int subDirectoryType = directoryTypes[i2];
                        subDirectoryRead = this.readDirectory(byteSource, subDirectoryOffset, subDirectoryType, formatCompliance, listener, true, visited);
                    }
                    catch (ImagingException imageReadException) {
                        if (!this.strict) break block40;
                        throw imageReadException;
                    }
                }
                if (subDirectoryRead) continue;
                fields.remove(field);
            }
            if (!ignoreNextDirectory && directory.getNextDirectoryOffset() > 0L) {
                void var1_1;
                this.readDirectory((ByteSource)var1_1, directory.getNextDirectoryOffset(), dirType + 1, formatCompliance, listener, visited);
            }
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean readDirectory(ByteSource byteSource, long offset, int dirType, FormatCompliance formatCompliance, Listener listener, List<Number> visited) throws ImagingException, IOException {
        void var2_2;
        void var1_1;
        return this.readDirectory((ByteSource)var1_1, (long)var2_2, dirType, formatCompliance, listener, false, visited);
    }

    /*
     * WARNING - void declaration
     */
    private TiffHeader readTiffHeader(ByteSource byteSource) throws ImagingException, IOException {
        Object object;
        block15: {
            InputStream is = byteSource.getInputStream();
            try {
                long l;
                ByteOrder byteOrder;
                InputStream inputStream = is;
                object = this;
                byte by = BinaryFunctions.readByte$74534d56(inputStream, "Not a Valid TIFF File");
                int n = BinaryFunctions.readByte$74534d56(inputStream, "Not a Valid TIFF File");
                if (by != n) {
                    throw new ImagingException("Byte Order bytes don't match (" + by + ", " + n + ").");
                }
                if (by == 73) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                } else if (by == 77) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else {
                    throw new ImagingException("Invalid TIFF byte order " + (0xFF & by));
                }
                ByteOrder byteOrder2 = byteOrder;
                ((BinaryFileParser)object).setByteOrder(byteOrder2);
                n = BinaryFunctions.read2Bytes$47efdc82(inputStream, "Not a Valid TIFF File", ((BinaryFileParser)object).getByteOrder());
                if (n == 42) {
                    ((TiffReader)object).bigTiff = false;
                    ((TiffReader)object).standardTiff = true;
                    ((TiffReader)object).entryMaxValueLength = 4;
                    l = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes$47efdc82(inputStream, "Not a Valid TIFF File", ((BinaryFileParser)object).getByteOrder());
                } else if (n == 43) {
                    ((TiffReader)object).bigTiff = true;
                    ((TiffReader)object).standardTiff = false;
                    ((TiffReader)object).entryMaxValueLength = 8;
                    int n2 = BinaryFunctions.read2Bytes$47efdc82(inputStream, "Not a Valid TIFF File", ((BinaryFileParser)object).getByteOrder());
                    int n3 = BinaryFunctions.read2Bytes$47efdc82(inputStream, "Not a Valid TIFF File", ((BinaryFileParser)object).getByteOrder());
                    if (n2 != 8 || n3 != 0) {
                        throw new ImagingException("Misformed Big-TIFF header: " + n);
                    }
                    l = BinaryFunctions.read8Bytes$47efdc83(inputStream, "Not a Valid TIFF File", ((BinaryFileParser)object).getByteOrder());
                } else {
                    throw new ImagingException("Unknown TIFF Version: " + n);
                }
                BinaryFunctions.skipBytes(inputStream, l - 8L, "Not a Valid TIFF File: couldn't find IFDs");
                object = new TiffHeader(byteOrder2, n, l, ((TiffReader)object).bigTiff);
                if (is == null) break block15;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return object;
    }

    public static interface Listener {
        public boolean addDirectory(TiffDirectory var1);

        public boolean addField(TiffField var1);

        public boolean readImageData();

        public boolean setTiffHeader(TiffHeader var1);
    }

    private static class Collector
    implements Listener {
        private TiffHeader tiffHeader;
        private final List<TiffDirectory> directories = new ArrayList<TiffDirectory>();
        private final List<TiffField> fields = new ArrayList<TiffField>();
        private final boolean readThumbnails;

        Collector() {
            this(new TiffImagingParameters());
        }

        /*
         * WARNING - void declaration
         */
        Collector(TiffImagingParameters params) {
            void var1_1;
            this.readThumbnails = var1_1.isReadThumbnails();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addDirectory(TiffDirectory directory) {
            void var1_1;
            this.directories.add((TiffDirectory)var1_1);
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addField(TiffField field) {
            void var1_1;
            this.fields.add((TiffField)var1_1);
            return true;
        }

        public final TiffContents getContents() {
            return new TiffContents(this.tiffHeader, this.directories, this.fields);
        }

        @Override
        public boolean readImageData() {
            return this.readThumbnails;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean setTiffHeader(TiffHeader tiffHeader) {
            void var1_1;
            this.tiffHeader = var1_1;
            return true;
        }
    }

    private static final class FirstDirectoryCollector
    extends Collector {
        private final boolean readImageData;

        /*
         * WARNING - void declaration
         */
        FirstDirectoryCollector(boolean readImageData) {
            void var1_1;
            this.readImageData = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean addDirectory(TiffDirectory directory) {
            void var1_1;
            super.addDirectory((TiffDirectory)var1_1);
            return false;
        }

        @Override
        public final boolean readImageData() {
            return this.readImageData;
        }
    }
}

