/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.rgbe;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.common.GenericImageMetadata;
import org.apache.commons.imaging.formats.rgbe.InfoHeaderReader;

final class RgbeInfo
implements Closeable {
    private static final byte[] HEADER = new byte[]{35, 63, 82, 65, 68, 73, 65, 78, 67, 69};
    private static final Pattern RESOLUTION_STRING = Pattern.compile("-Y (\\d+) \\+X (\\d+)");
    private static final byte[] TWO_TWO = new byte[]{2, 2};
    private final InputStream in;
    private GenericImageMetadata metadata;
    private int width = -1;
    private int height = -1;

    /*
     * WARNING - void declaration
     */
    RgbeInfo(ByteSource byteSource) throws IOException {
        void var1_1;
        this.in = var1_1.getInputStream();
    }

    @Override
    public final void close() throws IOException {
        this.in.close();
    }

    final int getHeight() throws IOException, ImagingException {
        if (-1 == this.height) {
            this.readDimensions();
        }
        return this.height;
    }

    private GenericImageMetadata getMetadata$2a4cf3ec() throws IOException, ImagingException {
        if (this.metadata == null) {
            RgbeInfo rgbeInfo = this;
            BinaryFunctions.readAndVerifyBytes(rgbeInfo.in, HEADER, "Not a valid HDR: Incorrect Header");
            InfoHeaderReader infoHeaderReader = new InfoHeaderReader(rgbeInfo.in);
            if (!infoHeaderReader.readNextLine().isEmpty()) {
                throw new ImagingException("Not a valid HDR: Incorrect Header");
            }
            rgbeInfo.metadata = new GenericImageMetadata();
            String string = infoHeaderReader.readNextLine();
            while (!string.isEmpty()) {
                int n = string.indexOf(61);
                if (n > 0) {
                    String string2 = string.substring(0, n);
                    if ("FORMAT".equals(string = string.substring(n + 1)) && !"32-bit_rle_rgbe".equals(string)) {
                        throw new ImagingException("Only 32-bit_rle_rgbe images are supported, trying to read " + string);
                    }
                    rgbeInfo.metadata.add(string2, string);
                } else {
                    rgbeInfo.metadata.add("<command>", string);
                }
                string = infoHeaderReader.readNextLine();
            }
        }
        return this.metadata;
    }

    public final float[][] getPixelData() throws IOException, ImagingException {
        int ht = this.getHeight();
        int wd = this.getWidth();
        if (wd >= 32768) {
            throw new ImagingException("Scan lines must be less than 32768 bytes long");
        }
        byte[] scanLineBytes = ByteConversions.toBytes((short)wd, ByteOrder.BIG_ENDIAN);
        byte[] rgbe = Allocator.byteArray(wd * 4);
        float[][] out = new float[3][Allocator.check(wd * ht)];
        for (int i = 0; i < ht; ++i) {
            BinaryFunctions.readAndVerifyBytes(this.in, TWO_TWO, "Scan line " + i + " expected to start with 0x2 0x2");
            BinaryFunctions.readAndVerifyBytes(this.in, scanLineBytes, "Scan line " + i + " length expected");
            byte[] byArray = rgbe;
            InputStream inputStream = this.in;
            int n = 0;
            int n2 = byArray.length;
            while (n < n2) {
                int n3;
                int n4 = inputStream.read();
                if (n4 < 0) {
                    throw new ImagingException("Error decompressing RGBE file");
                }
                if (n4 > 128) {
                    n3 = inputStream.read();
                    for (int j = 0; j < (n4 & 0x7F); ++j) {
                        byArray[n++] = (byte)n3;
                    }
                    continue;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    byArray[n++] = (byte)inputStream.read();
                }
            }
            for (int channel = 0; channel < 3; ++channel) {
                int channelOffset = channel * wd;
                int eOffset = 3 * wd;
                for (int p = 0; p < wd; ++p) {
                    int mantissa = rgbe[p + eOffset] & 0xFF;
                    int pos = p + i * wd;
                    if (mantissa == 0) {
                        out[channel][pos] = 0.0f;
                        continue;
                    }
                    float mult = (float)Math.pow(2.0, mantissa - 136);
                    out[channel][pos] = ((float)(rgbe[p + channelOffset] & 0xFF) + 0.5f) * mult;
                }
            }
        }
        return out;
    }

    final int getWidth() throws IOException, ImagingException {
        if (-1 == this.width) {
            this.readDimensions();
        }
        return this.width;
    }

    /*
     * WARNING - void declaration
     */
    private void readDimensions() throws IOException, ImagingException {
        void var2_2;
        this.getMetadata$2a4cf3ec();
        InfoHeaderReader infoHeaderReader = new InfoHeaderReader(this.in);
        String resolution = infoHeaderReader.readNextLine();
        Matcher matcher = RESOLUTION_STRING.matcher(resolution);
        if (!matcher.matches()) {
            throw new ImagingException("Invalid HDR resolution string. Only \"-Y N +X M\" is supported. Found \"" + (String)((Object)infoHeaderReader) + "\"");
        }
        this.height = Integer.parseInt(matcher.group(1));
        this.width = Integer.parseInt(var2_2.group(2));
    }
}

