/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.AbstractPngTextChunk;
import org.apache.commons.io.IOUtils;

public final class PngChunkZtxt
extends AbstractPngTextChunk {
    private final String keyword;
    private final String text;

    /*
     * WARNING - void declaration
     */
    public PngChunkZtxt(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        void var3_4;
        void var2_2;
        void var1_1;
        int index = BinaryFunctions.findNull(bytes, "PNG zTXt chunk keyword is unterminated.");
        this.keyword = new String(bytes, 0, index, StandardCharsets.ISO_8859_1);
        int n = ++index;
        ++index;
        byte compressionMethod = bytes[n];
        if (compressionMethod != 0) {
            throw new ImagingException("PNG zTXt chunk has unexpected compression method: " + compressionMethod);
        }
        int compressedTextLength = bytes.length - index;
        byte[] compressedText = Allocator.byteArray(compressedTextLength);
        System.arraycopy(bytes, (int)var1_1, compressedText, 0, (int)var2_2);
        this.text = new String(IOUtils.toByteArray((InputStream)new InflaterInputStream(new ByteArrayInputStream((byte[])var3_4))), StandardCharsets.ISO_8859_1);
    }
}

