/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.GammaCorrection;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public final class PngChunkPlte
extends PngChunk {
    private final int[] rgb;

    public PngChunkPlte(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        if (length % 3 != 0) {
            throw new ImagingException("PLTE: wrong length: " + length);
        }
        int count = length / 3;
        this.rgb = Allocator.intArray(count);
        for (int i = 0; i < count; ++i) {
            new StringBuilder("red[").append(i).append("]");
            byte red = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: PLTE Corrupt");
            new StringBuilder("green[").append(i).append("]");
            byte green = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: PLTE Corrupt");
            new StringBuilder("blue[").append(i).append("]");
            byte blue = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: PLTE Corrupt");
            this.rgb[i] = 0xFF000000 | (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void correct(GammaCorrection gammaCorrection) {
        void var1_1;
        Arrays.setAll(this.rgb, arg_0 -> this.lambda$correct$0((GammaCorrection)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final int getRgb(int index) throws ImagingException {
        void var1_1;
        if (index < 0 || index >= this.rgb.length) {
            throw new ImagingException("PNG: unknown Palette reference: " + index);
        }
        return this.rgb[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int lambda$correct$0(GammaCorrection gammaCorrection, int i) {
        void var2_2;
        return gammaCorrection.correctArgb(this.rgb[var2_2]);
    }
}

