/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.chunks.AbstractPngTextChunk;
import org.apache.commons.io.IOUtils;

public final class PngChunkItxt
extends AbstractPngTextChunk {
    private final String keyword;
    private final String text;
    private final String languageTag;
    private final String translatedKeyword;

    /*
     * WARNING - void declaration
     */
    public PngChunkItxt(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        void var2_2;
        int terminator = BinaryFunctions.findNull(bytes, "PNG iTXt chunk keyword is not terminated.");
        this.keyword = new String(bytes, 0, terminator, StandardCharsets.ISO_8859_1);
        int index = terminator + 1;
        byte compressionFlag = bytes[index++];
        if (compressionFlag != 0 && compressionFlag != 1) {
            throw new ImagingException("PNG iTXt chunk has invalid compression flag: " + compressionFlag);
        }
        boolean compressed = compressionFlag == 1;
        int compressionMethod = bytes[index++];
        if (compressed && compressionMethod != 0) {
            throw new ImagingException("PNG iTXt chunk has unexpected compression method: " + compressionMethod);
        }
        compressionMethod = BinaryFunctions.findNull(bytes, index, "PNG iTXt chunk language tag is not terminated.");
        this.languageTag = new String(bytes, index, compressionMethod - index, StandardCharsets.ISO_8859_1);
        index = compressionMethod + 1;
        compressionMethod = BinaryFunctions.findNull(bytes, index, "PNG iTXt chunk translated keyword is not terminated.");
        this.translatedKeyword = new String(bytes, index, compressionMethod - index, StandardCharsets.UTF_8);
        index = compressionMethod + 1;
        if (compressed) {
            void var3_4;
            void var1_1;
            int compressedTextLength = bytes.length - index;
            byte[] compressedText = Allocator.byteArray(compressedTextLength);
            System.arraycopy(bytes, index, compressedText, 0, (int)var1_1);
            this.text = new String(IOUtils.toByteArray((InputStream)new InflaterInputStream(new ByteArrayInputStream((byte[])var3_4))), StandardCharsets.UTF_8);
            return;
        }
        this.text = new String(bytes, index, bytes.length - var2_2, StandardCharsets.UTF_8);
    }
}

