/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.InterlaceMethod;
import org.apache.commons.imaging.formats.png.PngColorType;
import org.apache.commons.imaging.formats.png.chunks.PngChunk;

public final class PngChunkIhdr
extends PngChunk {
    private final int width;
    private final int height;
    private final int bitDepth;
    private final PngColorType pngColorType;
    private final int compressionMethod;
    private final int filterMethod;
    private final InterlaceMethod interlaceMethod;

    /*
     * WARNING - void declaration
     */
    public PngChunkIhdr(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, (int)var3_5, bytes);
        void var1_3;
        void var3_5;
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        this.width = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PNG File: IHDR Corrupt", this.getByteOrder());
        this.height = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid PNG File: IHDR Corrupt", this.getByteOrder());
        this.bitDepth = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: IHDR Corrupt");
        byte type = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: IHDR Corrupt");
        this.pngColorType = PngColorType.getColorType(type);
        PngChunkIhdr pngChunkIhdr = this;
        if (pngChunkIhdr.pngColorType == null) {
            void var2_4;
            throw new ImagingException("PNG: unknown color type: " + (int)var2_4);
        }
        this.compressionMethod = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: IHDR Corrupt");
        this.filterMethod = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: IHDR Corrupt");
        byte method = BinaryFunctions.readByte$74534d56(is, "Not a Valid PNG File: IHDR Corrupt");
        if (method < 0 || method >= InterlaceMethod.values().length) {
            throw new ImagingException("PNG: unknown interlace method: " + method);
        }
        this.interlaceMethod = InterlaceMethod.values()[var1_3];
    }

    public final int getBitDepth() {
        return this.bitDepth;
    }

    public final int getFilterMethod() {
        return this.filterMethod;
    }

    public final int getHeight() {
        return this.height;
    }

    public final InterlaceMethod getInterlaceMethod() {
        return this.interlaceMethod;
    }

    public final PngColorType getPngColorType() {
        return this.pngColorType;
    }

    public final int getWidth() {
        return this.width;
    }
}

