/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.util.logging.Level;
import java.util.logging.Logger;

public class GammaCorrection {
    private static final Logger LOGGER = Logger.getLogger(GammaCorrection.class.getName());
    private final int[] lookupTable;

    public GammaCorrection(double srcGamma, double dstGamma) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("srcGamma: " + srcGamma);
            LOGGER.finest("dstGamma: " + 1.0);
        }
        this.lookupTable = new int[256];
        for (int i = 0; i < 256; ++i) {
            double d = 1.0;
            double d2 = srcGamma;
            int n = i;
            this.lookupTable[n] = (int)Math.round(255.0 * Math.pow((double)n / 255.0, d2 / d));
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.finest("lookupTable[" + i + "]: " + this.lookupTable[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int correctArgb(int pixel) {
        void var1_1;
        void var3_3;
        void var2_2;
        int alpha = 0xFF000000 & pixel;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel >> 0 & 0xFF;
        int n = red;
        GammaCorrection gammaCorrection = this;
        red = gammaCorrection.lookupTable[n];
        n = green;
        gammaCorrection = this;
        green = gammaCorrection.lookupTable[n];
        n = blue;
        gammaCorrection = this;
        blue = gammaCorrection.lookupTable[n];
        return var2_2 | (0xFF & var3_3) << 16 | (0xFF & green) << 8 | (0xFF & var1_1) << 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int correctSample(int sample) {
        void var1_1;
        return this.lookupTable[var1_1];
    }
}

