/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.decoder;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.color.ColorConversions;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFileParser;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.ByteConversions;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.decoder.Block;
import org.apache.commons.imaging.formats.jpeg.decoder.Dct;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegInputStream;
import org.apache.commons.imaging.formats.jpeg.decoder.YCbCrConverter;
import org.apache.commons.imaging.formats.jpeg.decoder.ZigZag;
import org.apache.commons.imaging.formats.jpeg.segments.DhtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.DqtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.SofnSegment;
import org.apache.commons.imaging.formats.jpeg.segments.SosSegment;
import org.apache.commons.imaging.internal.Debug;
import org.apache.commons.io.IOUtils;

public final class JpegDecoder
extends BinaryFileParser
implements JpegUtils.Visitor {
    private static final int[] BAND_MASK_ARGB = new int[]{0xFF0000, 65280, 255, -16777216};
    private static final int[] BAND_MASK_RGB = new int[]{0xFF0000, 65280, 255};
    private final DqtSegment.QuantizationTable[] quantizationTables = new DqtSegment.QuantizationTable[4];
    private final DhtSegment.HuffmanTable[] huffmanDCTables = new DhtSegment.HuffmanTable[4];
    private final DhtSegment.HuffmanTable[] huffmanACTables = new DhtSegment.HuffmanTable[4];
    private SofnSegment sofnSegment;
    private SosSegment sosSegment;
    private final float[][] scaledQuantizationTables = new float[4][];
    private BufferedImage image;
    private ImagingException imageReadException;
    private IOException ioException;
    private final int[] zz = new int[64];
    private final int[] blockInt = new int[64];
    private final float[] block = new float[64];
    private boolean useTiffRgb;

    public final BufferedImage decode(ByteSource byteSource) throws IOException, ImagingException {
        JpegUtils jpegUtils;
        JpegUtils jpegUtils2 = new JpegUtils();
        Object object = jpegUtils2;
        JpegDecoder jpegDecoder = this;
        object = jpegUtils;
        jpegUtils = jpegUtils2;
        object = ((ByteSource)object).getInputStream();
        try {
            byte[] byArray;
            int n;
            BinaryFunctions.readAndVerifyBytes((InputStream)object, JpegConstants.SOI, "Not a Valid JPEG File: doesn't begin with 0xffd8");
            int n2 = 0;
            while (true) {
                byte[] byArray2;
                byArray2 = new byte[]{byArray2[1], BinaryFunctions.readByte$74534d56((InputStream)object, "Could not read marker")};
                while ((0xFF & byArray2[0]) != 255 || (0xFF & byArray2[1]) == 255) {
                }
                n = (0xFF & byArray2[0]) << 8 | 0xFF & byArray2[1];
                if (n == 65497 || n == 65498) break;
                byte[] byArray3 = BinaryFunctions.readBytes("segmentLengthBytes", (InputStream)object, 2, "segmentLengthBytes");
                byArray = byArray3;
                ByteOrder byteOrder = jpegUtils.getByteOrder();
                byArray = byArray3;
                int n3 = ByteConversions.toUInt16(byArray3, 0, byteOrder);
                if (n3 < 2) {
                    throw new ImagingException("Invalid segment size");
                }
                byArray = BinaryFunctions.readBytes("Segment Data", (InputStream)object, n3 - 2, "Invalid Segment: insufficient data");
                jpegDecoder.visitSegment$1dca8700(n, byArray);
                ++n2;
            }
            byArray = IOUtils.toByteArray((InputStream)object);
            jpegDecoder.visitSos$1014ad04(n, byArray);
            Debug.debug(n2 + " markers");
        }
        finally {
            if (object != null) {
                ((InputStream)object).close();
            }
        }
        if (this.imageReadException != null) {
            throw this.imageReadException;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        return this.image;
    }

    /*
     * WARNING - void declaration
     */
    private static int decode(JpegInputStream is2, DhtSegment.HuffmanTable huffmanTable) throws ImagingException {
        void var0_1;
        void var1_2;
        void var2_3;
        void var3_4;
        int i = 1;
        int code = is2.nextBit();
        while (code > huffmanTable.getMaxCode(i)) {
            ++i;
            code = code << 1 | is2.nextBit();
        }
        int is2 = huffmanTable.getValPtr(i);
        int j = is2 + (var3_4 - huffmanTable.getMinCode((int)var2_3));
        return var1_2.getHuffVal((int)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int extend(int v, int t) {
        int n;
        int vt = 1 << t - 1;
        if (v < vt) {
            void var2_2;
            void var1_1;
            vt = (-1 << var1_1) + 1;
            v += var2_2;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int receive(int ssss, JpegInputStream is) throws ImagingException {
        void var3_3;
        int v = 0;
        for (int i = 0; i != ssss; ++i) {
            v = (v << 1) + is.nextBit();
        }
        return (int)var3_3;
    }

    public final void setTiffRgb() {
        this.useTiffRgb = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean visitSegment$1dca8700(int marker2222, byte[] segmentData) throws ImagingException, IOException {
        block11: {
            void table22;
            void var1_1;
            int marker2222;
            block12: {
                block10: {
                    int[] nArray = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
                    if (Arrays.binarySearch(nArray, marker2222) < 0) break block10;
                    if (marker2222 != 65472) {
                        throw new ImagingException("Only sequential, baseline JPEGs are supported at the moment");
                    }
                    this.sofnSegment = new SofnSegment(marker2222, segmentData);
                    break block11;
                }
                if (marker2222 != 65499) break block12;
                DqtSegment marker2222 = new DqtSegment(marker2222, segmentData);
                for (DqtSegment.QuantizationTable table22 : marker2222.quantizationTables) {
                    if (table22.destinationIdentifier < 0 || table22.destinationIdentifier >= this.quantizationTables.length) {
                        throw new ImagingException("Invalid quantization table identifier " + table22.destinationIdentifier);
                    }
                    this.quantizationTables[table22.destinationIdentifier] = table22;
                    int[] quantizationMatrixInt = Allocator.intArray(64);
                    ZigZag.zigZagToBlock(table22.getElements(), quantizationMatrixInt);
                    float[] quantizationMatrixFloat = Allocator.floatArray(64);
                    for (int j = 0; j < 64; ++j) {
                        quantizationMatrixFloat[j] = quantizationMatrixInt[j];
                    }
                    Dct.scaleDequantizationMatrix(quantizationMatrixFloat);
                    this.scaledQuantizationTables[table22.destinationIdentifier] = quantizationMatrixFloat;
                }
                break block11;
            }
            if (marker2222 != 65476) break block11;
            DhtSegment dhtSegment = new DhtSegment((int)var1_1, (byte[])table22);
            for (DhtSegment.HuffmanTable table : dhtSegment.huffmanTables) {
                void var2_8;
                DhtSegment.HuffmanTable[] tables;
                if (table.tableClass == 0) {
                    tables = this.huffmanDCTables;
                } else if (table.tableClass == 1) {
                    tables = this.huffmanACTables;
                } else {
                    throw new ImagingException("Invalid huffman table class " + table.tableClass);
                }
                if (table.destinationIdentifier < 0 || table.destinationIdentifier >= tables.length) {
                    throw new ImagingException("Invalid huffman table identifier " + table.destinationIdentifier);
                }
                nArray[table.destinationIdentifier] = var2_8;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void visitSos$1014ad04(int marker, byte[] imageData) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(imageData);){
            Object object;
            int n;
            int n2;
            WritableRaster raster;
            DirectColorModel colorModel;
            JpegInputStream[] jpegInputStreamArray;
            int n3;
            int segmentLength = BinaryFunctions.read2Bytes$47efdc82(is, "Not a Valid JPEG File", this.getByteOrder());
            byte[] sosSegmentBytes = BinaryFunctions.readBytes("SosSegment", is, segmentLength - 2, "Not a Valid JPEG File");
            this.sosSegment = new SosSegment(marker, sosSegmentBytes);
            int[] scanPayload = Allocator.intArray(imageData.length - segmentLength);
            for (int payloadReadCount = 0; payloadReadCount < scanPayload.length; ++payloadReadCount) {
                scanPayload[payloadReadCount] = is.read();
            }
            int hMax = 0;
            int vMax = 0;
            for (int i2 = 0; i2 < this.sofnSegment.numberOfComponents; ++i2) {
                hMax = Math.max(hMax, this.sofnSegment.getComponents((int)i2).horizontalSamplingFactor);
                vMax = Math.max(vMax, this.sofnSegment.getComponents((int)i2).verticalSamplingFactor);
            }
            int hSize = 8 * hMax;
            int vSize = 8 * vMax;
            int xMCUs = (this.sofnSegment.width + hSize - 1) / hSize;
            int yMCUs = (this.sofnSegment.height + vSize - 1) / vSize;
            Block[] blockArray = this;
            Object object2 = (Block[])Allocator.array(blockArray.sosSegment.numberOfComponents, Block[]::new, 24);
            for (n3 = 0; n3 < blockArray.sosSegment.numberOfComponents; ++n3) {
                Block block;
                jpegInputStreamArray = blockArray.sosSegment.getComponents(n3);
                SofnSegment.Component component = null;
                for (int j = 0; j < blockArray.sofnSegment.numberOfComponents; ++j) {
                    if (blockArray.sofnSegment.getComponents((int)j).componentIdentifier != jpegInputStreamArray.scanComponentSelector) continue;
                    component = blockArray.sofnSegment.getComponents(j);
                    break;
                }
                if (component == null) {
                    throw new ImagingException("Invalid component");
                }
                object2[n3] = block = new Block(8 * component.horizontalSamplingFactor, 8 * component.verticalSamplingFactor);
            }
            Block[] mcu = object2;
            Block[] scaledMCU = (Block[])Allocator.array(((Block[])object2).length, Block[]::new, 24);
            Arrays.setAll(scaledMCU, i -> {
                void var1_1;
                int n;
                return new Block(n, (int)var1_1);
            });
            int[] preds = Allocator.intArray(this.sofnSegment.numberOfComponents);
            Allocator.check(4 * this.sofnSegment.width * this.sofnSegment.height);
            switch (this.sofnSegment.numberOfComponents) {
                case 4: {
                    if (this.useTiffRgb) {
                        colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
                        raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, BAND_MASK_ARGB, null);
                        break;
                    }
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, BAND_MASK_RGB, null);
                    break;
                }
                case 3: {
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
                    break;
                }
                case 1: {
                    colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    raster = Raster.createPackedRaster(3, this.sofnSegment.width, this.sofnSegment.height, new int[]{0xFF0000, 65280, 255}, null);
                    break;
                }
                default: {
                    throw new ImagingException(this.sofnSegment.numberOfComponents + " components are invalid or unsupported");
                }
            }
            DataBuffer dataBuffer = raster.getDataBuffer();
            blockArray = (Block[])scanPayload;
            int[] nArray = scanPayload;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(0);
            int n4 = 0;
            int n5 = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n4 != 0) {
                    if (nArray[n2] >= 208 && nArray[n2] <= 215) {
                        n5 = 1;
                    } else {
                        n4 = 0;
                    }
                }
                if (nArray[n2] == 255) {
                    n4 = 1;
                }
                if (n4 == 0 || n5 == 0) continue;
                arrayList.add(n2 + 1);
                n5 = 0;
                n4 = 0;
            }
            object2 = arrayList;
            n3 = object2.size();
            jpegInputStreamArray = (JpegInputStream[])Allocator.array(n3, JpegInputStream[]::new, 32);
            for (n = 0; n < n3; ++n) {
                int n6 = (Integer)object2.get(n);
                int n7 = n < n3 - 1 ? (Integer)object2.get(n + 1) - 2 : blockArray.length;
                object = Arrays.copyOfRange((int[])blockArray, n6, n7);
                jpegInputStreamArray[n] = new JpegInputStream((int[])object);
            }
            JpegInputStream[] bitInputStreams = jpegInputStreamArray;
            int bitInputStreamCount = 0;
            JpegInputStream bitInputStream = bitInputStreams[0];
            for (int y1 = 0; y1 < vSize * yMCUs; y1 += vSize) {
                for (int x1 = 0; x1 < hSize * xMCUs; x1 += hSize) {
                    int n8;
                    if (!bitInputStream.hasNext() && ++bitInputStreamCount < bitInputStreams.length) {
                        bitInputStream = bitInputStreams[bitInputStreamCount];
                    }
                    Block[] blockArray2 = mcu;
                    int[] nArray2 = preds;
                    object2 = bitInputStream;
                    blockArray = this;
                    for (n = 0; n < blockArray.sosSegment.numberOfComponents; ++n) {
                        SosSegment.Component component = blockArray.sosSegment.getComponents(n);
                        SofnSegment.Component component2 = null;
                        for (int j = 0; j < blockArray.sofnSegment.numberOfComponents; ++j) {
                            if (blockArray.sofnSegment.getComponents((int)j).componentIdentifier != component.scanComponentSelector) continue;
                            component2 = blockArray.sofnSegment.getComponents(j);
                            break;
                        }
                        if (component2 == null) {
                            throw new ImagingException("Invalid component");
                        }
                        object = blockArray2[n];
                        for (int j = 0; j < component2.verticalSamplingFactor; ++j) {
                            for (int k = 0; k < component2.horizontalSamplingFactor; ++k) {
                                int n9;
                                Arrays.fill(blockArray.zz, 0);
                                n4 = JpegDecoder.decode((JpegInputStream)object2, blockArray.huffmanDCTables[component.dcCodingTableSelector]);
                                n5 = JpegDecoder.receive(n4, (JpegInputStream)object2);
                                n5 = JpegDecoder.extend(n5, n4);
                                blockArray.zz[0] = nArray2[n] + n5;
                                nArray2[n] = blockArray.zz[0];
                                n2 = 1;
                                while (true) {
                                    n8 = JpegDecoder.decode((JpegInputStream)object2, blockArray.huffmanACTables[component.acCodingTableSelector]);
                                    n4 = n8 & 0xF;
                                    n9 = n5 = n8 >> 4;
                                    if (n4 == 0) {
                                        if (n9 != 15) break;
                                        n2 += 16;
                                        continue;
                                    }
                                    blockArray.zz[n2 += n9] = JpegDecoder.receive(n4, (JpegInputStream)object2);
                                    blockArray.zz[n2] = JpegDecoder.extend(blockArray.zz[n2], n4);
                                    if (n2 == 63) break;
                                    ++n2;
                                }
                                n8 = 1 << blockArray.sofnSegment.precision - 1;
                                n4 = (1 << blockArray.sofnSegment.precision) - 1;
                                float[] fArray = blockArray.scaledQuantizationTables[component2.quantTabDestSelector];
                                ZigZag.zigZagToBlock(blockArray.zz, blockArray.blockInt);
                                for (n9 = 0; n9 < 64; ++n9) {
                                    blockArray.block[n9] = (float)blockArray.blockInt[n9] * fArray[n9];
                                }
                                Dct.inverseDct8x8(blockArray.block);
                                n9 = 8 * j * 8 * component2.horizontalSamplingFactor + 8 * k;
                                n5 = 0;
                                for (n2 = 0; n2 < 8; ++n2) {
                                    for (int i3 = 0; i3 < 8; ++i3) {
                                        float f;
                                        float f2 = blockArray.block[n5++];
                                        f2 += (float)n8;
                                        int n10 = f < 0.0f ? 0 : (f2 > (float)n4 ? n4 : (int)(f2 + 0.5f));
                                        object.samples[n9 + i3] = n10;
                                    }
                                    n9 += 8 * component2.horizontalSamplingFactor;
                                }
                            }
                        }
                    }
                    blockArray2 = scaledMCU;
                    n3 = vSize;
                    int n11 = hSize;
                    blockArray = mcu;
                    for (int j = 0; j < blockArray.length; ++j) {
                        Block block = blockArray[j];
                        if (block.width == n11 && block.height == n3) {
                            System.arraycopy(block.samples, 0, blockArray2[j].samples, 0, n11 * n3);
                            continue;
                        }
                        int n12 = n11 / block.width;
                        int n13 = n3 / block.height;
                        if (n12 == 2 && n13 == 2) {
                            int n14 = 0;
                            n4 = 0;
                            for (n5 = 0; n5 < block.height; ++n5) {
                                for (n2 = 0; n2 < n11; ++n2) {
                                    blockArray2[j].samples[n4 + n2] = n8 = block.samples[n14 + (n2 >> 1)];
                                    blockArray2[j].samples[n4 + n11 + n2] = n8;
                                }
                                n14 += block.width;
                                n4 += 2 * n11;
                            }
                            continue;
                        }
                        int n15 = 0;
                        for (n4 = 0; n4 < n3; ++n4) {
                            for (n5 = 0; n5 < n11; ++n5) {
                                blockArray2[j].samples[n15 + n5] = block.samples[n4 / n13 * block.width + n5 / n12];
                            }
                            n15 += n11;
                        }
                    }
                    int srcRowOffset = 0;
                    int dstRowOffset = y1 * this.sofnSegment.width + x1;
                    if (this.useTiffRgb && (scaledMCU.length == 3 || scaledMCU.length == 4)) {
                        int x2;
                        int y2;
                        int x2Limit = x1 + hSize <= this.sofnSegment.width ? hSize : this.sofnSegment.width - x1;
                        int y2Limit = y1 + vSize <= this.sofnSegment.height ? vSize : this.sofnSegment.height - y1;
                        if (scaledMCU.length == 4) {
                            for (y2 = 0; y2 < y2Limit; ++y2) {
                                for (x2 = 0; x2 < x2Limit; ++x2) {
                                    int r = scaledMCU[0].samples[srcRowOffset + x2];
                                    int g = scaledMCU[1].samples[srcRowOffset + x2];
                                    int b = scaledMCU[2].samples[srcRowOffset + x2];
                                    int n16 = scaledMCU[3].samples[srcRowOffset + x2];
                                    int rgb = n16 << 24 | r << 16 | g << 8 | b;
                                    dataBuffer.setElem(dstRowOffset + x2, rgb);
                                }
                                srcRowOffset += hSize;
                                dstRowOffset += this.sofnSegment.width;
                            }
                            continue;
                        }
                        for (y2 = 0; y2 < y2Limit; ++y2) {
                            for (x2 = 0; x2 < x2Limit; ++x2) {
                                int r = scaledMCU[0].samples[srcRowOffset + x2];
                                int g = scaledMCU[1].samples[srcRowOffset + x2];
                                int b = scaledMCU[2].samples[srcRowOffset + x2];
                                int rgb = r << 16 | g << 8 | b;
                                dataBuffer.setElem(dstRowOffset + x2, rgb);
                            }
                            srcRowOffset += hSize;
                            dstRowOffset += this.sofnSegment.width;
                        }
                        continue;
                    }
                    for (int y2 = 0; y2 < vSize && y1 + y2 < this.sofnSegment.height; ++y2) {
                        for (int x2 = 0; x2 < hSize && x1 + x2 < this.sofnSegment.width; ++x2) {
                            int y;
                            if (scaledMCU.length == 4) {
                                int c = scaledMCU[0].samples[srcRowOffset + x2];
                                int m = scaledMCU[1].samples[srcRowOffset + x2];
                                int y3 = scaledMCU[2].samples[srcRowOffset + x2];
                                int k = scaledMCU[3].samples[srcRowOffset + x2];
                                int rgb = ColorConversions.convertCmykToRgb(c, m, y3, k);
                                dataBuffer.setElem(dstRowOffset + x2, rgb);
                                continue;
                            }
                            if (scaledMCU.length == 3) {
                                y = scaledMCU[0].samples[srcRowOffset + x2];
                                int cb = scaledMCU[1].samples[srcRowOffset + x2];
                                int cr = scaledMCU[2].samples[srcRowOffset + x2];
                                int rgb = YCbCrConverter.convertYCbCrToRgb(y, cb, cr);
                                dataBuffer.setElem(dstRowOffset + x2, rgb);
                                continue;
                            }
                            if (mcu.length == 1) {
                                y = scaledMCU[0].samples[srcRowOffset + x2];
                                dataBuffer.setElem(dstRowOffset + x2, y << 16 | y << 8 | y);
                                continue;
                            }
                            throw new ImagingException("Unsupported JPEG with " + mcu.length + " components");
                        }
                        srcRowOffset += hSize;
                        dstRowOffset += this.sofnSegment.width;
                    }
                }
            }
            this.image = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), new Properties());
        }
        catch (ImagingException imageReadEx) {
            this.imageReadException = imageReadEx;
            return;
        }
        catch (IOException ioEx) {
            this.ioException = ioEx;
            return;
        }
        catch (RuntimeException ex) {
            void var3_8;
            this.imageReadException = new ImagingException("Error parsing JPEG", (Throwable)var3_8);
        }
    }
}

