/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.dcx;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.bytesource.InputStreamByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.pcx.PcxImageParser;
import org.apache.commons.imaging.formats.pcx.PcxImagingParameters;

public final class DcxImageParser
extends AbstractImageParser<PcxImagingParameters> {
    private static final String DEFAULT_EXTENSION = ImageFormats.DCX.getDefaultExtension();
    private static final String[] ACCEPTED_EXTENSIONS = ImageFormats.DCX.getExtensions();

    public DcxImageParser() {
        super(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    protected final String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    protected final ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.DCX};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<BufferedImage> getAllBufferedImages(ByteSource byteSource) throws ImagingException, IOException {
        void var3_3;
        long[] lArray;
        DcxHeader dcxHeader = this.readDcxHeader(byteSource);
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        PcxImageParser pcxImageParser = new PcxImageParser();
        lArray = lArray.pageTable;
        int n = lArray.pageTable.length;
        for (int i = 0; i < n; ++i) {
            long element = lArray[i];
            try (InputStream stream = byteSource.getInputStream(element);){
                InputStreamByteSource pcxSource = ByteSource.inputStream$5d002322(stream, null);
                BufferedImage image = pcxImageParser.getBufferedImage((ByteSource)pcxSource, new PcxImagingParameters());
                images.add(image);
                continue;
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private DcxHeader readDcxHeader(ByteSource byteSource) throws ImagingException, IOException {
        DcxHeader dcxHeader;
        block8: {
            InputStream is = byteSource.getInputStream();
            try {
                void var2_3;
                void var3_5;
                long pageOffset;
                int id = BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid DCX File", this.getByteOrder());
                ArrayList pageTable = Allocator.arrayList(1024);
                for (int i = 0; i < 1024 && (pageOffset = 0xFFFFFFFFL & (long)BinaryFunctions.read4Bytes$47efdc82(is, "Not a Valid DCX File", this.getByteOrder())) != 0L; ++i) {
                    pageTable.add(pageOffset);
                }
                if (id != 987654321) {
                    throw new ImagingException("Not a Valid DCX File: file id incorrect");
                }
                if (pageTable.size() == 1024) {
                    throw new ImagingException("DCX page table not terminated by zero entry");
                }
                long[] pages = var3_5.stream().mapToLong(Long::longValue).toArray();
                dcxHeader = new DcxHeader((int)var2_3, pages);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            is.close();
        }
        return dcxHeader;
    }

    private static final class DcxHeader {
        public final int id;
        public final long[] pageTable;

        /*
         * WARNING - void declaration
         */
        DcxHeader(int id, long[] pageTable) {
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.pageTable = var2_2;
        }
    }
}

