/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryConstant;
import org.apache.commons.io.IOUtils;

public final class BinaryFunctions {
    private static final Logger LOGGER = Logger.getLogger(BinaryFunctions.class.getName());

    /*
     * WARNING - void declaration
     */
    public static int charsToQuad(char c1, char c2, char c3, char c4) {
        void var3_3;
        void var2_2;
        void var1_1;
        char c;
        return (0xFF & c) << 24 | (0xFF & var1_1) << 16 | (0xFF & var2_2) << 8 | (0xFF & var3_3) << 0;
    }

    public static boolean compareBytes(byte[] a, int aStart, byte[] b, int bStart, int length) {
        if (a.length < aStart + length) {
            return false;
        }
        if (b.length < 0 + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[aStart + i] == b[0 + i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static int findNull(byte[] src, int start, String message) throws ImagingException {
        void var2_2;
        for (int i = start; i < src.length; ++i) {
            if (src[i] != 0) continue;
            return i;
        }
        throw new ImagingException((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int findNull(byte[] src, String message) throws ImagingException {
        void var1_1;
        return BinaryFunctions.findNull(src, 0, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] head(byte[] bytes, int count) {
        void var1_3;
        byte[] byArray;
        if (count > bytes.length) {
            count = bytes.length;
        }
        boolean bl = false;
        byte[] byArray2 = byArray;
        byte[] byArray3 = Allocator.byteArray((int)var1_3);
        System.arraycopy(byArray2, 0, byArray3, 0, (int)var1_3);
        return byArray3;
    }

    /*
     * WARNING - void declaration
     */
    public static void logByteBits(String msg, byte i) {
        void var1_1;
        String string;
        LOGGER.finest(string + ": '" + Integer.toBinaryString(0xFF & var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static void logCharQuad(String msg, int i) {
        void var1_1;
        String string;
        LOGGER.finest(string + ": '" + (char)(0xFF & i >> 24) + (char)(0xFF & i >> 16) + (char)(0xFF & i >> 8) + (char)(0xFF & var1_1 >> 0) + "'");
    }

    /*
     * WARNING - void declaration
     */
    public static int read2Bytes$47efdc82(InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        void var0_1;
        void var3_4;
        int result;
        void var2_3;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read())) < 0) {
            void var1_2;
            throw new IOException((String)var1_2);
        }
        result = var2_3 == ByteOrder.BIG_ENDIAN ? byte0 << 8 | byte1 : result << 8 | var3_4;
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int read3Bytes$47efdc82(InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        void var0_1;
        void var3_4;
        int result;
        void var2_3;
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read())) < 0) {
            void var1_2;
            throw new IOException((String)var1_2);
        }
        result = var2_3 == ByteOrder.BIG_ENDIAN ? byte0 << 16 | byte1 << 8 | byte2 << 0 : result << 16 | byte1 << 8 | var3_4 << 0;
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int read4Bytes$47efdc82(InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        void var0_1;
        void var3_4;
        int result;
        void var2_3;
        int byte3;
        int byte2;
        int byte1;
        int byte0 = is.read();
        if ((byte0 | (byte1 = is.read()) | (byte2 = is.read()) | (byte3 = is.read())) < 0) {
            void var1_2;
            throw new IOException((String)var1_2);
        }
        result = var2_3 == ByteOrder.BIG_ENDIAN ? byte0 << 24 | byte1 << 16 | byte2 << 8 | byte3 << 0 : result << 24 | byte2 << 16 | byte1 << 8 | var3_4 << 0;
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static long read8Bytes$47efdc83(InputStream is, String exception, ByteOrder byteOrder) throws IOException {
        void var3_3;
        void var2_2;
        InputStream inputStream;
        long byte7;
        long byte6;
        long byte5;
        long byte4;
        long byte3;
        long byte2;
        long byte1;
        long byte0 = is.read();
        if ((byte0 | (byte1 = (long)is.read()) | (byte2 = (long)is.read()) | (byte3 = (long)is.read()) | (byte4 = (long)is.read()) | (byte5 = (long)is.read()) | (byte6 = (long)is.read()) | (byte7 = (long)inputStream.read())) < 0L) {
            void var1_1;
            throw new IOException((String)var1_1);
        }
        long result = var2_2 == ByteOrder.BIG_ENDIAN ? byte0 << 56 | byte1 << 48 | byte2 << 40 | byte3 << 32 | byte4 << 24 | byte5 << 16 | byte6 << 8 | byte7 << 0 : byte7 << 56 | byte6 << 48 | byte5 << 40 | byte4 << 32 | byte3 << 24 | byte2 << 16 | byte1 << 8 | var3_3 << 0;
        return result;
    }

    public static void readAndVerifyBytes(InputStream is, BinaryConstant expected, String exception) throws ImagingException, IOException {
        for (int i = 0; i < expected.size(); ++i) {
            int data = is.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImagingException("Unexpected EOF.");
            }
            if (b == expected.get(i)) continue;
            throw new ImagingException(exception);
        }
    }

    public static void readAndVerifyBytes(InputStream is, byte[] expected, String exception) throws ImagingException, IOException {
        byte[] byArray = expected;
        int n = expected.length;
        for (int i = 0; i < n; ++i) {
            byte element = byArray[i];
            int data = is.read();
            byte b = (byte)(0xFF & data);
            if (data < 0) {
                throw new ImagingException("Unexpected EOF.");
            }
            if (b == element) continue;
            throw new ImagingException(exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static byte readByte$74534d56(InputStream is, String exceptionMessage) throws IOException {
        void var0_1;
        int result = is.read();
        if (result < 0) {
            void var1_2;
            throw new IOException((String)var1_2);
        }
        return (byte)(0xFF & var0_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(String name, InputStream is, int length) throws IOException {
        String string;
        void var2_2;
        void var1_1;
        return BinaryFunctions.readBytes(name, (InputStream)var1_1, (int)var2_2, string + " could not be read.");
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] readBytes(String name, InputStream is, int length, String exception) throws IOException {
        try {
            return IOUtils.toByteArray((InputStream)is, (int)Allocator.check(length));
        }
        catch (IOException iOException) {
            void var2_2;
            String string;
            void var3_3;
            throw new IOException((String)var3_3 + ", name: " + string + ", length: " + (int)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long skipBytes(InputStream is, long length) throws IOException {
        void var1_1;
        return BinaryFunctions.skipBytes(is, (long)var1_1, "Couldn't skip bytes");
    }

    /*
     * WARNING - void declaration
     */
    public static long skipBytes(InputStream is, long length, String exception) throws IOException {
        try {
            void var1_2;
            return IOUtils.skip((InputStream)is, (long)var1_2);
        }
        catch (IOException e) {
            void var0_1;
            void var3_3;
            throw new IOException((String)var3_3, (Throwable)var0_1);
        }
    }

    private BinaryFunctions() {
    }
}

