/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.color;

import org.apache.commons.imaging.color.ColorCmy;

public final class ColorConversions {
    /*
     * WARNING - void declaration
     */
    public static int convertCieLabToArgbTest(int cieL, int cieA, int cieB) {
        void var3_6;
        void var2_2;
        void var1_1;
        double varY = ((double)cieL * 100.0 / 255.0 + 16.0) / 116.0;
        double varX = (double)var1_1 / 500.0 + varY;
        double varZ = varY - (double)var2_2 / 200.0;
        varX = ColorConversions.unPivotXyz(varX);
        varY = ColorConversions.unPivotXyz(varY);
        varZ = ColorConversions.unPivotXyz(varZ);
        double x = 95.047 * varX;
        double y = 100.0 * varY;
        double z = 108.883 * varZ;
        void varX2 = var3_6 / 100.0;
        double varY2 = y / 100.0;
        double varZ2 = z / 100.0;
        double varR = varX2 * 3.2406 + varY2 * -1.5372 + varZ2 * -0.4986;
        double varG = varX2 * -0.9689 + varY2 * 1.8758 + varZ2 * 0.0415;
        double varB = varX2 * 0.0557 + varY2 * -0.204 + varZ2 * 1.057;
        varR = ColorConversions.pivotRgb(varR);
        varG = ColorConversions.pivotRgb(varG);
        varB = ColorConversions.pivotRgb(varB);
        double r = varR * 255.0;
        double g = varG * 255.0;
        double b = varB * 255.0;
        return ColorConversions.convertRgbToRgb(r, g, b);
    }

    /*
     * WARNING - void declaration
     */
    public static int convertCmykToRgb(int c, int m, int y, int k) {
        void var3_3;
        double K;
        void var2_2;
        void var1_1;
        double C = (double)c / 255.0;
        double M = (double)var1_1 / 255.0;
        double Y = (double)var2_2 / 255.0;
        double d = K = (double)var3_3 / 255.0;
        double d2 = Y;
        double d3 = M;
        double d4 = C;
        d4 = d4 * (1.0 - d) + d;
        d3 = d3 * (1.0 - d) + d;
        d2 = d2 * (1.0 - d) + d;
        ColorCmy colorCmy = new ColorCmy(d4, d3, d2);
        double d5 = (1.0 - colorCmy.c) * 255.0;
        double d6 = (1.0 - colorCmy.m) * 255.0;
        double d7 = (1.0 - colorCmy.y) * 255.0;
        return ColorConversions.convertRgbToRgb(d5, d6, d7);
    }

    /*
     * WARNING - void declaration
     */
    private static int convertRgbToRgb(double r, double g, double b) {
        void var2_4;
        void var1_5;
        void var0_1;
        int red = (int)Math.round(r);
        int green = (int)Math.round(g);
        int blue = (int)Math.round(b);
        red = Math.min(255, Math.max(0, red));
        green = Math.min(255, Math.max(0, green));
        blue = Math.min(255, Math.max(0, blue));
        return 0xFF000000 | var0_1 << 16 | var1_5 << 8 | var2_4 << 0;
    }

    private static double pivotRgb(double n) {
        double d;
        n = n > 0.0031308 ? 1.055 * Math.pow(n, 0.4166666666666667) - 0.055 : 12.92 * n;
        return d;
    }

    private static double unPivotXyz(double n) {
        double d;
        double d2;
        double d3;
        double nCube = Math.pow(n, 3.0);
        n = d3 > 0.008856 ? d2 : (n - 0.13793103448275862) / 7.787037;
        return d;
    }
}

