/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.bytesource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.build.AbstractOrigin;

final class InputStreamByteSource
extends ByteSource {
    private final InputStream inputStream;
    private Block headBlock;
    private byte[] readBuffer;
    private long streamLength = -1L;

    /*
     * WARNING - void declaration
     */
    InputStreamByteSource(InputStream inputStream, String fileName) {
        super((AbstractOrigin<?, ?>)new AbstractOrigin.InputStreamOrigin(inputStream), (String)var2_2);
        void var1_1;
        void var2_2;
        this.inputStream = new BufferedInputStream((InputStream)var1_1);
    }

    @Override
    public final byte[] getByteArray(long position, int length) throws IOException {
        int read;
        if (position < 0L || length < 0 || position + (long)length < 0L || position + (long)length > ((ByteSource)this).size()) {
            throw new ImagingException("Could not read block (block start: " + position + ", block length: " + length + ", data length: " + this.streamLength + ").");
        }
        InputStream cis = ((ByteSource)this).getInputStream();
        BinaryFunctions.skipBytes(cis, position);
        byte[] bytes = Allocator.byteArray(length);
        int total = 0;
        do {
            if ((read = cis.read(bytes, total, bytes.length - total)) > 0) continue;
            throw new ImagingException("Could not read block.");
        } while ((total += read) < length);
        return bytes;
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        return new BlockInputStream(0);
    }

    /*
     * WARNING - void declaration
     */
    private Block readBlock() throws IOException {
        void var1_2;
        int read;
        if (this.readBuffer == null) {
            this.readBuffer = new byte[1024];
        }
        if ((read = this.inputStream.read(this.readBuffer)) <= 0) {
            return null;
        }
        if (read < 1024) {
            InputStreamByteSource inputStreamByteSource = this;
            return inputStreamByteSource.new Block(Arrays.copyOf(inputStreamByteSource.readBuffer, read));
        }
        byte[] result = this.readBuffer;
        this.readBuffer = null;
        return new Block((byte[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long size() throws IOException {
        void var4_4;
        block6: {
            if (this.streamLength >= 0L) {
                return this.streamLength;
            }
            InputStream cis = ((ByteSource)this).getInputStream();
            try {
                void var2_2;
                long result;
                this.streamLength = result = IOUtils.consume((InputStream)cis);
                var4_4 = var2_2;
                if (cis == null) break block6;
            }
            catch (Throwable throwable) {
                if (cis != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            cis.close();
        }
        return (long)var4_4;
    }

    static /* synthetic */ Block access$100(InputStreamByteSource x0) throws IOException {
        InputStreamByteSource inputStreamByteSource = x0;
        if (inputStreamByteSource.headBlock == null) {
            inputStreamByteSource.headBlock = inputStreamByteSource.readBlock();
        }
        return inputStreamByteSource.headBlock;
    }

    private final class Block {
        public final byte[] bytes;
        private Block next;
        private boolean triedNext;

        /*
         * WARNING - void declaration
         */
        Block(byte[] bytes) {
            void var2_2;
            this.bytes = var2_2;
        }

        public final Block getNext() throws IOException {
            if (this.next != null) {
                return this.next;
            }
            if (this.triedNext) {
                return null;
            }
            this.triedNext = true;
            this.next = InputStreamByteSource.this.readBlock();
            return this.next;
        }
    }

    private final class BlockInputStream
    extends InputStream {
        private Block block;
        private boolean readFirst;
        private int blockIndex;

        private BlockInputStream() {
        }

        @Override
        public final int read() throws IOException {
            if (this.block == null) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.access$100(InputStreamByteSource.this);
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (this.block == null) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            return 0xFF & this.block.bytes[this.blockIndex++];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int read(byte[] array, int off, int len) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Objects.requireNonNull(array, "array");
            if (off < 0 || off > array.length || len < 0 || off + len > array.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.block == null) {
                if (this.readFirst) {
                    return -1;
                }
                this.block = InputStreamByteSource.access$100(InputStreamByteSource.this);
                this.readFirst = true;
            }
            if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                this.block = this.block.getNext();
                this.blockIndex = 0;
            }
            if (this.block == null) {
                return -1;
            }
            if (this.blockIndex >= this.block.bytes.length) {
                return -1;
            }
            int readSize = Math.min(len, this.block.bytes.length - this.blockIndex);
            System.arraycopy(this.block.bytes, this.blockIndex, var1_1, (int)var2_2, readSize);
            this.blockIndex += readSize;
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long skip(long n) throws IOException {
            void var3_2;
            void var1_1;
            int readSize;
            if (n <= 0L) {
                return 0L;
            }
            for (long remaining = n; remaining > 0L; remaining -= (long)readSize) {
                if (this.block == null) {
                    if (this.readFirst) {
                        return -1L;
                    }
                    this.block = InputStreamByteSource.access$100(InputStreamByteSource.this);
                    this.readFirst = true;
                }
                if (this.block != null && this.blockIndex >= this.block.bytes.length) {
                    this.block = this.block.getNext();
                    this.blockIndex = 0;
                }
                if (this.block == null || this.blockIndex >= this.block.bytes.length) break;
                readSize = Math.min((int)Math.min(1024L, remaining), this.block.bytes.length - this.blockIndex);
                this.blockIndex += readSize;
            }
            return (long)(var1_1 - var3_2);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ BlockInputStream(byte by) {
            this();
            void var1_1;
        }
    }
}

