/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.imaging.AbstractImageParser;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.internal.ImageParserFactory;

public final class Imaging {
    private static final int[] MAGIC_NUMBERS_GIF = new int[]{71, 73};
    private static final int[] MAGIC_NUMBERS_PNG = new int[]{137, 80};
    private static final int[] MAGIC_NUMBERS_JPEG = new int[]{255, 216};
    private static final int[] MAGIC_NUMBERS_BMP = new int[]{66, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_MOTOROLA = new int[]{77, 77};
    private static final int[] MAGIC_NUMBERS_TIFF_INTEL = new int[]{73, 73};
    private static final int[] MAGIC_NUMBERS_PAM = new int[]{80, 55};
    private static final int[] MAGIC_NUMBERS_PSD = new int[]{56, 66};
    private static final int[] MAGIC_NUMBERS_PBM_A = new int[]{80, 49};
    private static final int[] MAGIC_NUMBERS_PBM_B = new int[]{80, 52};
    private static final int[] MAGIC_NUMBERS_PGM_A = new int[]{80, 50};
    private static final int[] MAGIC_NUMBERS_PGM_B = new int[]{80, 53};
    private static final int[] MAGIC_NUMBERS_PPM_A = new int[]{80, 51};
    private static final int[] MAGIC_NUMBERS_PPM_B = new int[]{80, 54};
    private static final int[] MAGIC_NUMBERS_JBIG2_1 = new int[]{151, 74};
    private static final int[] MAGIC_NUMBERS_JBIG2_2 = new int[]{66, 50};
    private static final int[] MAGIC_NUMBERS_ICNS = new int[]{105, 99};
    private static final int[] MAGIC_NUMBERS_DCX = new int[]{177, 104};
    private static final int[] MAGIC_NUMBERS_RGBE = new int[]{35, 63};
    private static final int[] MAGIC_NUMBERS_RIFF_1 = new int[]{82, 73};
    private static final int[] MAGIC_NUMBERS_RIFF_2 = new int[]{70, 70};
    private static final byte[] MAGIC_NUMBERS_WEBP = new byte[]{87, 69, 66, 80};

    /*
     * WARNING - void declaration
     */
    private static boolean compareBytePair(int[] a, int[] b) {
        void var1_1;
        int[] nArray;
        if (a.length != 2) {
            int cfr_ignored_0 = b.length;
        }
        return a[0] == b[0] && nArray[1] == var1_1[1];
    }

    public static BufferedImage getBufferedImage(byte[] bytes) throws ImagingException, IOException {
        AbstractImageParser<Object> abstractImageParser;
        ByteSource byteSource = ByteSource.array(bytes);
        Object object = byteSource;
        AbstractImageParser<Object> abstractImageParser2 = byteSource;
        ImageFormat imageFormat = Imaging.guessFormat(byteSource);
        if (!imageFormat.equals(ImageFormats.UNKNOWN)) {
            abstractImageParser = ImageParserFactory.getImageParser(imageFormat);
        } else if ((abstractImageParser2 = ((ByteSource)((Object)abstractImageParser2)).getFileName()) != null) {
            abstractImageParser = ImageParserFactory.getImageParser(abstractImageParser2);
        } else {
            throw new IllegalArgumentException("Can't parse this format.");
        }
        abstractImageParser2 = abstractImageParser;
        return abstractImageParser.getBufferedImage((ByteSource)object, null);
    }

    public static ImageFormat guessFormat(byte[] bytes) throws IOException {
        return Imaging.guessFormat(ByteSource.array(bytes));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static ImageFormat guessFormat(ByteSource byteSource) throws IOException {
        block67: {
            block59: {
                block66: {
                    block64: {
                        block65: {
                            block62: {
                                block63: {
                                    block60: {
                                        block61: {
                                            block57: {
                                                block58: {
                                                    block55: {
                                                        block56: {
                                                            block53: {
                                                                block54: {
                                                                    block51: {
                                                                        block52: {
                                                                            block49: {
                                                                                block50: {
                                                                                    block47: {
                                                                                        block48: {
                                                                                            block45: {
                                                                                                block46: {
                                                                                                    block43: {
                                                                                                        block44: {
                                                                                                            block41: {
                                                                                                                block42: {
                                                                                                                    block39: {
                                                                                                                        block40: {
                                                                                                                            block37: {
                                                                                                                                block38: {
                                                                                                                                    block35: {
                                                                                                                                        block36: {
                                                                                                                                            block33: {
                                                                                                                                                block34: {
                                                                                                                                                    block31: {
                                                                                                                                                        block32: {
                                                                                                                                                            block29: {
                                                                                                                                                                block30: {
                                                                                                                                                                    if (byteSource == null) {
                                                                                                                                                                        return ImageFormats.UNKNOWN;
                                                                                                                                                                    }
                                                                                                                                                                    is = byteSource.getInputStream();
                                                                                                                                                                    try {
                                                                                                                                                                        i1 = is.read();
                                                                                                                                                                        i2 = is.read();
                                                                                                                                                                        if (i1 < 0 || i2 < 0) {
                                                                                                                                                                            throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                                                                                                                                                                        }
                                                                                                                                                                        b1 = i1 & 255;
                                                                                                                                                                        b2 = i2 & 255;
                                                                                                                                                                        bytePair /* !! */  = new int[]{b1, b2};
                                                                                                                                                                        if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_GIF, bytePair /* !! */ )) break block29;
                                                                                                                                                                        bytePair /* !! */  = (int[])ImageFormats.GIF;
                                                                                                                                                                        if (is == null) break block30;
                                                                                                                                                                    }
                                                                                                                                                                    catch (Throwable var2_6) {
                                                                                                                                                                        if (is != null) {
                                                                                                                                                                            try {
                                                                                                                                                                                var1_1.close();
                                                                                                                                                                            }
                                                                                                                                                                            catch (Throwable var3_8) {
                                                                                                                                                                                var2_6.addSuppressed(var3_8);
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                        throw var2_6;
                                                                                                                                                                    }
                                                                                                                                                                    is.close();
                                                                                                                                                                }
                                                                                                                                                                return bytePair /* !! */ ;
                                                                                                                                                            }
                                                                                                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PNG, bytePair /* !! */ )) break block31;
                                                                                                                                                            bytePair /* !! */  = (int[])ImageFormats.PNG;
                                                                                                                                                            if (is == null) break block32;
                                                                                                                                                            is.close();
                                                                                                                                                        }
                                                                                                                                                        return bytePair /* !! */ ;
                                                                                                                                                    }
                                                                                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JPEG, bytePair /* !! */ )) break block33;
                                                                                                                                                    bytePair /* !! */  = (int[])ImageFormats.JPEG;
                                                                                                                                                    if (is == null) break block34;
                                                                                                                                                    is.close();
                                                                                                                                                }
                                                                                                                                                return bytePair /* !! */ ;
                                                                                                                                            }
                                                                                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_BMP, bytePair /* !! */ )) break block35;
                                                                                                                                            bytePair /* !! */  = (int[])ImageFormats.BMP;
                                                                                                                                            if (is == null) break block36;
                                                                                                                                            is.close();
                                                                                                                                        }
                                                                                                                                        return bytePair /* !! */ ;
                                                                                                                                    }
                                                                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_TIFF_MOTOROLA, bytePair /* !! */ )) break block37;
                                                                                                                                    bytePair /* !! */  = (int[])ImageFormats.TIFF;
                                                                                                                                    if (is == null) break block38;
                                                                                                                                    is.close();
                                                                                                                                }
                                                                                                                                return bytePair /* !! */ ;
                                                                                                                            }
                                                                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_TIFF_INTEL, bytePair /* !! */ )) break block39;
                                                                                                                            bytePair /* !! */  = (int[])ImageFormats.TIFF;
                                                                                                                            if (is == null) break block40;
                                                                                                                            is.close();
                                                                                                                        }
                                                                                                                        return bytePair /* !! */ ;
                                                                                                                    }
                                                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PSD, bytePair /* !! */ )) break block41;
                                                                                                                    bytePair /* !! */  = (int[])ImageFormats.PSD;
                                                                                                                    if (is == null) break block42;
                                                                                                                    is.close();
                                                                                                                }
                                                                                                                return bytePair /* !! */ ;
                                                                                                            }
                                                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PAM, bytePair /* !! */ )) break block43;
                                                                                                            bytePair /* !! */  = (int[])ImageFormats.PAM;
                                                                                                            if (is == null) break block44;
                                                                                                            is.close();
                                                                                                        }
                                                                                                        return bytePair /* !! */ ;
                                                                                                    }
                                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PBM_A, bytePair /* !! */ )) break block45;
                                                                                                    bytePair /* !! */  = (int[])ImageFormats.PBM;
                                                                                                    if (is == null) break block46;
                                                                                                    is.close();
                                                                                                }
                                                                                                return bytePair /* !! */ ;
                                                                                            }
                                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PBM_B, bytePair /* !! */ )) break block47;
                                                                                            bytePair /* !! */  = (int[])ImageFormats.PBM;
                                                                                            if (is == null) break block48;
                                                                                            is.close();
                                                                                        }
                                                                                        return bytePair /* !! */ ;
                                                                                    }
                                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PGM_A, bytePair /* !! */ )) break block49;
                                                                                    bytePair /* !! */  = (int[])ImageFormats.PGM;
                                                                                    if (is == null) break block50;
                                                                                    is.close();
                                                                                }
                                                                                return bytePair /* !! */ ;
                                                                            }
                                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PGM_B, bytePair /* !! */ )) break block51;
                                                                            bytePair /* !! */  = (int[])ImageFormats.PGM;
                                                                            if (is == null) break block52;
                                                                            is.close();
                                                                        }
                                                                        return bytePair /* !! */ ;
                                                                    }
                                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PPM_A, bytePair /* !! */ )) break block53;
                                                                    bytePair /* !! */  = (int[])ImageFormats.PPM;
                                                                    if (is == null) break block54;
                                                                    is.close();
                                                                }
                                                                return bytePair /* !! */ ;
                                                            }
                                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_PPM_B, bytePair /* !! */ )) break block55;
                                                            bytePair /* !! */  = (int[])ImageFormats.PPM;
                                                            if (is == null) break block56;
                                                            is.close();
                                                        }
                                                        return bytePair /* !! */ ;
                                                    }
                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JBIG2_1, bytePair /* !! */ )) ** GOTO lbl149
                                                    i3 = is.read();
                                                    i4 = is.read();
                                                    if (i3 < 0 || i4 < 0) {
                                                        throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                                                    }
                                                    b3 = i3 & 255;
                                                    b4 = i4 & 255;
                                                    bytePair2 = new int[]{b3, b4};
                                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_JBIG2_2, (int[])bytePair2)) break block57;
                                                    bytePair2 = ImageFormats.JBIG2;
                                                    if (is == null) break block58;
                                                    is.close();
                                                }
                                                return bytePair2;
                                            }
                                            break block59;
lbl149:
                                            // 1 sources

                                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_ICNS, (int[])bytePair2)) break block60;
                                            bytePair2 = ImageFormats.ICNS;
                                            if (is == null) break block61;
                                            is.close();
                                        }
                                        return bytePair2;
                                    }
                                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_DCX, (int[])bytePair2)) break block62;
                                    bytePair2 = ImageFormats.DCX;
                                    if (is == null) break block63;
                                    is.close();
                                }
                                return bytePair2;
                            }
                            if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_RGBE, (int[])bytePair2)) break block64;
                            bytePair2 = ImageFormats.RGBE;
                            if (is == null) break block65;
                            is.close();
                        }
                        return bytePair2;
                    }
                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_RIFF_1, (int[])bytePair2)) break block59;
                    i3 = is.read();
                    i4 = is.read();
                    if (i3 < 0 || i4 < 0) {
                        throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                    }
                    b3 = i3 & 255;
                    b4 = i4 & 255;
                    bytePair2 = new int[]{b3, var3_7};
                    if (!Imaging.compareBytePair(Imaging.MAGIC_NUMBERS_RIFF_2, (int[])bytePair2)) break block59;
                    bytes = new byte[4];
                    if (is.read(bytes) < 4) {
                        throw new IllegalArgumentException("Couldn't read magic numbers to guess format.");
                    }
                    if (is.read(bytes) != 4 || !Arrays.equals(Imaging.MAGIC_NUMBERS_WEBP, (byte[])var2_3)) break block59;
                    byteSource = ImageFormats.WEBP;
                    if (is == null) break block66;
                    is.close();
                }
                return byteSource;
            }
            var2_3 = Stream.of(ImageFormats.values()).filter((Predicate<ImageFormats>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$guessFormat$1(org.apache.commons.imaging.bytesource.ByteSource org.apache.commons.imaging.ImageFormats ), (Lorg/apache/commons/imaging/ImageFormats;)Z)((ByteSource)var0)).findFirst().orElse(ImageFormats.UNKNOWN);
            if (is == null) break block67;
            is.close();
        }
        return var2_3;
    }

    private static /* synthetic */ boolean lambda$guessFormat$1(ByteSource byteSource, ImageFormats imageFormat) {
        ByteSource byteSource2;
        return Stream.of(imageFormat.getExtensions()).anyMatch(extension -> {
            void var1_1;
            String string;
            String fileName = byteSource2.getFileName();
            if (fileName == null || fileName.trim().isEmpty()) {
                return false;
            }
            Object object = fileName;
            String fileExtension = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            return extension != null && !extension.trim().isEmpty() && string.equalsIgnoreCase((String)var1_1);
        });
    }
}

